/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

import com.pg85.otg.exception.InvalidConfigException;
import java.util.Collection;
import java.util.LinkedList;

public abstract class StringHelper {
    public static String join(Collection<?> coll, String glue) {
        return StringHelper.join(coll.toArray(new Object[coll.size()]), glue);
    }

    public static String join(Object[] list, String glue) {
        StringBuilder ret = new StringBuilder(100);
        for (int i = 0; i < list.length; ++i) {
            if (i != 0) {
                ret.append(glue);
            }
            ret.append(list[i]);
        }
        return ret.toString();
    }

    public static String toComputerFriendlyName(String name) {
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            charArray[i] = !Character.isJavaIdentifierPart(charArray[i]) ? 95 : Character.toLowerCase(charArray[i]);
        }
        return new String(charArray);
    }

    public static int readInt(String string, int minValue, int maxValue) throws InvalidConfigException {
        try {
            int number = Integer.parseInt(string);
            if (number < minValue) {
                return minValue;
            }
            if (number > maxValue) {
                return maxValue;
            }
            return number;
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Incorrect number: " + string);
        }
    }

    public static double readDouble(String string, double minValue, double maxValue) throws InvalidConfigException {
        try {
            double number = Double.parseDouble(string);
            if (number < minValue) {
                return minValue;
            }
            if (number > maxValue) {
                return maxValue;
            }
            return number;
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Incorrect number: " + string);
        }
    }

    public static String[] readCommaSeperatedString(String line) {
        if (line.trim().isEmpty()) {
            return new String[0];
        }
        LinkedList<String> buffer = new LinkedList<String>();
        int index = 0;
        int lastFound = 0;
        int inBracer = 0;
        for (char c : line.toCharArray()) {
            if (c == ',' && inBracer == 0) {
                buffer.add(line.substring(lastFound, index).trim());
                lastFound = index + 1;
            }
            if (c == '(') {
                ++inBracer;
            }
            if (c == ')') {
                --inBracer;
            }
            ++index;
        }
        buffer.add(line.substring(lastFound, index).trim());
        String[] output = new String[]{};
        if (inBracer == 0) {
            output = buffer.toArray(output);
        }
        return output;
    }

    public static boolean specifiesBlockData(String materialString) {
        int indexOfColon = materialString.lastIndexOf(":");
        if (indexOfColon > 0) {
            String blockDataString = materialString.substring(indexOfColon + 1);
            try {
                Integer.parseInt(blockDataString);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private StringHelper() {
    }

    public static long readLong(String string, long minValue, long maxValue) throws InvalidConfigException {
        try {
            long number = Long.parseLong(string);
            if (number < minValue) {
                return minValue;
            }
            if (number > maxValue) {
                return maxValue;
            }
            return number;
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Incorrect number: " + string);
        }
    }
}

