/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.biome.BeforeGroupsBiomeGenerator;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.FromImageBiomeGenerator;
import com.pg85.otg.generator.biome.NormalBiomeGenerator;
import com.pg85.otg.generator.biome.VanillaBiomeGenerator;

public abstract class MetricsHelper {
    protected int normalMode = 0;
    protected int fromImageMode = 0;
    protected int vanillaMode = 0;
    protected int oldBiomeMode = 0;
    protected int beforeGroupsBiomeMode = 0;
    protected int customMode = 0;

    protected void calculateBiomeModes(Iterable<? extends LocalWorld> worlds) {
        for (LocalWorld localWorld : worlds) {
            WorldConfig config = localWorld.getConfigs().getWorldConfig();
            if (config == null) continue;
            Class<? extends BiomeGenerator> clazz = config.biomeMode;
            if (clazz.equals(NormalBiomeGenerator.class)) {
                ++this.normalMode;
                continue;
            }
            if (clazz.equals(FromImageBiomeGenerator.class)) {
                ++this.fromImageMode;
                continue;
            }
            if (VanillaBiomeGenerator.class.isAssignableFrom(clazz)) {
                ++this.vanillaMode;
                continue;
            }
            if (clazz.equals(BeforeGroupsBiomeGenerator.class)) {
                ++this.beforeGroupsBiomeMode;
                continue;
            }
            ++this.customMode;
        }
    }
}

