/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.bo3;

public final class BoundingBox
implements Cloneable {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    private BoundingBox() {
    }

    public static BoundingBox newEmptyBox() {
        return new BoundingBox();
    }

    public BoundingBox clone() {
        try {
            BoundingBox cloned = (BoundingBox)super.clone();
            cloned.minX = this.minX;
            cloned.minY = this.minY;
            cloned.minZ = this.minZ;
            cloned.maxX = this.maxX;
            cloned.maxY = this.maxY;
            cloned.maxZ = this.maxZ;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public BoundingBox rotate() {
        BoundingBox cloned = new BoundingBox();
        cloned.minX = this.minZ;
        cloned.minY = this.minY;
        cloned.minZ = -this.minX;
        cloned.maxX = this.maxZ;
        cloned.maxY = this.maxY;
        cloned.maxZ = -this.maxX;
        return cloned;
    }

    public void expandToFit(int x, int y, int z) {
        if (this.isEmpty()) {
            this.setToOneBlockVolume(x, y, z);
            return;
        }
        if (x < this.minX) {
            this.minX = x;
        } else if (x >= this.maxX) {
            this.maxX = x + 1;
        }
        if (y < this.minY) {
            this.minY = y;
        } else if (y >= this.maxY) {
            this.maxY = y + 1;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z >= this.maxZ) {
            this.maxZ = z + 1;
        }
    }

    public boolean isEmpty() {
        return this.minX == this.maxX || this.minY == this.maxY || this.minZ == this.maxZ;
    }

    private void setToOneBlockVolume(int x, int y, int z) {
        this.minX = x;
        this.maxX = x + 1;
        this.minY = y;
        this.maxY = y + 1;
        this.minZ = z;
        this.maxZ = z + 1;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public int getDepth() {
        return this.maxZ - this.minZ;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxX;
        result = 31 * result + this.maxY;
        result = 31 * result + this.maxZ;
        result = 31 * result + this.minX;
        result = 31 * result + this.minY;
        result = 31 * result + this.minZ;
        return result;
    }

    public String toString() {
        return "BoundingBox[minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", depth=" + this.getDepth() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BoundingBox)) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        if (this.maxZ != other.maxZ) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        if (this.minY != other.minY) {
            return false;
        }
        return this.minZ == other.minZ;
    }
}

