/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.terrain;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.Random;

public abstract class TerrainGenBase {
    protected final LocalMaterialData air = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
    protected final LocalMaterialData lava = MaterialHelper.toLocalMaterialData(DefaultMaterial.STATIONARY_LAVA, 0);
    protected int checkAreaSize = 8;
    protected Random random = new Random();
    protected LocalWorld world;
    private final long worldLong1;
    private final long worldLong2;

    TerrainGenBase(LocalWorld world) {
        this.world = world;
        this.random.setSeed(this.world.getSeed());
        this.worldLong1 = this.random.nextLong();
        this.worldLong2 = this.random.nextLong();
    }

    public void generate(ChunkBuffer chunkBuffer) {
        int i = this.checkAreaSize;
        ChunkCoordinate chunkCoord = chunkBuffer.getChunkCoordinate();
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        for (int x = chunkX - i; x <= chunkX + i; ++x) {
            for (int z = chunkZ - i; z <= chunkZ + i; ++z) {
                long l3 = (long)x * this.worldLong1;
                long l4 = (long)z * this.worldLong2;
                this.random.setSeed(l3 ^ l4 ^ this.world.getSeed());
                this.generateChunk(ChunkCoordinate.fromChunkCoords(x, z), chunkBuffer);
            }
        }
    }

    protected abstract void generateChunk(ChunkCoordinate var1, ChunkBuffer var2);
}

