/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.generator.resource.VeinGen;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.Random;

class Vein {
    private int x;
    private int y;
    private int z;
    private int size;

    Vein(int blockX, int blockY, int blockZ, int size) {
        this.x = blockX;
        this.y = blockY;
        this.z = blockZ;
        this.size = size;
    }

    public int getChunkSize() {
        return (this.size + 15) / 16;
    }

    public boolean reachesChunk(int otherChunkX, int otherChunkZ) {
        int chunkX = (this.x + 8) / 16;
        int chunkZ = (this.z + 8) / 16;
        int chunkSize = this.getChunkSize();
        return MathHelper.abs(otherChunkX - chunkX) <= chunkSize && MathHelper.abs(otherChunkZ - chunkZ) <= chunkSize;
    }

    public void spawn(LocalWorld world, Random random, ChunkCoordinate chunkCoord, VeinGen gen) {
        int sizeSquared = this.size * this.size;
        for (int i = 0; i < gen.oreFrequency; ++i) {
            int oreZ;
            int oreY;
            int oreX;
            if (random.nextInt(100) >= gen.oreRarity || ((oreX = chunkCoord.getBlockXCenter() + random.nextInt(16)) - this.x) * (oreX - this.x) + ((oreY = RandomHelper.numberInRange(random, gen.minAltitude, gen.maxAltitude)) - this.y) * (oreY - this.y) + ((oreZ = chunkCoord.getBlockZCenter() + random.nextInt(16)) - this.z) * (oreZ - this.z) >= sizeSquared) continue;
            this.spawnOre(world, random, oreX, oreY, oreZ, gen);
        }
    }

    private void spawnOre(LocalWorld world, Random rand, int x, int y, int z, VeinGen gen) {
        int maxSize = gen.oreSize;
        LocalMaterialData material = gen.material;
        MaterialSet sourceBlocks = gen.sourceBlocks;
        float f = rand.nextFloat() * 3.141593f;
        double d1 = (float)(x + 8) + MathHelper.sin(f) * (float)maxSize / 8.0f;
        double d2 = (float)(x + 8) - MathHelper.sin(f) * (float)maxSize / 8.0f;
        double d3 = (float)(z + 8) + MathHelper.cos(f) * (float)maxSize / 8.0f;
        double d4 = (float)(z + 8) - MathHelper.cos(f) * (float)maxSize / 8.0f;
        double d5 = y + rand.nextInt(3) - 2;
        double d6 = y + rand.nextInt(3) - 2;
        for (int i = 0; i < maxSize; ++i) {
            float iFactor = (float)i / (float)maxSize;
            double d7 = d1 + (d2 - d1) * (double)iFactor;
            double d8 = d5 + (d6 - d5) * (double)iFactor;
            double d9 = d3 + (d4 - d3) * (double)iFactor;
            double d10 = rand.nextDouble() * (double)maxSize / 16.0;
            double d11 = ((double)MathHelper.sin((float)Math.PI * iFactor) + 1.0) * d10 + 1.0;
            double d12 = ((double)MathHelper.sin((float)Math.PI * iFactor) + 1.0) * d10 + 1.0;
            int j = MathHelper.floor(d7 - d11 / 2.0);
            int k = MathHelper.floor(d8 - d12 / 2.0);
            int m = MathHelper.floor(d9 - d11 / 2.0);
            int n = MathHelper.floor(d7 + d11 / 2.0);
            int i1 = MathHelper.floor(d8 + d12 / 2.0);
            int i2 = MathHelper.floor(d9 + d11 / 2.0);
            for (int i3 = j; i3 <= n; ++i3) {
                double d13 = ((double)i3 + 0.5 - d7) / (d11 / 2.0);
                if (!(d13 * d13 < 1.0)) continue;
                for (int i4 = k; i4 <= i1; ++i4) {
                    double d14 = ((double)i4 + 0.5 - d8) / (d12 / 2.0);
                    if (!(d13 * d13 + d14 * d14 < 1.0)) continue;
                    for (int i5 = m; i5 <= i2; ++i5) {
                        double d15 = ((double)i5 + 0.5 - d9) / (d11 / 2.0);
                        if (!(d13 * d13 + d14 * d14 + d15 * d15 < 1.0) || !sourceBlocks.contains(world.getMaterial(i3, i4, i5, false))) continue;
                        world.setBlock(i3, i4, i5, material, null, false);
                    }
                }
            }
        }
    }
}

