/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class ReedGen
extends Resource {
    private final int maxAltitude;
    private final int minAltitude;
    private final MaterialSet sourceBlocks;

    public ReedGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(6, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 256);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 5);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ReedGen compare = (ReedGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return -34;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + super.hashCode();
        hash = 23 * hash + this.minAltitude;
        hash = 23 * hash + this.maxAltitude;
        hash = 23 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "Reed(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        LocalMaterialData materialA = world.getMaterial(x - 1, y - 1, z, false);
        LocalMaterialData materialB = world.getMaterial(x + 1, y - 1, z, false);
        LocalMaterialData materialC = world.getMaterial(x, y - 1, z - 1, false);
        LocalMaterialData materialD = world.getMaterial(x, y - 1, z + 1, false);
        if (y > this.maxAltitude || y < this.minAltitude || materialA != null && !materialA.isLiquid() && materialB != null && !materialB.isLiquid() && materialC != null && !materialC.isLiquid() && materialD != null && !materialD.isLiquid()) {
            return;
        }
        LocalMaterialData worldMaterial = world.getMaterial(x, y - 1, z, false);
        if (worldMaterial == null || !this.sourceBlocks.contains(worldMaterial)) {
            return;
        }
        int n = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < n; ++i1) {
            world.setBlock(x, y + i1, z, this.material, null, false);
        }
    }
}

