/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.PlantType;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class PlantGen
extends Resource {
    private final int maxAltitude;
    private final int minAltitude;
    private final PlantType plant;
    private final MaterialSet sourceBlocks;

    public PlantGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(6, args);
        this.plant = PlantType.getPlant(args.get(0));
        this.material = this.plant.getBottomMaterial();
        this.frequency = this.readInt(args.get(1), 1, 100);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 256);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 5);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PlantGen compare = (PlantGen)other;
        return this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return -33;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + super.hashCode();
        hash = 71 * hash + this.minAltitude;
        hash = 71 * hash + this.maxAltitude;
        hash = 71 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return "Plant(" + this.plant.getName() + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int y = RandomHelper.numberInRange(rand, this.minAltitude, this.maxAltitude);
        for (int i = 0; i < 64; ++i) {
            int m;
            int k;
            int j = x + rand.nextInt(8) - rand.nextInt(8);
            if (!world.isNullOrAir(j, k = y + rand.nextInt(4) - rand.nextInt(4), m = z + rand.nextInt(8) - rand.nextInt(8), false) || !this.sourceBlocks.contains(world.getMaterial(j, k - 1, m, false))) continue;
            this.plant.spawn(world, j, k, m);
        }
    }
}

