/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.List;
import java.util.Random;

public final class FossilGen
extends Resource {
    public FossilGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(1, args);
        this.rarity = this.readRarity(args.get(0));
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        if (random.nextDouble() * 100.0 > this.rarity) {
            return;
        }
        world.placeFossil(random, chunkCoord);
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return this.getClass() == other.getClass();
    }

    @Override
    public int getPriority() {
        return -21;
    }

    @Override
    public String toString() {
        return "Fossil(" + this.rarity + ")";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }
}

