/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class BoulderGen
extends Resource {
    private MaterialSet sourceBlocks;
    private int minAltitude;
    private int maxAltitude;

    public BoulderGen(BiomeConfig config, List<String> args) throws InvalidConfigException {
        super(config);
        this.assureSize(6, args);
        this.material = this.readMaterial(args.get(0));
        this.frequency = this.readInt(args.get(1), 1, 5000);
        this.rarity = this.readRarity(args.get(2));
        this.minAltitude = this.readInt(args.get(3), 0, 256);
        this.maxAltitude = this.readInt(args.get(4), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 5);
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
        LocalMaterialData material;
        int y = world.getHighestBlockYAt(x, z);
        if (y < this.minAltitude || y > this.maxAltitude) {
            return;
        }
        while (y > 3 && !this.sourceBlocks.contains(material = world.getMaterial(x, y - 1, z, false))) {
            --y;
        }
        if (y <= 3) {
            return;
        }
        int i = 0;
        for (int j = 0; i >= 0 && j < 3; ++j) {
            int k = i + random.nextInt(2);
            int m = i + random.nextInt(2);
            int n = i + random.nextInt(2);
            float f1 = (float)(k + m + n) * 0.333f + 0.5f;
            for (int i1 = x - k; i1 <= x + k; ++i1) {
                for (int i2 = z - n; i2 <= z + n; ++i2) {
                    for (int i3 = y - m; i3 <= y + m; ++i3) {
                        float f2 = i1 - x;
                        float f3 = i2 - z;
                        float f4 = i3 - y;
                        if (!(f2 * f2 + f3 * f3 + f4 * f4 <= f1 * f1)) continue;
                        world.setBlock(i1, i3, i2, this.material, null, false);
                    }
                }
            }
            x += random.nextInt(2 + i * 2) - 1 - i;
            z += random.nextInt(2 + i * 2) - 1 - i;
            y -= random.nextInt(2);
        }
    }

    @Override
    public String toString() {
        return "Boulder(" + this.material + "," + this.frequency + "," + this.rarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public int getPriority() {
        return -22;
    }
}

