/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.world;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.common.WorldSession;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.pregenerator.Pregenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class ForgeWorldSession
extends WorldSession {
    private int worldBorderRadius;
    private ChunkCoordinate worldBorderCenterPoint;
    private ArrayList<ParticleFunction<?>> particleFunctions = new ArrayList();
    private Pregenerator pregenerator;

    public ForgeWorldSession(LocalWorld world) {
        super(world);
        this.pregenerator = new Pregenerator(world);
        if (((ForgeWorld)world).world != null) {
            this.loadWorldBorderData();
        }
    }

    public Pregenerator getPregenerator() {
        return this.pregenerator;
    }

    @Override
    public ArrayList<ParticleFunction<?>> getParticleFunctions() {
        return this.particleFunctions;
    }

    @Override
    public int getWorldBorderRadius() {
        return this.worldBorderRadius;
    }

    @Override
    public ChunkCoordinate getWorldBorderCenterPoint() {
        return this.worldBorderCenterPoint;
    }

    @Override
    public int getPregenerationRadius() {
        return this.pregenerator.getPregenerationRadius();
    }

    @Override
    public int setPregenerationRadius(int value) {
        return this.pregenerator.setPregenerationRadius(value);
    }

    @Override
    public int getPregeneratedBorderLeft() {
        return this.pregenerator.getPregenerationBorderLeft();
    }

    @Override
    public int getPregeneratedBorderRight() {
        return this.pregenerator.getPregenerationBorderRight();
    }

    @Override
    public int getPregeneratedBorderTop() {
        return this.pregenerator.getPregenerationBorderTop();
    }

    @Override
    public int getPregeneratedBorderBottom() {
        return this.pregenerator.getPregenerationBorderBottom();
    }

    @Override
    public ChunkCoordinate getPreGeneratorCenterPoint() {
        return this.pregenerator.getPregenerationCenterPoint();
    }

    @Override
    public boolean getPreGeneratorIsRunning() {
        return this.pregenerator.getPregeneratorIsRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveWorldBorderData() {
        int dimensionId = this.world.getDimensionId();
        File worldBorderFile = new File(this.world.getWorldSaveDir() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + "WorldBorder.txt");
        if (worldBorderFile.exists()) {
            worldBorderFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append(this.worldBorderRadius + "," + this.worldBorderCenterPoint.getChunkX() + "," + this.worldBorderCenterPoint.getChunkZ());
        BufferedWriter writer = null;
        try {
            worldBorderFile.getParentFile().mkdirs();
            writer = new BufferedWriter(new FileWriter(worldBorderFile));
            writer.write(stringbuilder.toString());
            OTG.log(LogMarker.DEBUG, "World border data saved", new Object[0]);
        }
        catch (IOException e) {
            OTG.log(LogMarker.ERROR, "Could not save world border data.", new Object[0]);
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorldBorderData() {
        int dimensionId = this.world.getDimensionId();
        File worldBorderFile = new File(this.world.getWorldSaveDir() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + "WorldBorder.txt");
        String[] worldBorderFileValues = new String[]{};
        if (worldBorderFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(worldBorderFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        worldBorderFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.DEBUG, "Pre-generator data loaded", new Object[0]);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (worldBorderFileValues.length > 0) {
            this.worldBorderRadius = Integer.parseInt(worldBorderFileValues[0]);
            this.worldBorderCenterPoint = ChunkCoordinate.fromChunkCoords(Integer.parseInt(worldBorderFileValues[1]), Integer.parseInt(worldBorderFileValues[2]));
        } else {
            DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(this.world.getName());
            this.worldBorderRadius = dimConfig.WorldBorderRadiusInChunks;
            this.worldBorderCenterPoint = this.world.getSpawnChunk();
            this.saveWorldBorderData();
        }
    }
}

