/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.server.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.bo3.bo3function.BO3ParticleFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.events.client.ClientTickHandler;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.client.AbstractClientMessageHandler;
import com.pg85.otg.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticlesPacket
extends OTGPacket {
    public ParticlesPacket() {
    }

    public ParticlesPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeToStream(ArrayList<ParticleFunction<?>> particleDataForOTGPerPlayer, DataOutput stream) throws IOException {
        stream.writeInt(6);
        stream.writeInt(0);
        StringBuilder sb = new StringBuilder();
        if (particleDataForOTGPerPlayer != null) {
            for (ParticleFunction<?> particleData : particleDataForOTGPerPlayer) {
                sb.append(particleData.makeStringForPacket());
            }
        }
        String value = sb.toString();
        byte[] bytes = value.getBytes();
        stream.writeShort(bytes.length);
        stream.write(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParticlesPacket createEmptyPacket() {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        ParticlesPacket packet = new ParticlesPacket(nettyBuffer);
        try {
            ParticlesPacket.writeToStream(null, (DataOutput)stream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return packet;
    }

    public static class Handler
    extends AbstractClientMessageHandler<ParticlesPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleClientMessage(EntityPlayer player, ParticlesPacket message, MessageContext ctx) {
            block13: {
                try {
                    int packetType = message.getStream().readInt();
                    if (packetType == 0) {
                        String particleFunctionString;
                        ArrayList<BO4ParticleFunction> particleFunctions = new ArrayList<BO4ParticleFunction>();
                        short msgLength = message.getStream().readShort();
                        byte[] chars = new byte[msgLength];
                        if (message.getStream().read(chars, 0, chars.length) == chars.length && (particleFunctionString = new String(chars)) != null && particleFunctionString.length() > 0 && particleFunctionString.startsWith("Particle(")) {
                            String[] particleStrings;
                            ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(player.func_130014_f_());
                            for (String particleString : particleStrings = particleFunctionString.replace(")", "").replace("Particle(", "'").split("'")) {
                                String[] stringArray = particleString.split(",");
                                if (stringArray.length != 11) continue;
                                ParticleFunction particle = world.getConfigs().getWorldConfig().isOTGPlus ? new BO4ParticleFunction() : new BO3ParticleFunction();
                                particle.x = Integer.parseInt(stringArray[0]);
                                particle.y = Integer.parseInt(stringArray[1]);
                                particle.z = Integer.parseInt(stringArray[2]);
                                particle.particleName = stringArray[3];
                                particle.interval = Double.parseDouble(stringArray[4]);
                                particle.velocityX = Double.parseDouble(stringArray[5]);
                                particle.velocityY = Double.parseDouble(stringArray[6]);
                                particle.velocityZ = Double.parseDouble(stringArray[7]);
                                particle.velocityXSet = Boolean.parseBoolean(stringArray[8]);
                                particle.velocityYSet = Boolean.parseBoolean(stringArray[9]);
                                particle.velocityZSet = Boolean.parseBoolean(stringArray[10]);
                                particleFunctions.add((BO4ParticleFunction)particle);
                            }
                        }
                        ArrayList existingParticleFunctions = new ArrayList();
                        ArrayList<ParticleFunction> newParticleFunctions = new ArrayList<ParticleFunction>();
                        ArrayList<ParticleFunction<?>> arrayList = ClientTickHandler.ClientParticleFunctions;
                        synchronized (arrayList) {
                            existingParticleFunctions.addAll(ClientTickHandler.ClientParticleFunctions);
                            ClientTickHandler.ClientParticleFunctions.clear();
                            for (ParticleFunction particleFunction : particleFunctions) {
                                boolean bFound = false;
                                for (ParticleFunction particleFunction2 : existingParticleFunctions) {
                                    if (particleFunction.x != particleFunction2.x || particleFunction.y != particleFunction2.y || particleFunction.z != particleFunction2.z) continue;
                                    bFound = true;
                                    if (newParticleFunctions.contains(particleFunction2)) continue;
                                    newParticleFunctions.add(particleFunction2);
                                }
                                if (bFound) continue;
                                newParticleFunctions.add(particleFunction);
                            }
                            ClientTickHandler.ClientParticleFunctions.addAll(newParticleFunctions);
                            break block13;
                        }
                    }
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
                finally {
                    message.getData().release();
                }
            }
            return null;
        }
    }
}

