/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.presets;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.gui.OTGGuiEnterWorldName;
import com.pg85.otg.forge.gui.OTGGuiScrollingList;
import com.pg85.otg.forge.gui.dimensions.OTGGuiDimensionList;
import com.pg85.otg.forge.gui.mainmenu.OTGGuiWorldSelection;
import com.pg85.otg.forge.gui.presets.OTGGuiScrollingListInfo;
import com.pg85.otg.forge.gui.presets.OTGGuiSlotPresetList;
import com.pg85.otg.forge.util.IOHelper;
import com.pg85.otg.logging.LogMarker;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Mouse;

public class OTGGuiPresetList
extends GuiScreen
implements GuiYesNoCallback {
    private static boolean ShowingOpenLinkDialogue = false;
    GuiScreen previousMenu;
    private OTGGuiSlotPresetList presetsList;
    private OTGGuiScrollingList presetInfo;
    private int selected = -1;
    public Tuple<String, DimensionConfigGui> selectedPreset;
    private GuiButton btnDelete;
    private GuiButton btnContinue;
    int listWidth = 150;
    int topMargin = 37;
    int bottomMargin = 73;
    private int btnBottomMargin = 63;
    int leftMargin = 10;
    int rightMargin = 10;
    int slotHeight = 16;
    int margin = 20;
    private final int iContinueButton = 0;
    private final int iCancelButton = 1;
    private final int iNewButton = 2;
    private final int iCloneButton = 4;
    private final int iDeleteButton = 3;
    private boolean askDeleteSettings = false;
    private boolean selectingNewPresetName = true;
    private boolean selectingClonePresetName = true;
    public String newPresetName;
    private int wikiBtnLeft;
    private int wikiBtnTop;
    private int wikiBtnWidth;
    private int wikiBtnHeight;
    private int wikiBtnRight;
    private int wikiBtnBottom;
    private boolean selectingPresetForDimension;

    public OTGGuiPresetList(GuiScreen previousMenu) {
        this(previousMenu, false);
    }

    public OTGGuiPresetList(GuiScreen previousMenu, boolean selectingPresetForDimension) {
        ShowingOpenLinkDialogue = false;
        this.previousMenu = previousMenu;
        this.selectingPresetForDimension = selectingPresetForDimension;
    }

    public boolean func_73868_f() {
        return false;
    }

    Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    void selectPresetIndex(int index) {
        if (index >= ForgeEngine.Presets.size()) {
            return;
        }
        this.selected = index;
        Map.Entry<String, DimensionConfigGui> entry = index >= 0 ? new ArrayList<Map.Entry<String, DimensionConfigGui>>(ForgeEngine.Presets.entrySet()).get(this.selected) : null;
        this.selectedPreset = entry != null ? new Tuple((Object)entry.getKey(), (Object)entry.getValue()) : null;
        this.updateCache();
    }

    boolean presetIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        this.presetInfo = null;
        boolean bl = this.btnContinue.field_146124_l = this.selectedPreset != null;
        if (this.selectedPreset == null) {
            this.presetInfo = new OTGGuiScrollingListInfo(this, null, null, null);
            return;
        }
        ArrayList<String> presets = new ArrayList<String>(ForgeEngine.Presets.keySet());
        if (this.previousMenu instanceof OTGGuiDimensionList) {
            boolean bFound = false;
            for (DimensionConfig dimConfig : ((OTGGuiDimensionList)this.previousMenu).dimensions) {
                if ((dimConfig.PresetName == null || !dimConfig.PresetName.equals(presets.get(this.selected))) && (dimConfig.PresetName != null || !OTG.getDimensionsConfig().WorldName.equals(presets.get(this.selected)))) continue;
                bFound = true;
                break;
            }
            this.btnContinue.field_146124_l = !bFound;
            this.btnDelete.field_146124_l = !bFound;
        } else {
            this.btnContinue.field_146124_l = true;
            this.btnDelete.field_146124_l = true;
        }
        String modId = ((DimensionConfigGui)this.selectedPreset.func_76340_b()).worldPackerModName;
        ModContainer presetWorldPackerMod = null;
        ResourceLocation logoPath = null;
        String description = null;
        String version = null;
        String credits = null;
        String url = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        if (modId != null) {
            for (ModContainer mod : Loader.instance().getModList()) {
                if (!mod.getModId().equals(modId)) continue;
                presetWorldPackerMod = mod;
                break;
            }
        }
        if (presetWorldPackerMod == null) {
            modId = "openterraingenerator";
            presetWorldPackerMod = Loader.instance().activeModContainer();
        }
        if (presetWorldPackerMod != null && presetWorldPackerMod.getMetadata() != null) {
            if (modId != "openterraingenerator") {
                description = presetWorldPackerMod.getMetadata().description;
                version = presetWorldPackerMod.getMetadata().version;
                credits = presetWorldPackerMod.getMetadata().credits;
                url = presetWorldPackerMod.getMetadata().url;
            }
            if (!presetWorldPackerMod.getMetadata().logoFile.isEmpty()) {
                TextureManager tm = this.field_146297_k.func_110434_K();
                IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(modId);
                try {
                    BufferedImage logo = null;
                    if (pack != null) {
                        logo = pack.func_110586_a();
                    } else {
                        InputStream logoResource = ((Object)((Object)this)).getClass().getResourceAsStream(presetWorldPackerMod.getMetadata().logoFile);
                        if (logoResource != null) {
                            logo = ImageIO.read(logoResource);
                        }
                    }
                    if (logo != null) {
                        logoPath = tm.func_110578_a("modlogo", new DynamicTexture(logo));
                        logoDims = new Dimension(logo.getWidth(), logo.getHeight());
                    }
                }
                catch (IOException logo) {
                    // empty catch block
                }
            }
        }
        lines.add("Name: " + (String)this.selectedPreset.func_76341_a());
        lines.add("Version: " + (version != null ? version : "Unknown"));
        lines.add("Credits: " + (credits != null ? credits : ((DimensionConfigGui)this.selectedPreset.func_76340_b()).author));
        if (url != null) {
            lines.add("URL: " + url);
        }
        if (((DimensionConfigGui)this.selectedPreset.func_76340_b()).dimensions.size() > 0) {
            String dimsString = "";
            for (int i = 0; i < ((DimensionConfigGui)this.selectedPreset.func_76340_b()).dimensions.size(); ++i) {
                String dimName = ((DimensionConfigGui)this.selectedPreset.func_76340_b()).dimensions.get(i);
                boolean bFound = ForgeEngine.Presets.containsKey(dimName);
                dimsString = bFound ? dimsString + dimName + (i == ((DimensionConfigGui)this.selectedPreset.func_76340_b()).dimensions.size() - 1 ? "" : ", ") : dimsString + TextFormatting.GRAY + dimName + " (Not installed)" + TextFormatting.RESET + ", ";
            }
            lines.add("Dimensions: " + dimsString);
        }
        lines.add("");
        lines.add(description != null ? description : ((DimensionConfigGui)this.selectedPreset.func_76340_b()).description);
        lines.add("");
        this.presetInfo = new OTGGuiScrollingListInfo(this, lines, logoPath, logoDims);
    }

    private GuiYesNo askDeleteSettings(GuiYesNoCallback p_152129_0_, String worldName) {
        this.selectingNewPresetName = false;
        this.selectingClonePresetName = false;
        this.askDeleteSettings = true;
        String s1 = "Delete the OpenTerrainGenerator preset for '" + worldName + "'?";
        String s2 = "";
        String s3 = "Delete";
        String s4 = "Cancel";
        GuiYesNo guiyesno = new GuiYesNo(p_152129_0_, s1, s2, s3, s4, 0);
        return guiyesno;
    }

    public void func_73866_w_() {
        if (this.field_146297_k.field_71441_e == null || Minecraft.func_71410_x().func_71356_B()) {
            ForgeEngine.loadPresets();
        }
        if (ForgeEngine.Presets.size() > 0) {
            int selectPreset;
            ArrayList<String> presets = new ArrayList<String>(ForgeEngine.Presets.keySet());
            this.selected = selectPreset = 0;
            if (selectPreset > -1) {
                Map.Entry<String, DimensionConfigGui> entry = new ArrayList<Map.Entry<String, DimensionConfigGui>>(ForgeEngine.Presets.entrySet()).get(selectPreset);
                this.selectedPreset = new Tuple((Object)entry.getKey(), (Object)entry.getValue());
            } else {
                this.selectedPreset = null;
            }
        }
        if (this.presetsList == null) {
            this.presetsList = new OTGGuiSlotPresetList(this, this);
            this.presetInfo = new OTGGuiScrollingListInfo(this, null, null, null);
        } else {
            this.presetsList.resize();
        }
        GuiButton btnNew = new GuiButton(2, this.leftMargin, this.field_146295_m - this.btnBottomMargin, (this.listWidth - 3) / 2 + 1, 20, "New");
        btnNew.field_146124_l = this.field_146297_k.field_71441_e == null || this.field_146297_k.func_71356_B();
        this.field_146292_n.add(btnNew);
        GuiButton btnClone = new GuiButton(4, this.leftMargin + (this.listWidth - 3) / 2 + 3 + 2, this.field_146295_m - this.btnBottomMargin, (this.listWidth - 3) / 2, 20, "Clone");
        btnClone.field_146124_l = this.field_146297_k.field_71441_e == null || this.field_146297_k.func_71356_B();
        this.field_146292_n.add(btnClone);
        this.btnDelete = new GuiButton(3, this.leftMargin, this.field_146295_m - (this.btnBottomMargin - 24), this.listWidth, 20, "Delete");
        this.btnDelete.field_146124_l = this.field_146297_k.field_71441_e == null || this.field_146297_k.func_71356_B();
        this.field_146292_n.add(this.btnDelete);
        int maxBtnWidth = 330;
        int btnWidth = this.field_146294_l - this.listWidth - this.margin - this.rightMargin;
        btnWidth = btnWidth > maxBtnWidth ? maxBtnWidth : btnWidth;
        this.btnContinue = new GuiButton(0, this.listWidth + this.margin, this.field_146295_m - this.btnBottomMargin, btnWidth, 20, "Continue");
        this.field_146292_n.add(this.btnContinue);
        this.field_146292_n.add(new GuiButton(1, this.listWidth + this.margin, this.field_146295_m - (this.btnBottomMargin - 24), btnWidth, 20, "Cancel"));
        this.updateCache();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.presetsList.drawScreen(mouseX, mouseY, partialTicks, this.field_73735_i);
        if (this.presetInfo != null) {
            this.presetInfo.drawScreen(mouseX, mouseY, partialTicks, this.field_73735_i);
        }
        this.func_73732_a(this.field_146289_q, "Select a preset", this.field_146294_l / 2, 16, 0xFFFFFF);
        this.wikiBtnWidth = this.field_146289_q.func_78256_a("Wiki");
        this.wikiBtnHeight = 6;
        this.wikiBtnLeft = this.field_146294_l - (this.rightMargin + this.field_146289_q.func_78256_a("Wiki")) - 2;
        this.wikiBtnRight = this.wikiBtnLeft + this.wikiBtnWidth;
        this.wikiBtnTop = 16;
        this.wikiBtnBottom = this.wikiBtnTop + this.wikiBtnHeight;
        this.func_73731_b(this.field_146289_q, TextFormatting.UNDERLINE + "Wiki", this.wikiBtnLeft, this.wikiBtnTop, 0x5555FF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.field_146289_q.func_78276_b(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.previousMenu instanceof OTGGuiDimensionList) {
                        this.field_146297_k.func_147108_a(this.previousMenu);
                    } else if (this.selectingPresetForDimension) {
                        this.selectingPresetForDimension = false;
                        this.field_146297_k.func_147108_a(this.previousMenu);
                    } else {
                        this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiDimensionList(this));
                    }
                    return;
                }
                case 1: {
                    this.selectedPreset = null;
                    if (this.selectingPresetForDimension) {
                        this.selectingPresetForDimension = false;
                        this.field_146297_k.func_147108_a(this.previousMenu);
                    } else {
                        this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiWorldSelection());
                    }
                    return;
                }
                case 2: {
                    this.askDeleteSettings = false;
                    this.selectingClonePresetName = false;
                    this.selectingNewPresetName = true;
                    this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiEnterWorldName(this, "New World"));
                    return;
                }
                case 4: {
                    if (this.selectedPreset != null) {
                        this.askDeleteSettings = false;
                        this.selectingNewPresetName = false;
                        this.selectingClonePresetName = true;
                        this.field_146297_k.func_147108_a((GuiScreen)new OTGGuiEnterWorldName(this, (String)this.selectedPreset.func_76341_a()));
                        return;
                    }
                }
                case 3: {
                    if (this.selectedPreset != null) {
                        this.field_146297_k.func_147108_a((GuiScreen)this.askDeleteSettings(this, (String)this.selectedPreset.func_76341_a()));
                    }
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    public void func_73878_a(boolean ok, int worldId) {
        if (this.askDeleteSettings) {
            if (ok && (this.field_146297_k.field_71441_e == null || Minecraft.func_71410_x().func_71356_B())) {
                String presetNameToDelete = (String)this.selectedPreset.func_76341_a();
                GuiYesNo guiyesno = this.askDeleteSettings(this, presetNameToDelete);
                this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
                File OTGWorldsDirectory = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds");
                if (OTGWorldsDirectory.exists() && OTGWorldsDirectory.isDirectory()) {
                    for (File worldDir : OTGWorldsDirectory.listFiles()) {
                        if (!worldDir.isDirectory() || !worldDir.getName().equals(presetNameToDelete)) continue;
                        IOHelper.deleteRecursive(worldDir);
                        break;
                    }
                }
                ForgeEngine.loadPresets();
                if (this.presetsList.getSize() == 0) {
                    this.presetsList.selectedIndex = -1;
                } else if (this.presetsList.selectedIndex > this.presetsList.getSize() - 1) {
                    this.presetsList.selectedIndex = this.presetsList.getSize() - 1;
                }
                this.presetsList.lastClickTime = System.currentTimeMillis();
                this.selectPresetIndex(this.presetsList.selectedIndex);
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        } else if (this.selectingNewPresetName) {
            if (ok) {
                ((ForgeEngine)OTG.getEngine()).getWorldLoader().createDefaultOTGWorld(this.newPresetName);
                ForgeEngine.loadPresets();
            }
        } else if (this.selectingClonePresetName && ok) {
            String presetNameToClone = (String)this.selectedPreset.func_76341_a();
            File sourceDir = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + "/worlds/" + presetNameToClone);
            File destDir = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + "/worlds/" + this.newPresetName);
            try {
                FileUtils.copyDirectory((File)sourceDir, (File)destDir);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.field_146297_k.func_147108_a((GuiScreen)new GuiErrorScreen("Error", "Could not copy directory \"" + presetNameToClone + "\", files may be in use."));
                return;
            }
        }
        if (ShowingOpenLinkDialogue && ok) {
            try {
                this.openWebLink(new URI("http://openterraingen.wikia.com/wiki/In-game_tools_and_console_commands"));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
            return;
        }
        if (ShowingOpenLinkDialogue && !ok) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
        }
        this.askDeleteSettings = false;
        this.selectingNewPresetName = false;
        this.selectingClonePresetName = false;
        ShowingOpenLinkDialogue = false;
        super.func_73878_a(ok, worldId);
    }

    public void func_146274_d() throws IOException {
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        super.func_146274_d();
        if (this.presetInfo != null) {
            this.presetInfo.handleMouseInput(mouseX, mouseY);
        }
        this.presetsList.handleMouseInput(mouseX, mouseY);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.wikiLinkClicked(mouseX, mouseY)) {
            ShowingOpenLinkDialogue = true;
            GuiConfirmOpenLink gui = new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://openterraingen.wikia.com/wiki/In-game_tools_and_console_commands", 0, true);
            gui.func_146358_g();
            this.field_146297_k.func_147108_a((GuiScreen)gui);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            OTG.log(LogMarker.ERROR, "Couldn't open link: {}", throwable == null ? "<UNKNOWN>" : throwable.getMessage());
        }
    }

    private boolean wikiLinkClicked(int mouseX, int mouseY) {
        return mouseX >= this.wikiBtnLeft && mouseX <= this.wikiBtnRight && mouseY >= this.wikiBtnTop && mouseY <= this.wikiBtnBottom;
    }
}

