/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.gui.OTGGuiScrollingList;
import com.pg85.otg.forge.gui.dimensions.OTGGuiDimensionList;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;

class OTGGuiSlotDimensionList
extends OTGGuiScrollingList {
    private final OTGGuiDimensionList otgGuiDimensionList;
    private OTGGuiDimensionList parent;
    private ArrayList<DimensionConfig> dimensions;

    public OTGGuiSlotDimensionList(OTGGuiDimensionList otgGuiDimensionList, OTGGuiDimensionList parent, ArrayList<DimensionConfig> dimensions) {
        super(parent.getMinecraftInstance(), otgGuiDimensionList.listWidth, parent.field_146295_m, otgGuiDimensionList.topMargin, otgGuiDimensionList.field_146295_m - otgGuiDimensionList.bottomMargin, otgGuiDimensionList.leftMargin, otgGuiDimensionList.slotHeight, parent.field_146294_l, parent.field_146295_m);
        this.otgGuiDimensionList = otgGuiDimensionList;
        this.parent = parent;
        this.dimensions = dimensions;
    }

    public void resize() {
        this.listWidth = this.otgGuiDimensionList.listWidth;
        this.top = this.otgGuiDimensionList.topMargin;
        this.bottom = this.otgGuiDimensionList.field_146295_m - this.otgGuiDimensionList.bottomMargin;
        this.slotHeight = this.otgGuiDimensionList.slotHeight;
        this.left = this.otgGuiDimensionList.leftMargin;
        this.right = this.otgGuiDimensionList.listWidth + this.left;
    }

    @Override
    protected int getSize() {
        return this.dimensions.size();
    }

    @Override
    protected boolean isSelected(int index) {
        return this.parent.isDimensionIndexSelected(index);
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + 1;
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick) {
        this.parent.dimensionSettingsList.mouseClicked(0, 0, 0);
        this.parent.selectDimensionIndex(index);
    }

    @Override
    protected void drawBackground() {
        if (this.otgGuiDimensionList.field_146297_k.field_71441_e == null) {
            this.parent.func_146276_q_();
        }
    }

    @Override
    protected void drawSlot(int idx, int right, int top, int height, Tessellator tess) {
        DimensionConfig dimConfig = this.dimensions.get(idx);
        String name = StringUtils.func_76338_a((String)(dimConfig.PresetName != null && dimConfig.PresetName.length() > 0 ? dimConfig.PresetName : (idx == 0 ? "Overworld" : "Dimension " + idx)));
        FontRenderer font = this.parent.getFontRenderer();
        boolean isNewDim = dimConfig.isNewConfig;
        boolean isLoaded = false;
        boolean isBeingCreatedOnServer = false;
        if (!isNewDim) {
            if (this.parent.field_146297_k.field_71441_e == null || this.parent.field_146297_k.func_71356_B()) {
                ForgeWorld forgeWorld = this.parent.field_146297_k.field_71441_e != null && idx != 0 ? (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.dimensions.get((int)idx).PresetName) : null;
                isLoaded = idx == 0 || forgeWorld != null;
            } else {
                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(this.dimensions.get((int)idx).PresetName);
                if (forgeWorld == null) {
                    forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(this.dimensions.get((int)idx).PresetName);
                }
                isBeingCreatedOnServer = idx != 0 && forgeWorld == null;
                isLoaded = idx == 0 || forgeWorld != null && forgeWorld.isLoadedOnServer;
            }
        }
        font.func_78276_b(font.func_78269_a(name + (isBeingCreatedOnServer ? TextFormatting.GRAY + " (creating)" + TextFormatting.RESET : (this.parent.field_146297_k.field_71441_e != null ? (isLoaded ? TextFormatting.GREEN + " (loaded)" + TextFormatting.RESET : (isNewDim ? TextFormatting.GOLD + " (new)" + TextFormatting.RESET : TextFormatting.DARK_GREEN + " (unloaded)" + TextFormatting.RESET)) : "")), this.listWidth - 10), this.left + 3, top + 2, 0xFFFFFF);
    }
}

