/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.generator.structure.OTGMapGenStructure;
import com.pg85.otg.forge.generator.structure.OTGVillageStart;
import com.pg85.otg.network.ServerConfigProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureStart;

public class OTGVillageGen
extends OTGMapGenStructure {
    public List<Biome> villageSpawnBiomes;
    private int size;
    private int distance;
    private int minimumDistance;

    public OTGVillageGen(ServerConfigProvider configs, ForgeWorld world) {
        super(world);
        this.size = configs.getWorldConfig().villageSize;
        this.distance = configs.getWorldConfig().villageDistance;
        this.minimumDistance = 8;
        this.villageSpawnBiomes = new ArrayList<Biome>();
        for (LocalBiome biome : configs.getBiomeArrayByOTGId()) {
            if (biome == null || biome.getBiomeConfig().villageType == BiomeConfig.VillageType.disabled) continue;
            this.villageSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean canSpawn;
        int var3 = chunkX;
        int var4 = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int var5 = chunkX / this.distance;
        int var6 = chunkZ / this.distance;
        Random var7 = this.field_75039_c.func_72843_D(var5, var6, 10387312);
        var5 *= this.distance;
        var6 *= this.distance;
        return var3 == (var5 += var7.nextInt(this.distance - this.minimumDistance)) && var4 == (var6 += var7.nextInt(this.distance - this.minimumDistance)) && (canSpawn = this.field_75039_c.func_72959_q().func_76940_a(var3 * 16 + 8, var4 * 16 + 8, 0, this.villageSpawnBiomes));
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new OTGVillageStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.size);
    }

    public String func_143025_a() {
        return "OTGVillage";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        this.field_75039_c = worldIn;
        return OTGVillageGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.distance, (int)8, (int)10387312, (boolean)false, (int)100, (boolean)p_180706_3_);
    }
}

