/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events.server;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.events.server.OTGCommandHandler;
import com.pg85.otg.forge.world.OTGWorldType;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

public class ServerEventListener {
    public static void serverAboutToStart(FMLServerAboutToStartEvent event) {
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().unloadAndUnregisterAllWorlds();
        ForgeEngine.loadPresets();
    }

    public static void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new OTGCommandHandler());
        WorldServer overWorld = DimensionManager.getWorld((int)0);
        if (overWorld.func_72912_H().func_82571_y().equals("OpenTerrainGenerator") && !(overWorld.func_72912_H().func_76067_t() instanceof OTGWorldType)) {
            ISaveHandler isavehandler = overWorld.func_72860_G();
            WorldInfo worldInfo = isavehandler.func_75757_d();
            if (worldInfo != null) {
                overWorld.func_72912_H().func_76085_a((WorldType)OTGPlugin.OtgWorldType);
                worldInfo.func_76085_a((WorldType)OTGPlugin.OtgWorldType);
                isavehandler.func_75761_a(worldInfo);
            }
            throw new RuntimeException("OTG has detected that you are loading an OTG world that has been used without OTG installed. OTG has fixed and saved the world data, you can now restart the game and enter the world.");
        }
        if (!overWorld.field_72995_K) {
            if (OTG.getDimensionsConfig() == null) {
                DimensionsConfig dimsConfig = DimensionsConfig.loadFromFile(overWorld.func_72860_G().func_75765_b());
                if (dimsConfig == null) {
                    dimsConfig = new DimensionsConfig(overWorld.func_72860_G().func_75765_b());
                    if (!overWorld.func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) {
                        dimsConfig.Overworld = new DimensionConfig();
                        DimensionsConfig modPackConfig = DimensionsConfig.getModPackConfig(null);
                        if (modPackConfig != null) {
                            dimsConfig.Overworld = modPackConfig.Overworld;
                            ArrayList<DimensionConfig> newDimensions = new ArrayList<DimensionConfig>();
                            for (DimensionConfig dimConfig : modPackConfig.Dimensions) {
                                File worldConfigFile;
                                if (OTGDimensionManager.isDimensionNameRegistered(dimConfig.PresetName) || !(worldConfigFile = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds" + File.separator + dimConfig.PresetName + File.separator + "WorldConfig.ini")).exists()) continue;
                                newDimensions.add(dimConfig);
                            }
                            dimsConfig.Dimensions = newDimensions;
                        }
                    }
                    dimsConfig.save();
                }
                OTG.setDimensionsConfig(dimsConfig);
            }
            OTGDimensionManager.LoadCustomDimensionData();
            for (DimensionConfig dimConfig : OTG.getDimensionsConfig().Dimensions) {
                if (OTGDimensionManager.isDimensionNameRegistered(dimConfig.PresetName)) continue;
                File worldConfigFile = new File(OTG.getEngine().getOTGRootFolder().getAbsolutePath() + File.separator + "worlds" + File.separator + dimConfig.PresetName + File.separator + "WorldConfig.ini");
                if (!worldConfigFile.exists()) {
                    OTG.log(LogMarker.WARN, "Could not create dimension \"" + dimConfig.PresetName + "\", OTG preset " + dimConfig.PresetName + " could not be found or does not contain a WorldConfig.ini file.", new Object[0]);
                    continue;
                }
                OTG.IsNewWorldBeingCreated = true;
                OTGDimensionManager.createDimension(dimConfig.PresetName, false, true, false);
                OTG.IsNewWorldBeingCreated = false;
            }
            OTGDimensionManager.SaveDimensionData();
        }
    }
}

