/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.google.common.base.Function;
import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.BiomeNotFoundException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BiomeColorsListener {
    private final Function<Biome, BiomeConfig> getBiomeConfig = new Function<Biome, BiomeConfig>(){

        public BiomeConfig apply(Biome input) {
            LocalBiome biome = null;
            try {
                biome = OTG.getBiome(input.func_185359_l(), input.getRegistryName().func_110623_a().split("_")[0]);
            }
            catch (BiomeNotFoundException biomeNotFoundException) {
                // empty catch block
            }
            if (biome == null) {
                return null;
            }
            return biome.getBiomeConfig();
        }
    };
    private ResourceLocation lastBiome = null;
    private BiomeConfig lastBiomeConfig;

    @SubscribeEvent
    public void grassColor(BiomeEvent.GetGrassColor grassColorEvent) {
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || !grassColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = (BiomeConfig)this.getBiomeConfig.apply((Object)grassColorEvent.getBiome());
        }
        this.lastBiome = grassColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        if (biomeConfig.grassColorIsMultiplier) {
            if (biomeConfig.grassColor != 0xFFFFFF) {
                grassColorEvent.setNewColor((grassColorEvent.getOriginalColor() + biomeConfig.grassColor) / 2);
            }
        } else {
            grassColorEvent.setNewColor(biomeConfig.grassColor);
        }
    }

    @SubscribeEvent
    public void foliageColor(BiomeEvent.GetFoliageColor foliageColorEvent) {
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || !foliageColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = (BiomeConfig)this.getBiomeConfig.apply((Object)foliageColorEvent.getBiome());
        }
        this.lastBiome = foliageColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        if (biomeConfig.foliageColor == 0xFFFFFF) {
            return;
        }
        if (biomeConfig.foliageColorIsMultiplier) {
            foliageColorEvent.setNewColor((foliageColorEvent.getOriginalColor() + biomeConfig.foliageColor) / 2);
        } else {
            foliageColorEvent.setNewColor(biomeConfig.foliageColor);
        }
    }

    @SubscribeEvent
    public void waterColor(BiomeEvent.GetWaterColor waterColorEvent) {
        BiomeConfig biomeConfig = this.lastBiomeConfig;
        if (this.lastBiome == null || !waterColorEvent.getBiome().getRegistryName().equals((Object)this.lastBiome)) {
            biomeConfig = (BiomeConfig)this.getBiomeConfig.apply((Object)waterColorEvent.getBiome());
        }
        this.lastBiome = waterColorEvent.getBiome().getRegistryName();
        this.lastBiomeConfig = biomeConfig;
        if (biomeConfig == null) {
            return;
        }
        waterColorEvent.setNewColor(biomeConfig.waterColor);
    }
}

