/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.dimensions.DimensionConfigBase;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.configuration.dimensions.DimensionsConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.dimensions.DimensionData;
import com.pg85.otg.forge.dimensions.OTGDimensionInfo;
import com.pg85.otg.forge.dimensions.OTGWorldProvider;
import com.pg85.otg.forge.dimensions.OTGWorldServerMulti;
import com.pg85.otg.forge.network.server.ServerPacketManager;
import com.pg85.otg.logging.LogMarker;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class OTGDimensionManager {
    private static HashMap<Integer, Integer> orderedDimensions;

    public static boolean isDimensionNameRegistered(String dimensionName) {
        if (dimensionName.equals("overworld")) {
            return true;
        }
        for (int i = -1000; i < 1024; ++i) {
            DimensionType dimensionType;
            if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186065_b().equals(dimensionName)) continue;
            return true;
        }
        return false;
    }

    public static void registerDimension(int id, DimensionType type) {
        DimensionManager.registerDimension((int)id, (DimensionType)type);
        int maxOrder = -1;
        for (Integer dimOrder : orderedDimensions.values()) {
            if (dimOrder <= maxOrder) continue;
            maxOrder = dimOrder;
        }
        orderedDimensions.put(id, maxOrder + 1);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dimensionID", id);
        ArrayList<String> types = new ArrayList<String>();
        types.add("OPEN_TERRAIN_GENERATOR");
        OTGDimensionManager.writeNBTStrings("types", types, compound);
        FMLInterModComms.sendMessage((String)"openterraingenerator", (String)"registerDimension", (NBTTagCompound)compound);
    }

    private static void unregisterDimension(int dimensionId) {
        if (dimensionId == 0) {
            return;
        }
        DimensionManager.unregisterDimension((int)dimensionId);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dimensionID", dimensionId);
        ArrayList<String> types = new ArrayList<String>();
        types.add("OPEN_TERRAIN_GENERATOR");
        OTGDimensionManager.writeNBTStrings("types", types, compound);
        FMLInterModComms.sendMessage((String)"openterraingenerator", (String)"unregisterDimension", (NBTTagCompound)compound);
    }

    private static void writeNBTStrings(String id, Collection<String> strings, NBTTagCompound compound) {
        if (strings != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String s : strings) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static boolean IsOTGDimension(int dimensionId) {
        return dimensionId == 0 || DimensionManager.isDimensionRegistered((int)dimensionId) && DimensionManager.getProviderType((int)dimensionId).field_186076_f.equals("OTG");
    }

    static ArrayList<Integer> GetOTGDimensions() {
        return new ArrayList<Integer>(orderedDimensions.keySet());
    }

    public static int createDimension(String dimensionName, boolean keepLoaded, boolean initDimension, boolean saveDimensionData) {
        return OTGDimensionManager.createDimension(-1L, dimensionName, keepLoaded, initDimension, saveDimensionData);
    }

    public static int createDimension(long seed, String dimensionName, boolean keepLoaded, boolean initDimension, boolean saveDimensionData) {
        int newDimId = DimensionManager.getNextFreeDimId();
        OTGDimensionManager.registerDimension(newDimId, DimensionType.register((String)dimensionName, (String)"OTG", (int)newDimId, OTGWorldProvider.class, (boolean)keepLoaded));
        if (initDimension) {
            OTGDimensionManager.initDimension(newDimId, seed);
        }
        if (saveDimensionData) {
            OTGDimensionManager.SaveDimensionData();
        }
        return newDimId;
    }

    private static void removeFromUsedIds(int dimensionId) {
        Field[] fields;
        BitSet dimensionMap = null;
        try {
            Field[] fields2;
            for (Field field : fields2 = DimensionManager.class.getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                dimensionMap = (BitSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (dimensionMap != null) {
            dimensionMap.clear(dimensionId);
        }
        IntSet usedIds = null;
        try {
            fields = DimensionManager.class.getDeclaredFields();
            int i = 0;
            for (Field field : fields) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(IntSet.class) || ++i != 3) continue;
                field.setAccessible(true);
                usedIds = (IntSet)field.get(new DimensionManager());
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (usedIds != null) {
            usedIds.rem(dimensionId);
        }
        try {
            for (Field field : fields = DimensionManager.class.getDeclaredFields()) {
                if (field.getType() != Integer.TYPE) continue;
                field.setAccessible(true);
                field.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(null, 1);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void DeleteDimension(int dimToRemove, ForgeWorld world, MinecraftServer server, boolean isServerSide) {
        if (DimensionManager.getWorld((int)dimToRemove) != null) {
            DimensionManager.setWorld((int)dimToRemove, null, (MinecraftServer)server);
        }
        if (DimensionManager.isDimensionRegistered((int)dimToRemove)) {
            OTGDimensionManager.unregisterDimension(dimToRemove);
        }
        world.unRegisterBiomes();
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().removeUnloadedWorld(world.getName());
        ((ForgeEngine)OTG.getEngine()).getWorldLoader().removeLoadedWorld(world.getName());
        if (isServerSide) {
            OTGDimensionManager.UnloadCustomDimensionData(dimToRemove);
            OTGDimensionManager.removeFromUsedIds(dimToRemove);
            File dimensionSaveDir = new File(world.getWorld().func_72860_G().func_75765_b() + File.separator + "DIM" + dimToRemove);
            if (dimensionSaveDir.exists() && dimensionSaveDir.isDirectory()) {
                OTG.log(LogMarker.INFO, "Deleting world save data for dimension " + dimToRemove, new Object[0]);
                try {
                    FileUtils.deleteDirectory((File)dimensionSaveDir);
                }
                catch (IOException e) {
                    OTG.log(LogMarker.ERROR, "Could not delete directory: " + e.toString(), new Object[0]);
                    e.printStackTrace();
                }
            }
            OTGDimensionManager.SaveDimensionData();
            ArrayList<DimensionConfig> dimConfigs = new ArrayList<DimensionConfig>(OTG.getDimensionsConfig().Dimensions);
            for (DimensionConfig dimensionConfig : dimConfigs) {
                if (!dimensionConfig.PresetName.equals(world.getName())) continue;
                OTG.getDimensionsConfig().Dimensions.remove(dimensionConfig);
                OTG.getDimensionsConfig().save();
                break;
            }
        }
    }

    public static boolean DeleteDimensionServer(String worldName, MinecraftServer server) {
        if (((ForgeEngine)OTG.getEngine()).getWorldLoader().isWorldUnloaded(worldName)) {
            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
            OTGDimensionManager.DeleteDimension(forgeWorld.getDimensionId(), forgeWorld, server, true);
            ServerPacketManager.sendDimensionSynchPacketToAllPlayers(server);
            return true;
        }
        return false;
    }

    public static void initDimension(int dim) {
        OTGDimensionManager.initDimension(dim, -1L);
    }

    private static void initDimension(int dim, long seed) {
        String dimensionName = DimensionManager.getProviderType((int)dim).func_186065_b();
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType((int)dim);
        }
        catch (Exception e) {
            System.err.println("Cannot Hotload Dim: " + e.getMessage());
            return;
        }
        MinecraftServer mcServer = overworld.func_73046_m();
        ISaveHandler savehandler = overworld.func_72860_G();
        DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(dimensionName);
        if (seed == -1L && dimConfig != null && dimConfig.Seed != null && dimConfig.Seed.trim().length() > 0) {
            seed = new Random().nextLong();
            if (!StringUtils.isEmpty((CharSequence)dimConfig.Seed)) {
                try {
                    long j = Long.parseLong(dimConfig.Seed);
                    if (j != 0L) {
                        seed = j;
                    }
                }
                catch (NumberFormatException var7) {
                    seed = dimConfig.Seed.hashCode();
                }
            }
        }
        WorldConfig worldConfig = ((ForgeEngine)OTG.getEngine()).loadWorldConfigFromDisk(new File(OTG.getEngine().getWorldsDirectory(), dimConfig.PresetName));
        long seedIn = seed == -1L ? (long)Math.floor(Math.random() * 9.223372036854776E18) : seed;
        GameType gameType = dimConfig.GameType.equals("Creative") ? GameType.CREATIVE : GameType.SURVIVAL;
        boolean enableMapFeatures = worldConfig.strongholdsEnabled;
        boolean hardcoreMode = dimConfig.GameType.equals("Hardcore");
        WorldSettings settings = new WorldSettings(seedIn, gameType, enableMapFeatures, hardcoreMode, (WorldType)OTGPlugin.OtgWorldType);
        settings.func_82750_a("OpenTerrainGenerator");
        WorldInfo worldInfo = new WorldInfo(settings, dimensionName);
        WorldServer world = (WorldServer)new OTGWorldServerMulti(mcServer, savehandler, dim, overworld, mcServer.field_71304_b, worldInfo).func_175643_b();
        OTGDimensionManager.ApplyGameRulesToWorld((World)world, dimConfig);
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        ForgeWorld forgeWorld = ((ForgeEngine)OTG.getEngine()).getWorldByDimId(dim);
        if (forgeWorld == null) {
            forgeWorld = ((ForgeEngine)OTG.getEngine()).getUnloadedWorldByDimId(dim);
        }
        OTG.getDimensionsConfig().getDimensionConfig((String)forgeWorld.getName()).Seed = "" + seedIn;
        OTG.getDimensionsConfig().save();
        if (!mcServer.func_71264_H()) {
            world.func_72912_H().func_76060_a(mcServer.func_71265_f());
        }
        if (world.func_72912_H().func_76093_s()) {
            world.func_72912_H().func_176144_a(EnumDifficulty.HARD);
            world.func_72891_a(true, true);
        } else if (mcServer.func_71264_H()) {
            world.func_72912_H().func_176144_a(mcServer.func_147135_j());
            world.func_72891_a(world.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
        } else {
            world.func_72912_H().func_176144_a(mcServer.func_147135_j());
            world.func_72891_a(mcServer.func_71193_K(), mcServer.func_71268_U());
        }
    }

    public static void ApplyGameRulesToWorld(World world, DimensionConfig dimConfig) {
        world.func_82736_K().func_82764_b("commandBlockOutput", dimConfig.GameRules.CommandBlockOutput + "");
        world.func_82736_K().func_82764_b("disableElytraMovementCheck", dimConfig.GameRules.DisableElytraMovementCheck + "");
        world.func_82736_K().func_82764_b("doDaylightCycle", dimConfig.GameRules.DoDaylightCycle + "");
        world.func_82736_K().func_82764_b("doEntityDrops", dimConfig.GameRules.DoEntityDrops + "");
        world.func_82736_K().func_82764_b("doFireTick", dimConfig.GameRules.DoFireTick + "");
        world.func_82736_K().func_82764_b("doLimitedCrafting", dimConfig.GameRules.DoLimitedCrafting + "");
        world.func_82736_K().func_82764_b("doMobLoot", dimConfig.GameRules.DoMobLoot + "");
        world.func_82736_K().func_82764_b("doMobSpawning", dimConfig.GameRules.DoMobSpawning + "");
        world.func_82736_K().func_82764_b("doTileDrops", dimConfig.GameRules.DoTileDrops + "");
        world.func_82736_K().func_82764_b("doWeatherCycle", dimConfig.GameRules.DoWeatherCycle + "");
        world.func_82736_K().func_82764_b("gameLoopFunction", dimConfig.GameRules.GameLoopFunction + "");
        world.func_82736_K().func_82764_b("keepInventory", dimConfig.GameRules.KeepInventory + "");
        world.func_82736_K().func_82764_b("logAdminCommands", dimConfig.GameRules.LogAdminCommands + "");
        world.func_82736_K().func_82764_b("maxCommandChainLength", dimConfig.GameRules.MaxCommandChainLength + "");
        world.func_82736_K().func_82764_b("maxEntityCramming", dimConfig.GameRules.MaxEntityCramming + "");
        world.func_82736_K().func_82764_b("mobGriefing", dimConfig.GameRules.MobGriefing + "");
        world.func_82736_K().func_82764_b("naturalRegeneration", dimConfig.GameRules.NaturalRegeneration + "");
        world.func_82736_K().func_82764_b("randomTickSpeed", dimConfig.GameRules.RandomTickSpeed + "");
        world.func_82736_K().func_82764_b("reducedDebugInfo", dimConfig.GameRules.ReducedDebugInfo + "");
        world.func_82736_K().func_82764_b("sendCommandFeedback", dimConfig.GameRules.SendCommandFeedback + "");
        world.func_82736_K().func_82764_b("showDeathMessages", dimConfig.GameRules.ShowDeathMessages + "");
        world.func_82736_K().func_82764_b("spawnRadius", dimConfig.GameRules.SpawnRadius + "");
        world.func_82736_K().func_82764_b("spectatorsGenerateChunks", dimConfig.GameRules.SpectatorsGenerateChunks + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SaveDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataFileName);
        if (dimensionDataFile.exists()) {
            dimensionDataFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            DimensionType dimType;
            if (i == 1 || !DimensionManager.isDimensionRegistered((int)i) || (dimType = DimensionManager.getProviderType((int)i)) == null) continue;
            ForgeWorld forgeWorld = (ForgeWorld)OTG.getWorld(dimType.func_186065_b());
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)OTG.getUnloadedWorld(dimType.func_186065_b());
            }
            if (forgeWorld == null || forgeWorld == null) continue;
            stringbuilder.append((stringbuilder.length() == 0 ? "" : ",") + i + "," + dimType.func_186065_b() + "," + dimType.shouldLoadSpawn() + "," + forgeWorld.getSeed() + "," + orderedDimensions.get(i));
        }
        BufferedWriter writer = null;
        try {
            dimensionDataFile.getParentFile().mkdirs();
            writer = new BufferedWriter(new FileWriter(dimensionDataFile));
            writer.write(stringbuilder.toString());
            OTG.log(LogMarker.DEBUG, "Custom dimension data saved", new Object[0]);
        }
        catch (IOException e) {
            OTG.log(LogMarker.ERROR, "Could not save custom dimension data.", new Object[0]);
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void UnloadAllCustomDimensionData() {
        HashMap<Object, Object> dimensionsOrderCopy = new HashMap();
        if (orderedDimensions != null) {
            dimensionsOrderCopy = new HashMap<Integer, Integer>(orderedDimensions);
        }
        orderedDimensions = new HashMap();
        orderedDimensions.put(0, 0);
        Iterator<Object> iterator = dimensionsOrderCopy.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!DimensionManager.isDimensionRegistered((int)i) || i == 0 || !dimensionsOrderCopy.containsKey(i)) continue;
            OTGDimensionManager.unregisterDimension(i);
            OTGDimensionManager.removeFromUsedIds(i);
        }
    }

    public static void UnloadCustomDimensionData(int dimId) {
        if (dimId == 0) {
            return;
        }
        boolean isOTGDimension = orderedDimensions.containsKey(dimId);
        orderedDimensions.remove(dimId);
        if (DimensionManager.isDimensionRegistered((int)dimId) && isOTGDimension) {
            OTGDimensionManager.unregisterDimension(dimId);
            OTGDimensionManager.removeFromUsedIds(dimId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OTGDimensionInfo LoadOrderedDimensionData() {
        WorldServer world = DimensionManager.getWorld((int)0);
        File dimensionDataFile = new File(world.func_72860_G().func_75765_b() + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataFileName);
        String[] dimensionDataFileValues = new String[]{};
        if (dimensionDataFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(dimensionDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.DEBUG, "Custom dimension data loaded", new Object[0]);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<DimensionData> dimensionData = new ArrayList<DimensionData>();
        if (dimensionDataFileValues.length > 0) {
            for (int i = 0; i < dimensionDataFileValues.length; i += 5) {
                DimensionData dimData = new DimensionData();
                dimData.dimensionId = Integer.parseInt(dimensionDataFileValues[i]);
                dimData.dimensionName = dimensionDataFileValues[i + 1];
                dimData.keepLoaded = Boolean.parseBoolean(dimensionDataFileValues[i + 2]);
                dimData.seed = Long.parseLong(dimensionDataFileValues[i + 3]);
                dimData.dimensionOrder = Integer.parseInt(dimensionDataFileValues[i + 4]);
                dimensionData.add(dimData);
            }
        }
        orderedDimensions = new HashMap();
        orderedDimensions.put(0, 0);
        HashMap<Integer, DimensionData> orderedDimensions1 = new HashMap<Integer, DimensionData>();
        int highestOrder = 0;
        for (DimensionData dimData : dimensionData) {
            orderedDimensions.put(dimData.dimensionId, dimData.dimensionOrder);
            orderedDimensions1.put(dimData.dimensionOrder, dimData);
            if (dimData.dimensionOrder <= highestOrder) continue;
            highestOrder = dimData.dimensionOrder;
        }
        return new OTGDimensionInfo(highestOrder, orderedDimensions1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<DimensionData> GetDimensionData(File worldSaveDir) {
        File dimensionDataFile = new File(worldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsDataFileName);
        String[] dimensionDataFileValues = new String[]{};
        if (dimensionDataFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(dimensionDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        dimensionDataFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.DEBUG, "Custom dimension data loaded", new Object[0]);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<DimensionData> dimensionData = new ArrayList<DimensionData>();
        if (dimensionDataFileValues.length > 0) {
            for (int i = 0; i < dimensionDataFileValues.length; i += 5) {
                DimensionData dimData = new DimensionData();
                dimData.dimensionId = Integer.parseInt(dimensionDataFileValues[i]);
                dimData.dimensionName = dimensionDataFileValues[i + 1];
                dimData.keepLoaded = Boolean.parseBoolean(dimensionDataFileValues[i + 2]);
                dimData.seed = Long.parseLong(dimensionDataFileValues[i + 3]);
                dimData.dimensionOrder = Integer.parseInt(dimensionDataFileValues[i + 4]);
                dimensionData.add(dimData);
            }
        }
        return dimensionData;
    }

    public static void LoadCustomDimensionData() {
        OTGDimensionInfo otgDimData = OTGDimensionManager.LoadOrderedDimensionData();
        DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
        for (int i = 0; i <= otgDimData.highestOrder; ++i) {
            if (!otgDimData.orderedDimensions.containsKey(i)) continue;
            DimensionData dimData = otgDimData.orderedDimensions.get(i);
            if (DimensionManager.isDimensionRegistered((int)dimData.dimensionId)) continue;
            if (dimData.dimensionId != 0) {
                boolean bFound = false;
                for (DimensionConfigBase dimConfig : dimsConfig.Dimensions) {
                    if (!dimConfig.PresetName.equals(dimData.dimensionName)) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    DimensionConfigBase dimConfig;
                    WorldConfig worldConfig = ((ForgeEngine)OTG.getEngine()).loadWorldConfigFromDisk(new File(OTG.getEngine().getWorldsDirectory(), dimData.dimensionName));
                    if (worldConfig == null) {
                        throw new RuntimeException("Could not initialise dimension " + dimData.dimensionId + "\", OTG preset \"" + dimData.dimensionName + "\" is not installed.");
                    }
                    dimConfig = new DimensionConfigGui(dimData.dimensionName, worldConfig);
                    dimsConfig.Dimensions.add(new DimensionConfig((DimensionConfigGui)dimConfig));
                }
            } else if (dimsConfig.Overworld == null) {
                WorldConfig worldConfig = ((ForgeEngine)OTG.getEngine()).loadWorldConfigFromDisk(new File(OTG.getEngine().getWorldsDirectory(), dimData.dimensionName));
                if (worldConfig == null) {
                    throw new RuntimeException("Could not initialise dimension " + dimData.dimensionId + "\", OTG preset \"" + dimData.dimensionName + "\" is not installed.");
                }
                DimensionConfigGui dimConfig = new DimensionConfigGui(dimData.dimensionName, worldConfig);
                dimsConfig.Overworld = new DimensionConfig(dimConfig);
            }
            OTGDimensionManager.registerDimension(dimData.dimensionId, DimensionType.register((String)dimData.dimensionName, (String)"OTG", (int)dimData.dimensionId, OTGWorldProvider.class, (boolean)dimData.keepLoaded));
            OTGDimensionManager.initDimension(dimData.dimensionId);
        }
        dimsConfig.save();
    }

    public static HashMap<Integer, String> getAllOTGDimensions() {
        HashMap<Integer, String> otgDims = new HashMap<Integer, String>();
        for (int i : orderedDimensions.keySet()) {
            if (!DimensionManager.isDimensionRegistered((int)i)) continue;
            DimensionType type = DimensionManager.getProviderType((int)i);
            otgDims.put(new Integer(type.func_186068_a()), type.func_186065_b());
        }
        return otgDims;
    }

    public static void createNewDimensionSP(DimensionConfig dimensionConfig, MinecraftServer server) {
        DimensionsConfig dimsConfig = OTG.getDimensionsConfig();
        dimensionConfig.isNewConfig = false;
        dimsConfig.Dimensions.add(dimensionConfig);
        long seed = (long)Math.floor(Math.random() * 9.223372036854776E18);
        try {
            seed = Long.parseLong(dimensionConfig.Seed);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        OTGDimensionManager.createDimension(seed, dimensionConfig.PresetName, false, true, true);
        ForgeWorld createdWorld = (ForgeWorld)OTG.getWorld(dimensionConfig.PresetName);
        if (createdWorld == null) {
            createdWorld = (ForgeWorld)OTG.getUnloadedWorld(dimensionConfig.PresetName);
        }
        if (dimensionConfig.Settings.CanDropChunk) {
            DimensionManager.unloadWorld((int)createdWorld.getWorld().field_73011_w.getDimension());
        }
        OTG.getDimensionsConfig().save();
    }
}

