/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.asm.excluded;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class OTGClassTransformer
implements IClassTransformer {
    static String[] ClassesBeingTransformed = new String[]{"net.minecraftforge.registries.GameData", "net.minecraft.world.biome.Biome", "net.minecraft.entity.EntityLivingBase", "net.minecraft.entity.item.EntityMinecart", "net.minecraft.entity.projectile.EntityArrow", "net.minecraft.entity.item.EntityBoat", "net.minecraft.entity.item.EntityFallingBlock", "net.minecraft.entity.item.EntityItem", "net.minecraft.entity.projectile.EntityLlamaSpit", "net.minecraft.entity.projectile.EntityShulkerBullet", "net.minecraft.entity.projectile.EntityThrowable", "net.minecraft.entity.item.EntityTNTPrimed", "net.minecraft.entity.item.EntityXPOrb", "net.minecraftforge.common.DimensionManager", "net.minecraft.entity.Entity", "net.minecraft.util.math.BlockPos$PooledMutableBlockPos"};
    String entityObfuscatedClassName = "vg";
    String pooledMutableBlockPosObfuscatedClassName = "et$b";

    public byte[] transform(String name, String transformedName, byte[] classBeingTransformed) {
        if (name != null && transformedName != null) {
            boolean isObfuscated = !name.equals(transformedName);
            for (int i = 0; i < ClassesBeingTransformed.length; ++i) {
                if (!ClassesBeingTransformed[i].equals(transformedName)) continue;
                return this.transform(i, classBeingTransformed, isObfuscated, transformedName);
            }
        }
        return classBeingTransformed;
    }

    public byte[] transform(int index, byte[] classBeingTransformed, boolean isObfuscated, String transformedName) {
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(classBeingTransformed);
            classReader.accept((ClassVisitor)classNode, 0);
            System.out.println("OTG-Core transforming: " + transformedName + " : " + classNode.name);
            switch (index) {
                case 0: {
                    this.transformInjectSnapshot(classNode, isObfuscated);
                    break;
                }
                case 1: {
                    this.transformGetIdForBiome(classNode, isObfuscated);
                    break;
                }
                case 2: {
                    this.transformTravel(classNode, isObfuscated);
                    break;
                }
                case 3: {
                    this.transformOnUpdateMineCart(classNode, isObfuscated);
                    break;
                }
                case 4: {
                    this.transformOnUpdateArrow(classNode, isObfuscated);
                    break;
                }
                case 5: {
                    this.transformOnUpdateBoat(classNode, isObfuscated);
                    break;
                }
                case 6: {
                    this.transformOnUpdateFallingBlock(classNode, isObfuscated);
                    break;
                }
                case 7: {
                    this.transformOnUpdateItem(classNode, isObfuscated);
                    break;
                }
                case 8: {
                    this.transformOnUpdateLlamaSpit(classNode, isObfuscated);
                    break;
                }
                case 9: {
                    this.transformOnUpdateShulkerBullet(classNode, isObfuscated);
                    break;
                }
                case 10: {
                    this.transformOnUpdateThrowable(classNode, isObfuscated);
                    break;
                }
                case 11: {
                    this.transformOnUpdateTntPrimed(classNode, isObfuscated);
                    break;
                }
                case 12: {
                    this.transformOnUpdateXPOrb(classNode, isObfuscated);
                    break;
                }
                case 13: {
                    this.transformInitDimension(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return classBeingTransformed;
        }
    }

    private void transformGetIdForBiome(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "a" : "getIdForBiome";
        String injectSnapShotDescriptor = isObfuscated ? "(L" + gameDataNode.name + ";)I" : "(Lnet/minecraft/world/biome/Biome;)I";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (!(instruction instanceof FieldInsnNode)) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new TypeInsnNode(193, "com/pg85/otg/forge/asm/excluded/IOTGASMBiome"));
            LabelNode l1 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            LabelNode l2 = new LabelNode();
            toInsert.add((AbstractInsnNode)l2);
            toInsert.add((AbstractInsnNode)new LineNumberNode(113, l2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getIDForObject", injectSnapShotDescriptor, false));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new LineNumberNode(115, l1));
            toInsert.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            method.instructions.insertBefore(targetNode, toInsert);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformInjectSnapshot(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "injectSnapshot" : "injectSnapshot";
        String injectSnapShotDescriptor = isObfuscated ? "(Ljava/util/Map;ZZ)Lcom/google/common/collect/Multimap;" : "(Ljava/util/Map;ZZ)Lcom/google/common/collect/Multimap;";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                AbstractInsnNode instruction7;
                AbstractInsnNode instruction6;
                AbstractInsnNode instruction5;
                AbstractInsnNode instruction4;
                AbstractInsnNode instruction3;
                AbstractInsnNode instruction2;
                if (instruction.getOpcode() != 25 || !((instruction2 = instruction.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction2).desc.equals("()Ljava/util/Collection;") || !((instruction3 = instruction2.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction3).desc.equals("()Ljava/util/stream/Stream;") || !((instruction4 = instruction3.getNext()) instanceof InvokeDynamicInsnNode) || !((InvokeDynamicInsnNode)instruction4).desc.equals("()Ljava/util/function/ToIntFunction;") || !((instruction5 = instruction4.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction5).desc.equals("(Ljava/util/function/ToIntFunction;)Ljava/util/stream/IntStream;") || !((instruction6 = instruction5.getNext()) instanceof MethodInsnNode) || !((MethodInsnNode)instruction6).desc.equals("()I") || (instruction7 = instruction6.getNext()).getOpcode() != 54) continue;
                targetNode = instruction;
                break;
            }
            if (targetNode == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            AbstractInsnNode removeNode = targetNode.getNext();
            for (int i = 0; i < 5; ++i) {
                removeNode = removeNode.getNext();
                method.instructions.remove(removeNode.getPrevious());
            }
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "countMissingRegistryEntries", "(Ljava/util/LinkedHashMap;)I", false));
            method.instructions.insertBefore(removeNode, toInsert);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }

    private void transformTravel(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "a" : "travel";
        String injectSnapShotDescriptor = isObfuscated ? "(FFF)V" : "(FFF)V";
        String entityLivingBaseObfuscatedClassName = gameDataNode.name;
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != 0.08) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactor", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                boolean bFound = false;
                for (AbstractInsnNode instruction : method.instructions.toArray()) {
                    if (instruction.getOpcode() != 184 || !((MethodInsnNode)instruction).name.equals("getGravityForEntity")) continue;
                    bFound = true;
                    InsnList toInsertBefore = new InsnList();
                    toInsertBefore.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "isOTGWorld", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)Z" : "(Lnet/minecraft/entity/Entity;)Z", false));
                    LabelNode l201 = new LabelNode();
                    toInsertBefore.add((AbstractInsnNode)new JumpInsnNode(153, l201));
                    toInsertBefore.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsertBefore.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactor", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                    LabelNode l202 = new LabelNode();
                    toInsertBefore.add((AbstractInsnNode)new JumpInsnNode(167, l202));
                    toInsertBefore.add((AbstractInsnNode)l201);
                    toInsertBefore.add((AbstractInsnNode)new FrameNode(0, 8, new Object[]{isObfuscated ? entityLivingBaseObfuscatedClassName : "net/minecraft/entity/EntityLivingBase", Opcodes.FLOAT, Opcodes.FLOAT, Opcodes.FLOAT, Opcodes.FLOAT, isObfuscated ? this.pooledMutableBlockPosObfuscatedClassName : "net/minecraft/util/math/BlockPos$PooledMutableBlockPos", Opcodes.FLOAT, Opcodes.FLOAT}, 2, new Object[]{isObfuscated ? entityLivingBaseObfuscatedClassName : "net/minecraft/entity/EntityLivingBase", Opcodes.DOUBLE}));
                    toInsertBefore.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(instruction, toInsertBefore);
                    InsnList toInsertAfter = new InsnList();
                    toInsertAfter.add((AbstractInsnNode)l202);
                    toInsertAfter.add((AbstractInsnNode)new FrameNode(0, 8, new Object[]{isObfuscated ? entityLivingBaseObfuscatedClassName : "net/minecraft/entity/EntityLivingBase", Opcodes.FLOAT, Opcodes.FLOAT, Opcodes.FLOAT, Opcodes.FLOAT, isObfuscated ? this.pooledMutableBlockPosObfuscatedClassName : "net/minecraft/util/math/BlockPos$PooledMutableBlockPos", Opcodes.FLOAT, Opcodes.FLOAT}, 3, new Object[]{isObfuscated ? entityLivingBaseObfuscatedClassName : "net/minecraft/entity/EntityLivingBase", Opcodes.DOUBLE, Opcodes.DOUBLE}));
                    method.instructions.insertBefore(instruction.getNext(), toInsertAfter);
                    break;
                }
                if (!bFound) {
                    System.out.println("OTG-Core could not override net.minecraft.entity.EntityLivingBase.travel, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
                }
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.EntityLivingBase.travel, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateMineCart(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorMineCart", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityMinecart.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityMinecart.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateArrow(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.05f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorArrow", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityArrow.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityArrow.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateBoat(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "x" : "updateMotion";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)-0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorBoat", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityBoat.updateMotion, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityBoat.updateMotion, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateFallingBlock(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorFallingBlock", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityFallingBlock.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityFallingBlock.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateItem(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        String entityItemObfuscatedClassName = gameDataNode.name;
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorItem", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                boolean bFound = false;
                for (AbstractInsnNode instruction : method.instructions.toArray()) {
                    if (instruction.getOpcode() != 184 || !((MethodInsnNode)instruction).name.equals("getItemGravity")) continue;
                    bFound = true;
                    InsnList toInsertBefore = new InsnList();
                    toInsertBefore.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "isOTGWorld", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)Z" : "(Lnet/minecraft/entity/Entity;)Z", false));
                    LabelNode l201 = new LabelNode();
                    toInsertBefore.add((AbstractInsnNode)new JumpInsnNode(153, l201));
                    toInsertBefore.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsertBefore.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorItem", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                    LabelNode l202 = new LabelNode();
                    toInsertBefore.add((AbstractInsnNode)new JumpInsnNode(167, l202));
                    toInsertBefore.add((AbstractInsnNode)l201);
                    toInsertBefore.add((AbstractInsnNode)new FrameNode(0, 4, new Object[]{isObfuscated ? entityItemObfuscatedClassName : "net/minecraft/entity/item/EntityItem", Opcodes.DOUBLE, Opcodes.DOUBLE, Opcodes.DOUBLE}, 2, new Object[]{isObfuscated ? entityItemObfuscatedClassName : "net/minecraft/entity/item/EntityItem", Opcodes.DOUBLE}));
                    toInsertBefore.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    method.instructions.insertBefore(instruction, toInsertBefore);
                    InsnList toInsertAfter = new InsnList();
                    toInsertAfter.add((AbstractInsnNode)l202);
                    toInsertAfter.add((AbstractInsnNode)new FrameNode(0, 4, new Object[]{isObfuscated ? entityItemObfuscatedClassName : "net/minecraft/entity/item/EntityItem", Opcodes.DOUBLE, Opcodes.DOUBLE, Opcodes.DOUBLE}, 3, new Object[]{isObfuscated ? entityItemObfuscatedClassName : "net/minecraft/entity/item/EntityItem", Opcodes.DOUBLE, Opcodes.DOUBLE}));
                    method.instructions.insertBefore(instruction.getNext(), toInsertAfter);
                    break;
                }
                if (!bFound) {
                    System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityItem.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
                }
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityItem.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateLlamaSpit(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.06f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorLlamaSpit", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.projectile.LlamaSpit.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.projectile.LlamaSpit.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateShulkerBullet(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != 0.04) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorShulkerBullet", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityShulkerBullet, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityShulkerBullet, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateThrowable(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "j" : "getGravityVelocity";
        String injectSnapShotDescriptor = isObfuscated ? "()F" : "()F";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Float) || ((Float)((LdcInsnNode)instruction).cst).floatValue() != 0.03f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorThrowable", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)F" : "(Lnet/minecraft/entity/Entity;)F", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityThrowable.getGravityVelocity, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.projectile.EntityThrowable.getGravityVelocity, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateTntPrimed(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.04f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorTNTPrimed", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityTntPrimed, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityTntPrimed, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformOnUpdateXPOrb(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "B_" : "onUpdate";
        String injectSnapShotDescriptor = isObfuscated ? "()V" : "()V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode instructionToRemove = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !(((LdcInsnNode)instruction).cst instanceof Double) || (Double)((LdcInsnNode)instruction).cst != (double)0.03f) continue;
                instructionToRemove = instruction;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "getGravityFactorXPOrb", isObfuscated ? "(L" + this.entityObfuscatedClassName + ";)D" : "(Lnet/minecraft/entity/Entity;)D", false));
                method.instructions.insertBefore(instructionToRemove, toInsert);
                break;
            }
            if (instructionToRemove != null) {
                method.instructions.remove(instructionToRemove);
            } else {
                System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityXPOrb.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
            }
            return;
        }
        System.out.println("OTG-Core could not override net.minecraft.entity.item.EntityXPOrb.onUpdate, this may cause problems with OTG dimensions using non-default gravity settings. Either another mod has edited the code, or OTG-Core is not compatible with this version of Forge.");
    }

    private void transformInitDimension(ClassNode gameDataNode, boolean isObfuscated) {
        String injectSnapShot = isObfuscated ? "initDimension" : "initDimension";
        String injectSnapShotDescriptor = isObfuscated ? "(I)V" : "(I)V";
        for (MethodNode method : gameDataNode.methods) {
            if (!method.name.equals(injectSnapShot) || !method.desc.equals(injectSnapShotDescriptor)) continue;
            AbstractInsnNode targetNode = null;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (!(instruction instanceof LineNumberNode)) continue;
                if (targetNode == null) {
                    targetNode = instruction;
                    continue;
                }
                ((LineNumberNode)instruction).line += 5;
            }
            if (targetNode == null) {
                throw new RuntimeException("OTG is not compatible with this version of Forge.");
            }
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(21, 0));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "com/pg85/otg/forge/asm/OTGHooks", "initOTGDimension", "(I)Z", false));
            LabelNode l4 = new LabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l4));
            LabelNode l5 = new LabelNode();
            toInsert.add((AbstractInsnNode)l5);
            toInsert.add((AbstractInsnNode)new LineNumberNode(247, l5));
            toInsert.add((AbstractInsnNode)new InsnNode(177));
            toInsert.add((AbstractInsnNode)l4);
            toInsert.add((AbstractInsnNode)new LineNumberNode(250, l5));
            toInsert.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            method.instructions.insertBefore(targetNode, toInsert);
            return;
        }
        throw new RuntimeException("OTG is not compatible with this version of Forge.");
    }
}

