/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.OTG;
import com.pg85.otg.common.BiomeIds;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.common.WorldSession;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.customobjects.bofunctions.EntityFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCache;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.biomes.ForgeBiomeRegistryManager;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.generator.OTGChunkGenerator;
import com.pg85.otg.forge.generator.structure.MojangStructurePart;
import com.pg85.otg.forge.generator.structure.OTGMineshaftGen;
import com.pg85.otg.forge.generator.structure.OTGNetherFortressGen;
import com.pg85.otg.forge.generator.structure.OTGOceanMonumentGen;
import com.pg85.otg.forge.generator.structure.OTGRareBuildingGen;
import com.pg85.otg.forge.generator.structure.OTGStrongholdGen;
import com.pg85.otg.forge.generator.structure.OTGVillageGen;
import com.pg85.otg.forge.generator.structure.OTGWoodLandMansionGen;
import com.pg85.otg.forge.util.ForgeMaterialData;
import com.pg85.otg.forge.util.IOHelper;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.forge.util.NBTHelper;
import com.pg85.otg.forge.util.WorldHelper;
import com.pg85.otg.forge.world.ForgeWorldSession;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ClientConfigProvider;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.network.ServerConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeWorld
implements LocalWorld {
    private static final int MAX_BIOMES_COUNT = 4096;
    private static final int MAX_SAVED_BIOMES_COUNT = 255;
    public static final int STANDARD_WORLD_HEIGHT = 128;
    private ForgeWorldSession worldSession;
    public boolean isLoadedOnServer;
    public int clientDimensionId = 0;
    private OTGChunkGenerator generator;
    public World world;
    private ConfigProvider settings;
    private CustomStructureCache structureCache;
    private String name;
    private long seed;
    private BiomeGenerator biomeGenerator;
    public HashMap<String, LocalBiome> biomeNames = new HashMap();
    private MapGenStructure strongholdGen;
    public MapGenStructure villageGen;
    private MapGenStructure mineshaftGen;
    private MapGenStructure rareBuildingGen;
    private MapGenBase cavesGen;
    private OTGNetherFortressGen netherFortressGen;
    private MapGenStructure oceanMonumentGen;
    private MapGenStructure woodLandMansionGen;
    private WorldGenDungeons dungeonGen;
    private WorldGenFossils fossilGen;
    private WorldGenTrees tree;
    private WorldGenSavannaTree acaciaTree;
    private WorldGenBigTree bigTree;
    private WorldGenBirchTree birchTree;
    private WorldGenTrees cocoaTree;
    private WorldGenCanopyTree darkOakTree;
    private WorldGenShrub groundBush;
    private WorldGenBigMushroom hugeRedMushroom;
    private WorldGenBigMushroom hugeBrownMushroom;
    private WorldGenMegaPineTree hugeTaigaTree1;
    private WorldGenMegaPineTree hugeTaigaTree2;
    private WorldGenMegaJungle jungleTree;
    private WorldGenBirchTree longBirchTree;
    private WorldGenSwamp swampTree;
    private WorldGenTaiga1 taigaTree1;
    private WorldGenTaiga2 taigaTree2;

    public ForgeWorld(String _name) {
        OTG.log(LogMarker.INFO, "Creating world \"" + _name + "\"", new Object[0]);
        this.name = _name;
    }

    public void provideWorldInstance(WorldServer world) {
        ServerConfigProvider configs = (ServerConfigProvider)this.settings;
        DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(WorldHelper.getName((World)world));
        this.world = world;
        OTGDimensionManager.ApplyGameRulesToWorld((World)world, dimConfig);
        this.seed = world.func_72912_H().func_76063_b();
        world.func_181544_b(configs.getWorldConfig().waterLevelMax);
        this.dungeonGen = new WorldGenDungeons();
        this.fossilGen = new WorldGenFossils();
        this.netherFortressGen = new OTGNetherFortressGen(this);
        this.cavesGen = TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGStrongholdGen(configs, world), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGVillageGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGMineshaftGen(this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.rareBuildingGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGRareBuildingGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.oceanMonumentGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGOceanMonumentGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
        this.woodLandMansionGen = (MapGenStructure)TerrainGen.getModdedMapGen((MapGenBase)new OTGWoodLandMansionGen(configs, this), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.WOODLAND_MANSION);
        IBlockState jungleLog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        this.tree = new WorldGenTrees(false);
        this.acaciaTree = new WorldGenSavannaTree(false);
        this.cocoaTree = new WorldGenTrees(false, 5, jungleLog, jungleLeaves, true);
        this.bigTree = new WorldGenBigTree(false);
        this.birchTree = new WorldGenBirchTree(false, false);
        this.darkOakTree = new WorldGenCanopyTree(false);
        this.longBirchTree = new WorldGenBirchTree(false, true);
        this.swampTree = new WorldGenSwamp();
        this.taigaTree1 = new WorldGenTaiga1();
        this.taigaTree2 = new WorldGenTaiga2(false);
        this.hugeRedMushroom = new WorldGenBigMushroom(Blocks.field_150419_aX);
        this.hugeBrownMushroom = new WorldGenBigMushroom(Blocks.field_150420_aW);
        this.hugeTaigaTree1 = new WorldGenMegaPineTree(false, false);
        this.hugeTaigaTree2 = new WorldGenMegaPineTree(false, true);
        this.jungleTree = new WorldGenMegaJungle(false, 10, 20, jungleLog, jungleLeaves);
        this.groundBush = new WorldGenShrub(jungleLog, jungleLeaves);
        this.generator = new OTGChunkGenerator(this);
        this.worldSession = new ForgeWorldSession(this);
        this.structureCache = new CustomStructureCache(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigsBukkit(WorldClient world, ClientConfigProvider config) {
        this.settings = config;
        this.world = world;
        this.seed = world.func_72905_C();
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientConfigs(ClientConfigProvider config) {
        this.settings = config;
        this.worldSession = new ForgeWorldSession(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void provideClientWorld(World world) {
        this.world = world;
        this.seed = world.func_72905_C();
    }

    public void provideConfigs(ServerConfigProvider configs) {
        this.settings = configs;
    }

    @Override
    public ConfigProvider getConfigs() {
        return this.settings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getWorldSettingsName() {
        return this.getWorld().func_72912_H().func_76065_j();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int getHeightCap() {
        return this.settings.getWorldConfig().worldHeightCap;
    }

    @Override
    public int getHeightScale() {
        return this.settings.getWorldConfig().worldHeightScale;
    }

    public OTGChunkGenerator getChunkGenerator() {
        return this.generator;
    }

    public void setBiomeGenerator(BiomeGenerator generator) {
        this.biomeGenerator = generator;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        return this.world.func_175699_k(new BlockPos(x, y, z));
    }

    @Override
    public CustomStructureCache getStructureCache() {
        return this.structureCache;
    }

    @Override
    public ObjectSpawner getObjectSpawner() {
        return this.generator.spawner;
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public File getWorldSaveDir() {
        return this.getWorld().func_72860_G().func_75765_b();
    }

    @Override
    public int getDimensionId() {
        return this.getWorld().field_73011_w.getDimension();
    }

    @Override
    public void setAllowSpawningOutsideBounds(boolean allowSpawningOutsideBounds) {
        this.getChunkGenerator().setAllowSpawningOutsideBounds(allowSpawningOutsideBounds);
    }

    public BlockPos getSpawnPoint() {
        BlockPos spawnPos = this.world.field_73011_w.getSpawnPoint();
        return new BlockPos(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
    }

    @Override
    public void startPopulation(ChunkCoordinate chunkCoord) {
    }

    @Override
    public void endPopulation() {
    }

    @Override
    public WorldSession getWorldSession() {
        return this.worldSession;
    }

    @Override
    public void deleteWorldSessionData() {
        if (this.getWorld() != null) {
            int dimensionId = this.getWorld().field_73011_w.getDimension();
            File worldDataDir = new File(this.getWorld().func_72860_G().func_75765_b() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : ""));
            if (worldDataDir.exists()) {
                IOHelper.deleteRecursive(worldDataDir);
            }
        }
    }

    @Override
    public LocalBiome getCalculatedBiome(int x, int z) {
        return this.getBiomeByOTGIdOrNull(this.biomeGenerator.getBiome(x, z));
    }

    @Override
    public LocalBiome getBiome(int x, int z) {
        return this.getCalculatedBiome(x, z);
    }

    @Override
    public String getSavedBiomeName(int x, int z) {
        BiomeConfig biomeConfig = this.getBiome(x, z).getBiomeConfig();
        if (biomeConfig.replaceToBiomeName == null || biomeConfig.replaceToBiomeName.trim().length() == 0) {
            return biomeConfig.getName();
        }
        return biomeConfig.replaceToBiomeName;
    }

    @Override
    public ArrayList<LocalBiome> getAllBiomes() {
        ArrayList<LocalBiome> biomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : this.settings.getBiomeArrayByOTGId()) {
            biomes.add(biome);
        }
        return biomes;
    }

    @Override
    public LocalBiome getFirstBiomeOrNull() {
        return this.biomeNames.size() > 0 ? (LocalBiome)this.biomeNames.values().toArray()[0] : null;
    }

    @Override
    public ForgeBiome getBiomeByOTGIdOrNull(int id) {
        return (ForgeBiome)this.settings.getBiomeByOTGIdOrNull(id);
    }

    @Override
    public LocalBiome getBiomeByNameOrNull(String name) {
        return this.biomeNames.get(name);
    }

    @Override
    public LocalBiome createBiomeFor(BiomeConfig biomeConfig, BiomeIds biomeIds, ConfigProvider configProvider, boolean isReload) {
        ForgeBiome forgeBiome = ForgeBiomeRegistryManager.getOrCreateBiome(biomeConfig, biomeIds, this.getName(), configProvider);
        this.biomeNames.put(forgeBiome.getName(), forgeBiome);
        return forgeBiome;
    }

    @Override
    public int getRegisteredBiomeId(String resourceLocationString) {
        return ForgeBiomeRegistryManager.getRegisteredBiomeId(resourceLocationString, this.getName());
    }

    public void unRegisterBiomes() {
        ForgeBiomeRegistryManager.unregisterBiomes(this.biomeNames, this);
    }

    @Override
    public int getMaxBiomesCount() {
        return 4096;
    }

    @Override
    public int getMaxSavedBiomesCount() {
        return 255;
    }

    public Collection<BiomeLoadInstruction> getDefaultBiomes() {
        return ForgeBiomeRegistryManager.getDefaultBiomes();
    }

    @Override
    public ChunkCoordinate getSpawnChunk() {
        BlockPos spawnPos = this.getSpawnPoint();
        return ChunkCoordinate.fromBlockCoords(spawnPos.func_177958_n(), spawnPos.func_177952_p());
    }

    public Chunk getChunk(int x, int z, boolean allowOutsidePopulatingArea) {
        return this.getChunkGenerator().getChunk(x, z, allowOutsidePopulatingArea);
    }

    @Override
    public boolean isLoaded(int x, int y, int z) {
        return this.getChunk(x, z, false) != null;
    }

    @Override
    public boolean isInsidePregeneratedRegion(ChunkCoordinate chunk) {
        return this.getWorldSession().isInsidePregeneratedRegion(chunk);
    }

    @Override
    public int getLiquidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, false, true, false, false);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getSolidHeight(int x, int z) {
        int highestY = this.getHighestBlockYAt(x, z, true, false, true, true);
        highestY = highestY > 0 ? ++highestY : -1;
        return highestY;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        int y;
        Chunk chunk = this.getChunk(x, z, false);
        if (chunk == null) {
            return -1;
        }
        boolean incorrectHeightMap = false;
        for (y = chunk.func_76611_b(x & 0xF, z & 0xF); y < this.getHeightCap() && chunk.func_186032_a(x, y, z).func_185904_a().func_76228_b(); ++y) {
            incorrectHeightMap = true;
        }
        if (incorrectHeightMap) {
            this.world.func_175664_x(new BlockPos(x, y, z));
        }
        return y;
    }

    @Override
    public int getHighestBlockYAt(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        Chunk chunk = this.getChunk(x, z, true);
        if (chunk == null) {
            int y = this.generator.getHighestBlockYInUnloadedChunk(x, z, findSolid, findLiquid, ignoreLiquid, ignoreSnow);
            return y;
        }
        z &= 0xF;
        x &= 0xF;
        for (int i = 255; i > -1; --i) {
            boolean isSolid;
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(chunk.func_186032_a(x, i, z));
            if (material == null) {
                throw new RuntimeException();
            }
            DefaultMaterial defaultMaterial = material.toDefaultMaterial();
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() && !defaultMaterial.equals((Object)DefaultMaterial.LEAVES) && !defaultMaterial.equals((Object)DefaultMaterial.LEAVES_2) || !ignoreSnow && defaultMaterial.equals((Object)DefaultMaterial.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return i;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return -1;
    }

    @Override
    public boolean isNullOrAir(int x, int y, int z, boolean isOTGPlus) {
        if (y >= 256 || y < 0) {
            return true;
        }
        Chunk chunk = this.getChunk(x, z, isOTGPlus);
        if (chunk == null) {
            return true;
        }
        return chunk.func_186032_a(x & 0xF, y, z & 0xF).func_185904_a().equals(Material.field_151579_a);
    }

    @Override
    public LocalMaterialData getMaterial(int x, int y, int z, boolean allowOutsidePopulatingArea) {
        if (y >= 256 || y < 0) {
            return null;
        }
        Chunk chunk = this.getChunk(x, z, allowOutsidePopulatingArea);
        if (chunk == null && !allowOutsidePopulatingArea) {
            return null;
        }
        if (chunk == null) {
            return this.generator.getMaterialInUnloadedChunk(x, y, z);
        }
        ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(chunk.func_186032_a(x &= 0xF, y, z &= 0xF));
        return material;
    }

    @Override
    public LocalMaterialData[] getBlockColumn(int x, int z) {
        return this.generator.getBlockColumnInUnloadedChunk(x, z);
    }

    @Override
    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean allowOutsidePopulatingArea) {
        this.getChunkGenerator().setBlock(x, y, z, material, metaDataTag, allowOutsidePopulatingArea);
    }

    @Override
    public NamedBinaryTag getMetadata(int x, int y, int z) {
        TileEntity tileEntity = this.world.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        NBTTagCompound nmsTag = new NBTTagCompound();
        tileEntity.func_189515_b(nmsTag);
        nmsTag.func_82580_o("x");
        nmsTag.func_82580_o("y");
        nmsTag.func_82580_o("z");
        return NBTHelper.getNBTFromNMSTagCompound(null, nmsTag);
    }

    @Override
    public boolean placeDungeon(Random rand, int x, int y, int z) {
        return this.dungeonGen.func_180709_b(this.world, rand, new BlockPos(x, y, z));
    }

    @Override
    public boolean placeFossil(Random rand, ChunkCoordinate chunkCoord) {
        return this.fossilGen.func_180709_b(this.world, rand, new BlockPos(chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ()));
    }

    @Override
    public boolean placeTree(TreeType type, Random rand, int x, int y, int z) {
        BlockPos blockPos = new BlockPos(x, y, z);
        switch (type) {
            case Tree: {
                return this.tree.func_180709_b(this.world, rand, blockPos);
            }
            case BigTree: {
                return this.bigTree.func_180709_b(this.world, rand, blockPos);
            }
            case Forest: 
            case Birch: {
                return this.birchTree.func_180709_b(this.world, rand, blockPos);
            }
            case TallBirch: {
                return this.longBirchTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeMushroom: {
                if (rand.nextBoolean()) {
                    return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
                }
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeRedMushroom: {
                return this.hugeRedMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case HugeBrownMushroom: {
                return this.hugeBrownMushroom.func_180709_b(this.world, rand, blockPos);
            }
            case SwampTree: {
                return this.swampTree.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga1: {
                return this.taigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case Taiga2: {
                return this.taigaTree2.func_180709_b(this.world, rand, blockPos);
            }
            case JungleTree: {
                return this.jungleTree.func_180709_b(this.world, rand, blockPos);
            }
            case GroundBush: {
                return this.groundBush.func_180709_b(this.world, rand, blockPos);
            }
            case CocoaTree: {
                return this.cocoaTree.func_180709_b(this.world, rand, blockPos);
            }
            case Acacia: {
                return this.acaciaTree.func_180709_b(this.world, rand, blockPos);
            }
            case DarkOak: {
                return this.darkOakTree.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga1: {
                return this.hugeTaigaTree1.func_180709_b(this.world, rand, blockPos);
            }
            case HugeTaiga2: {
                return this.hugeTaigaTree2.func_180709_b(this.world, rand, blockPos);
            }
        }
        throw new RuntimeException("Failed to handle tree of type " + type.toString());
    }

    @Override
    public void prepareDefaultStructures(int chunkX, int chunkZ, boolean dry) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled && dry) {
            this.villageGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_186125_a(this.world, chunkX, chunkZ, null);
        }
    }

    @Override
    public boolean placeDefaultStructures(Random rand, ChunkCoordinate chunkCoord) {
        ChunkPos chunkCoordIntPair = new ChunkPos(chunkCoord.getChunkX(), chunkCoord.getChunkZ());
        WorldConfig worldConfig = this.settings.getWorldConfig();
        boolean isVillagePlaced = false;
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.villagesEnabled) {
            isVillagePlaced = this.villageGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_175794_a(this.world, rand, chunkCoordIntPair);
        }
        return isVillagePlaced;
    }

    public void recreateStructures(Chunk chunkIn, int chunkX, int chunkZ) {
        WorldConfig worldConfig = this.getConfigs().getWorldConfig();
        if (worldConfig.mineshaftsEnabled) {
            this.mineshaftGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled) {
            this.villageGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.strongholdsEnabled) {
            this.strongholdGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.rareBuildingGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.netherFortressGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.oceanMonumentGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.woodLandMansionGen.func_186125_a(this.getWorld(), chunkX, chunkZ, null);
        }
    }

    @Override
    public SpawnableObject getMojangStructurePart(String name) {
        ResourceLocation resourceLocation = new ResourceLocation(name);
        TemplateManager mojangStructureParts = this.world.func_72860_G().func_186340_h();
        Template mojangStructurePart = mojangStructureParts.func_186237_a(this.world.func_73046_m(), resourceLocation);
        if (mojangStructurePart == null) {
            return null;
        }
        return new MojangStructurePart(name, mojangStructurePart);
    }

    @Override
    public boolean chunkHasDefaultStructure(Random rand, ChunkCoordinate chunk) {
        WorldConfig worldConfig = this.settings.getWorldConfig();
        BlockPos blockPos = new BlockPos(chunk.getBlockXCenter(), 0, chunk.getBlockZCenter());
        return worldConfig.villagesEnabled && this.villageGen instanceof OTGVillageGen && ((OTGVillageGen)this.villageGen).func_175795_b(blockPos) || worldConfig.villagesEnabled && !(this.villageGen instanceof OTGVillageGen) && this.villageGen.func_175795_b(blockPos) || worldConfig.rareBuildingsEnabled && this.rareBuildingGen instanceof OTGRareBuildingGen && ((OTGRareBuildingGen)this.rareBuildingGen).func_175795_b(blockPos) || worldConfig.rareBuildingsEnabled && !(this.rareBuildingGen instanceof OTGRareBuildingGen) && this.rareBuildingGen.func_175795_b(blockPos) || worldConfig.netherFortressesEnabled && this.netherFortressGen.func_175795_b(blockPos) || worldConfig.oceanMonumentsEnabled && this.oceanMonumentGen instanceof OTGOceanMonumentGen && ((OTGOceanMonumentGen)this.oceanMonumentGen).func_175795_b(blockPos) || worldConfig.oceanMonumentsEnabled && !(this.oceanMonumentGen instanceof OTGOceanMonumentGen) && this.oceanMonumentGen.func_175795_b(blockPos) || worldConfig.woodLandMansionsEnabled && this.woodLandMansionGen instanceof OTGWoodLandMansionGen && ((OTGWoodLandMansionGen)this.woodLandMansionGen).func_175795_b(blockPos) || worldConfig.woodLandMansionsEnabled && !(this.woodLandMansionGen instanceof OTGWoodLandMansionGen) && this.woodLandMansionGen.func_175795_b(blockPos);
    }

    public boolean isInsideStructure(String structureName, BlockPos pos) {
        if ("Stronghold".equals(structureName) && this.strongholdGen != null) {
            return this.strongholdGen.func_175795_b(pos);
        }
        if ("Mansion".equals(structureName) && this.woodLandMansionGen != null) {
            return this.woodLandMansionGen.func_175795_b(pos);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGen != null) {
            return this.oceanMonumentGen.func_175795_b(pos);
        }
        if (("OTGVillage".equals(structureName) || "Village".equals(structureName)) && this.villageGen != null) {
            return this.villageGen.func_175795_b(pos);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGen != null) {
            return this.mineshaftGen.func_175795_b(pos);
        }
        if (("OTGTemple".equals(structureName) || "Temple".equals(structureName)) && this.rareBuildingGen != null) {
            return this.rareBuildingGen.func_175795_b(pos);
        }
        return false;
    }

    public BlockPos getNearestStructurePos(String structureName, BlockPos blockPos, boolean p_180513_4_) {
        if ("Stronghold".equals(structureName) && this.strongholdGen != null) {
            return this.strongholdGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Mansion".equals(structureName) && this.woodLandMansionGen != null) {
            return this.woodLandMansionGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Monument".equals(structureName) && this.oceanMonumentGen != null) {
            return this.oceanMonumentGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if (("OTGVillage".equals(structureName) || "Village".equals(structureName)) && this.villageGen != null) {
            return this.villageGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if ("Mineshaft".equals(structureName) && this.mineshaftGen != null) {
            return this.mineshaftGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        if (("OTGTemple".equals(structureName) || "Temple".equals(structureName)) && this.rareBuildingGen != null) {
            return this.rareBuildingGen.func_180706_b(this.getWorld(), blockPos, p_180513_4_);
        }
        return null;
    }

    @Override
    public void replaceBlocks(ChunkCoordinate chunkCoord) {
        if (!this.settings.getWorldConfig().biomeConfigsHaveReplacement) {
            return;
        }
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX() + 16, chunkCoord.getBlockZ() + 16, false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX(), chunkCoord.getBlockZ() + 16, false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX() + 16, chunkCoord.getBlockZ(), false), 0, 0, 16);
        this.replaceBlocks(this.getChunk(chunkCoord.getBlockX(), chunkCoord.getBlockZ(), false), 0, 0, 16);
    }

    private void replaceBlocks(Chunk rawChunk, int startXInChunk, int startZInChunk, int size) {
        ExtendedBlockStorage[] sectionsArray;
        int endXInChunk = startXInChunk + size;
        int endZInChunk = startZInChunk + size;
        int worldStartX = rawChunk.field_76635_g * 16;
        int worldStartZ = rawChunk.field_76647_h * 16;
        for (ExtendedBlockStorage section : sectionsArray = rawChunk.func_76587_i()) {
            if (section == null) continue;
            for (int sectionX = startXInChunk; sectionX < endXInChunk; ++sectionX) {
                block2: for (int sectionZ = startZInChunk; sectionZ < endZInChunk; ++sectionZ) {
                    LocalBiome biome = this.getBiome(worldStartX + sectionX, worldStartZ + sectionZ);
                    if (biome == null || !biome.getBiomeConfig().replacedBlocks.hasReplaceSettings()) continue;
                    LocalMaterialData[][] replaceArray = biome.getBiomeConfig().replacedBlocks.compiledInstructions;
                    for (int sectionY = 0; sectionY < 16; ++sectionY) {
                        IBlockState block = section.func_186049_g().func_186016_a(sectionX, sectionY, sectionZ);
                        int blockId = Block.func_149682_b((Block)block.func_177230_c());
                        if (replaceArray[blockId] == null) continue;
                        int y = section.func_76662_d() + sectionY;
                        if (y >= replaceArray[blockId].length) continue block2;
                        ForgeMaterialData replaceTo = (ForgeMaterialData)replaceArray[blockId][y];
                        if (replaceTo == null || replaceTo.getBlockId() == blockId) continue;
                        section.func_177484_a(sectionX, sectionY, sectionZ, replaceTo.internalBlock());
                    }
                }
            }
        }
    }

    @Override
    public void placePopulationMobs(LocalBiome biome, Random random, ChunkCoordinate chunkCoord) {
        if (TerrainGen.populate((IChunkGenerator)this.getChunkGenerator(), (World)this.world, (Random)random, (int)chunkCoord.getChunkX(), (int)chunkCoord.getChunkZ(), (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.getWorld(), (Biome)((ForgeBiome)biome).getHandle(), (int)chunkCoord.getBlockXCenter(), (int)chunkCoord.getBlockZCenter(), (int)16, (int)16, (Random)random);
        }
    }

    @Override
    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub biomeConfigStub, String biomeResourceLocation) {
        ForgeBiomeRegistryManager.mergeVanillaBiomeMobSpawnSettings(biomeConfigStub, biomeResourceLocation);
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType paramaca, BlockPos blockPos) {
        WorldConfig worldConfig = this.getConfigs().getWorldConfig();
        Biome biomeBaseOTG = ((ForgeBiome)this.getBiome((int)blockPos.func_177958_n(), (int)blockPos.func_177952_p())).biomeBase;
        if (worldConfig.rareBuildingsEnabled && paramaca == EnumCreatureType.MONSTER && (this.rareBuildingGen instanceof OTGRareBuildingGen && ((OTGRareBuildingGen)this.rareBuildingGen).isSwampHutAtLocation(blockPos) || !(this.rareBuildingGen instanceof OTGRareBuildingGen) && ((MapGenScatteredFeature)this.rareBuildingGen).func_175798_a(blockPos))) {
            return this.rareBuildingGen instanceof OTGRareBuildingGen ? ((OTGRareBuildingGen)this.rareBuildingGen).getMonsterSpawnList() : ((MapGenScatteredFeature)this.rareBuildingGen).func_82667_a();
        }
        if (worldConfig.oceanMonumentsEnabled && paramaca == EnumCreatureType.MONSTER && this.oceanMonumentGen.func_175796_a(this.getWorld(), blockPos)) {
            return this.oceanMonumentGen instanceof OTGOceanMonumentGen ? ((OTGOceanMonumentGen)this.oceanMonumentGen).getMonsterSpawnList() : ((StructureOceanMonument)this.oceanMonumentGen).func_175799_b();
        }
        return biomeBaseOTG.func_76747_a(paramaca);
    }

    @Override
    public void spawnEntity(EntityFunction<?> entityData) {
        block44: {
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.DEBUG, "Attempting to spawn BO3 Entity() " + entityData.groupSize + " x " + entityData.mobName + " at " + entityData.x + " " + entityData.y + " " + entityData.z, new Object[0]);
            }
            Random rand = new Random();
            String mobTypeName = entityData.mobName;
            int groupSize = entityData.groupSize;
            String nameTag = entityData.nameTagOrNBTFileName;
            Class<? extends Entity> entityClass = MobSpawnGroupHelper.toMinecraftClass(mobTypeName);
            if (entityClass == null) {
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Could not find entity: " + mobTypeName, new Object[0]);
                }
                return;
            }
            ResourceLocation entityResourceLocation = MobSpawnGroupHelper.resourceLocationFromMinecraftClass(entityClass);
            Entity entityliving = null;
            float rotationFromNbt = 0.0f;
            boolean rotationFromNbtSet = false;
            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        if (OTG.getPluginConfig().spawnLog) {
                            OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                        }
                        return;
                    }
                    nbttagcompound = nbtbase;
                }
                catch (NBTException nbtexception) {
                    if (OTG.getPluginConfig().spawnLog) {
                        OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                    }
                    return;
                }
                nbttagcompound.func_74778_a("id", entityResourceLocation.toString());
                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
                if (nbttagcompound.func_74764_b("Facing")) {
                    EnumFacing facing = EnumFacing.func_82600_a((int)nbttagcompound.func_74771_c("Facing"));
                    rotationFromNbt = facing.func_176736_b() * 90;
                    rotationFromNbtSet = true;
                }
            } else {
                try {
                    entityliving = entityClass.getConstructor(World.class).newInstance(this.world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
            if (entityliving == null) break block44;
            EnumCreatureType creatureType = EnumCreatureType.MONSTER;
            if (!(entityliving.isCreatureType(creatureType, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.CREATURE, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.AMBIENT, false) || entityliving.isCreatureType(creatureType = EnumCreatureType.WATER_CREATURE, false))) {
                creatureType = EnumCreatureType.CREATURE;
            }
            int j1 = entityData.x;
            int k1 = entityData.y;
            int l1 = entityData.z;
            boolean isWaterMob = entityliving instanceof EntityGuardian;
            Material material = this.world.func_180495_p(new BlockPos(j1, k1, l1)).func_185904_a();
            if (!this.world.func_175677_d(new BlockPos(j1, k1, l1), false) && ((creatureType == EnumCreatureType.WATER_CREATURE || isWaterMob) && material == Material.field_151586_h || material == Material.field_151579_a)) {
                float f = (float)j1 + 0.5f;
                float f1 = k1;
                float f2 = (float)l1 + 0.5f;
                entityliving.func_70012_b((double)f, (double)f1, (double)f2, rotationFromNbtSet ? rotationFromNbt : rand.nextFloat() * 360.0f, 0.0f);
                if (entityliving instanceof EntityLiving) {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                try {
                                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                                    if (!(nbtbase instanceof NBTTagCompound)) {
                                        if (OTG.getPluginConfig().spawnLog) {
                                            OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                        }
                                        return;
                                    }
                                    nbttagcompound = nbtbase;
                                }
                                catch (NBTException nbtexception) {
                                    if (OTG.getPluginConfig().spawnLog) {
                                        OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                    }
                                    return;
                                }
                                nbttagcompound.func_74778_a("id", entityResourceLocation.toString());
                                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
                            } else {
                                try {
                                    entityliving = entityClass.getConstructor(World.class).newInstance(this.world);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return;
                                }
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rotationFromNbtSet ? rotationFromNbt : rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (entityData.nameTagOrNBTFileName != null && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") && !entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt") && nameTag != null && nameTag.length() > 0) {
                            ((EntityLiving)entityliving).func_96094_a(nameTag);
                        }
                        ((EntityLiving)entityliving).func_110163_bv();
                        if (OTG.getPluginConfig().spawnLog) {
                            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
                        }
                        this.world.func_72838_d(entityliving);
                    }
                } else {
                    for (int r = 0; r < groupSize; ++r) {
                        if (r != 0) {
                            if (entityData.nameTagOrNBTFileName != null && (entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt") || entityData.nameTagOrNBTFileName.toLowerCase().trim().endsWith(".nbt"))) {
                                NBTTagCompound nbttagcompound = new NBTTagCompound();
                                try {
                                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)entityData.getMetaData());
                                    if (!(nbtbase instanceof NBTTagCompound)) {
                                        if (OTG.getPluginConfig().spawnLog) {
                                            OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                        }
                                        return;
                                    }
                                    nbttagcompound = nbtbase;
                                }
                                catch (NBTException nbtexception) {
                                    if (OTG.getPluginConfig().spawnLog) {
                                        OTG.log(LogMarker.WARN, "Invalid NBT tag for mob in EntityFunction: " + entityData.getMetaData() + ". Skipping mob.", new Object[0]);
                                    }
                                    return;
                                }
                                nbttagcompound.func_74778_a("id", entityResourceLocation.toString());
                                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.world);
                                if (nbttagcompound.func_74764_b("Facing")) {
                                    EnumFacing facing = EnumFacing.func_82600_a((int)nbttagcompound.func_74771_c("Facing"));
                                    rotationFromNbt = facing.func_176736_b() * 90;
                                    rotationFromNbtSet = true;
                                }
                            } else {
                                try {
                                    entityliving = entityClass.getConstructor(World.class).newInstance(this.world);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    return;
                                }
                            }
                            entityliving.func_70012_b((double)f, (double)f1, (double)f2, rotationFromNbtSet ? rotationFromNbt : rand.nextFloat() * 360.0f, 0.0f);
                        }
                        if (OTG.getPluginConfig().spawnLog) {
                            OTG.log(LogMarker.DEBUG, "Spawned OK", new Object[0]);
                        }
                        if (entityliving instanceof EntityItemFrame) {
                            ((EntityItemFrame)entityliving).field_174860_b = ((EntityItemFrame)entityliving).field_174860_b == null ? EnumFacing.SOUTH : ((EntityItemFrame)entityliving).field_174860_b;
                        }
                        this.world.func_72838_d(entityliving);
                    }
                }
            }
        }
    }

    @Override
    public boolean generateModdedCaveGen(int x, int z, ChunkBuffer chunkBuffer) {
        if (this.cavesGen == null) {
            return false;
        }
        ChunkPrimer primer = ((ForgeChunkBuffer)chunkBuffer).getChunkPrimer();
        this.cavesGen.func_186125_a(this.world, x, z, primer);
        return true;
    }
}

