/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.exception;

import com.pg85.otg.util.helpers.StringHelper;
import java.util.Collection;

public class BiomeNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 6832663686946138366L;
    private final String biomeName;

    public BiomeNotFoundException(String biomeName, Collection<?> biomes) {
        super("Biome " + biomeName + " not found; available biomes: " + StringHelper.join(biomes, ", "));
        this.biomeName = biomeName;
    }

    public BiomeNotFoundException(int biomeId, Collection<?> biomes) {
        super("Biome with id " + biomeId + " not found; available biomes: " + StringHelper.join(biomes, ", "));
        this.biomeName = "biome-" + biomeId;
    }

    public String getBiomeName() {
        return this.biomeName;
    }
}

