/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4;

import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLine;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLineDiagonal;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.surface.MesaSurfaceGenerator;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SmoothingAreaGenerator {
    private Map<ChunkCoordinate, ArrayList<SmoothingAreaLineDiagonal>> smoothingAreasToSpawnPerDiagonalLineDestination = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLineDiagonal>>();
    private Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawnPerLineOrigin = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();

    void customObjectStructureSpawn(Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn) {
        HashMap smoothingAreasToSpawnPerDiagonalLineOrigin = new HashMap();
        this.smoothingAreasToSpawnPerDiagonalLineDestination.clear();
        this.smoothingAreasToSpawnPerLineOrigin.clear();
        HashMap smoothingAreasToSpawnPerLineDestination = new HashMap();
        for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingArea : smoothingAreasToSpawn.entrySet()) {
            ArrayList<SmoothingAreaLine> smoothingAreaLines = smoothingArea.getValue();
            for (SmoothingAreaLine smoothingAreaLine : smoothingAreaLines) {
                int originPointX2 = smoothingAreaLine.originPointX;
                int originPointZ2 = smoothingAreaLine.originPointZ;
                ChunkCoordinate originChunk = ChunkCoordinate.fromBlockCoords(originPointX2, originPointZ2);
                ArrayList<SmoothingAreaLine> lineInOriginChunkSaved2 = this.smoothingAreasToSpawnPerLineOrigin.get(originChunk);
                if (lineInOriginChunkSaved2 == null) {
                    ArrayList<SmoothingAreaLine> smoothingAreaLines2 = new ArrayList<SmoothingAreaLine>();
                    smoothingAreaLines2.add(smoothingAreaLine);
                    this.smoothingAreasToSpawnPerLineOrigin.put(ChunkCoordinate.fromChunkCoords(originPointX2, originPointZ2), smoothingAreaLines2);
                } else {
                    lineInOriginChunkSaved2.add(smoothingAreaLine);
                }
                int finalDestinationPointX2 = smoothingAreaLine.finalDestinationPointX;
                int finalDestinationPointZ2 = smoothingAreaLine.finalDestinationPointZ;
                originChunk = ChunkCoordinate.fromBlockCoords(finalDestinationPointX2, finalDestinationPointZ2);
                ArrayList lineInOriginChunkSaved3 = (ArrayList)smoothingAreasToSpawnPerLineDestination.get(originChunk);
                if (lineInOriginChunkSaved3 == null) {
                    ArrayList<SmoothingAreaLine> smoothingAreaLines2 = new ArrayList<SmoothingAreaLine>();
                    smoothingAreaLines2.add(smoothingAreaLine);
                    smoothingAreasToSpawnPerLineDestination.put(ChunkCoordinate.fromChunkCoords(finalDestinationPointX2, finalDestinationPointZ2), smoothingAreaLines2);
                } else {
                    lineInOriginChunkSaved3.add(smoothingAreaLine);
                }
                if (!(smoothingAreaLine instanceof SmoothingAreaLineDiagonal)) continue;
                int diagonalLineFinalOriginPointX2 = ((SmoothingAreaLineDiagonal)smoothingAreaLine).diagonalLineOriginPointX;
                int diagonalLineFinalOriginPointZ2 = ((SmoothingAreaLineDiagonal)smoothingAreaLine).diagonalLineOriginPointZ;
                int diagonalLineFinalDestinationPointX2 = ((SmoothingAreaLineDiagonal)smoothingAreaLine).diagonalLineFinalDestinationPointX;
                int diagonalLineFinalDestinationPointZ2 = ((SmoothingAreaLineDiagonal)smoothingAreaLine).diagonalLineFinalDestinationPointZ;
                originChunk = ChunkCoordinate.fromBlockCoords(diagonalLineFinalOriginPointX2, diagonalLineFinalOriginPointZ2);
                ArrayList lineInOriginChunkSaved4 = (ArrayList)smoothingAreasToSpawnPerDiagonalLineOrigin.get(originChunk);
                if (lineInOriginChunkSaved4 == null) {
                    ArrayList<SmoothingAreaLineDiagonal> smoothingAreaLines2 = new ArrayList<SmoothingAreaLineDiagonal>();
                    smoothingAreaLines2.add((SmoothingAreaLineDiagonal)smoothingAreaLine);
                    smoothingAreasToSpawnPerDiagonalLineOrigin.put(ChunkCoordinate.fromChunkCoords(diagonalLineFinalOriginPointX2, diagonalLineFinalOriginPointZ2), smoothingAreaLines2);
                } else {
                    lineInOriginChunkSaved4.add((SmoothingAreaLineDiagonal)smoothingAreaLine);
                }
                originChunk = ChunkCoordinate.fromBlockCoords(diagonalLineFinalDestinationPointX2, diagonalLineFinalDestinationPointZ2);
                ArrayList<SmoothingAreaLineDiagonal> lineInOriginChunkSaved = this.smoothingAreasToSpawnPerDiagonalLineDestination.get(originChunk);
                if (lineInOriginChunkSaved == null) {
                    ArrayList<SmoothingAreaLineDiagonal> smoothingAreaLines2 = new ArrayList<SmoothingAreaLineDiagonal>();
                    smoothingAreaLines2.add((SmoothingAreaLineDiagonal)smoothingAreaLine);
                    this.smoothingAreasToSpawnPerDiagonalLineDestination.put(ChunkCoordinate.fromChunkCoords(diagonalLineFinalDestinationPointX2, diagonalLineFinalDestinationPointZ2), smoothingAreaLines2);
                    continue;
                }
                lineInOriginChunkSaved.add((SmoothingAreaLineDiagonal)smoothingAreaLine);
            }
        }
    }

    Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> calculateSmoothingAreas(Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn, BO4CustomStructureCoordinate start, LocalWorld world) {
        HashMap<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> smoothToBlocksPerChunk = new HashMap<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>>();
        for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> chunkCoordSet : objectsToSpawn.entrySet()) {
            ChunkCoordinate chunkCoord = chunkCoordSet.getKey();
            Stack<BO4CustomStructureCoordinate> bO3sInChunk = chunkCoordSet.getValue();
            ArrayList<BlockCoordsAndNeighbours> smoothToBlocks = new ArrayList<BlockCoordsAndNeighbours>();
            for (BO4CustomStructureCoordinate objectInChunk : bO3sInChunk) {
                int smoothRadius;
                if (objectInChunk.isSpawned) continue;
                BO4 bO3InChunk = (BO4)objectInChunk.getObject();
                boolean SmoothStartTop = ((BO4)start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothStartTop : bO3InChunk.getSettings().smoothStartTop;
                int n = smoothRadius = ((BO4)start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius;
                if (smoothRadius == -1 || bO3InChunk.getSettings().smoothRadius == -1) {
                    smoothRadius = 0;
                }
                if (smoothRadius <= 0) continue;
                BO4BlockFunction[][] heightMap = bO3InChunk.getSettings().getSmoothingHeightMap((BO4)start.getObject());
                for (int x = 0; x <= 15; ++x) {
                    for (int z = 0; z <= 15; ++z) {
                        Object[] smoothDirections;
                        BO4CustomStructureCoordinate blockCoords;
                        int smoothRadius1;
                        int normalizedNeigbouringBlockZ;
                        int normalizedNeigbouringBlockY;
                        int normalizedNeigbouringBlockX;
                        BO4CustomStructureCoordinate neighbouringBlockCoords;
                        BO4BlockFunction block = heightMap[x][z];
                        if (block == null) continue;
                        boolean bFoundNeighbour1 = false;
                        boolean bFoundNeighbour2 = false;
                        boolean bFoundNeighbour3 = false;
                        boolean bFoundNeighbour4 = false;
                        if (block.x - 1 >= 0 && heightMap[block.x - 1][block.z] != null) {
                            bFoundNeighbour1 = true;
                        }
                        if (block.x + 1 <= 15 && heightMap[block.x + 1][block.z] != null) {
                            bFoundNeighbour2 = true;
                        }
                        if (block.z - 1 >= 0 && heightMap[block.x][block.z - 1] != null) {
                            bFoundNeighbour3 = true;
                        }
                        if (block.z + 1 <= 15 && heightMap[block.x][block.z + 1] != null) {
                            bFoundNeighbour4 = true;
                        }
                        if (!bFoundNeighbour1 && block.x - 1 < 0) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x - 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour1 = this.findNeighbouringBlock(SmoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start);
                        }
                        if (!bFoundNeighbour2 && block.x + 1 > 15) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + 1, block.y, block.z, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour2 = this.findNeighbouringBlock(SmoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start);
                        }
                        if (!bFoundNeighbour3 && block.z - 1 < 0) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z - 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour3 = this.findNeighbouringBlock(SmoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start);
                        }
                        if (!bFoundNeighbour4 && block.z + 1 > 15) {
                            neighbouringBlockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x, block.y, block.z + 1, objectInChunk.getRotation());
                            normalizedNeigbouringBlockX = neighbouringBlockCoords.getX() + objectInChunk.getX();
                            normalizedNeigbouringBlockY = neighbouringBlockCoords.getY() + objectInChunk.getY();
                            normalizedNeigbouringBlockZ = neighbouringBlockCoords.getZ() + objectInChunk.getZ();
                            bFoundNeighbour4 = this.findNeighbouringBlock(SmoothStartTop, normalizedNeigbouringBlockX, normalizedNeigbouringBlockY, normalizedNeigbouringBlockZ, objectsToSpawn, objectInChunk, start);
                        }
                        if (bFoundNeighbour1 && bFoundNeighbour2 && bFoundNeighbour3 && bFoundNeighbour4) continue;
                        int xOffset = 0;
                        int yOffset = 0;
                        int zOffset = 0;
                        int smoothHeightOffset = ((BO4)start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothHeightOffset : bO3InChunk.getSettings().smoothHeightOffset;
                        yOffset += smoothHeightOffset;
                        int n2 = bO3InChunk.getSettings().smoothRadius == -1 ? 0 : (smoothRadius1 = (((BO4)start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius) - 1);
                        int smoothRadius2 = bO3InChunk.getSettings().smoothRadius == -1 ? 0 : (int)Math.ceil((double)((((BO4)start.getObject()).getSettings().overrideChildSettings && bO3InChunk.getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothRadius : bO3InChunk.getSettings().smoothRadius) - 1) * Math.sin(0.7853981634));
                        int xOffset1 = 0;
                        int zOffset1 = 0;
                        if (!bFoundNeighbour1) {
                            xOffset = -1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(true, false, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1));
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(true, false, true, false, objectInChunk.getRotation());
                                this.plotDiagonalLine(smoothToBlocksPerChunk, new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2), world);
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(true, false, false, true, objectInChunk.getRotation());
                                this.plotDiagonalLine(smoothToBlocksPerChunk, new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2), world);
                            }
                        }
                        if (!bFoundNeighbour2) {
                            xOffset = 1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(false, true, false, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1));
                            if (!bFoundNeighbour3) {
                                zOffset = -1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(false, true, true, false, objectInChunk.getRotation());
                                this.plotDiagonalLine(smoothToBlocksPerChunk, new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2), world);
                            }
                            if (!bFoundNeighbour4) {
                                zOffset = 1;
                                blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                                smoothDirections = this.rotateSmoothDirections(false, true, false, true, objectInChunk.getRotation());
                                this.plotDiagonalLine(smoothToBlocksPerChunk, new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1, smoothRadius2), world);
                            }
                        }
                        if (!bFoundNeighbour3) {
                            zOffset = -1;
                            blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                            smoothDirections = this.rotateSmoothDirections(false, false, true, false, objectInChunk.getRotation());
                            smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1));
                        }
                        if (bFoundNeighbour4) continue;
                        zOffset = 1;
                        blockCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(block.x + xOffset1, (short)(block.y + yOffset), block.z + zOffset + zOffset1, objectInChunk.getRotation());
                        smoothDirections = this.rotateSmoothDirections(false, false, false, true, objectInChunk.getRotation());
                        smoothToBlocks.add(new BlockCoordsAndNeighbours(objectInChunk, blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), (Boolean)smoothDirections[0], (Boolean)smoothDirections[1], (Boolean)smoothDirections[2], (Boolean)smoothDirections[3], smoothRadius1));
                    }
                }
            }
            if (!smoothToBlocksPerChunk.containsKey(chunkCoord)) {
                smoothToBlocksPerChunk.put(chunkCoord, smoothToBlocks);
                continue;
            }
            ((ArrayList)smoothToBlocksPerChunk.get(chunkCoord)).addAll(smoothToBlocks);
        }
        return this.calculateBeginAndEndPointsPerChunk(smoothToBlocksPerChunk);
    }

    private boolean findNeighbouringBlock(boolean SmoothStartTop, int normalizedNeigbouringBlockX, int normalizedNeigbouringBlockY, int normalizedNeigbouringBlockZ, Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn, BO4CustomStructureCoordinate objectInChunk, BO4CustomStructureCoordinate start) {
        Stack<BO4CustomStructureCoordinate> bO3sInNeighbouringBlockChunk;
        ChunkCoordinate neighbouringBlockChunk = null;
        ChunkCoordinate searchTarget = ChunkCoordinate.fromBlockCoords(normalizedNeigbouringBlockX, normalizedNeigbouringBlockZ);
        for (ChunkCoordinate chunkInStructure : objectsToSpawn.keySet()) {
            if (chunkInStructure.getChunkX() != searchTarget.getChunkX() || chunkInStructure.getChunkZ() != searchTarget.getChunkZ()) continue;
            neighbouringBlockChunk = chunkInStructure;
            break;
        }
        if (neighbouringBlockChunk != null && (bO3sInNeighbouringBlockChunk = objectsToSpawn.get(neighbouringBlockChunk)) != null) {
            for (CustomStructureCoordinate customStructureCoordinate : bO3sInNeighbouringBlockChunk) {
                if (customStructureCoordinate == objectInChunk) continue;
                BO4BlockFunction[][] neighbouringBO3HeightMap = ((BO4)customStructureCoordinate.getObject()).getSettings().getSmoothingHeightMap((BO4)start.getObject());
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        BO4BlockFunction blockToCheck = neighbouringBO3HeightMap[x][z];
                        if (blockToCheck == null) continue;
                        BO4CustomStructureCoordinate blockToCheckCoords = BO4CustomStructureCoordinate.getRotatedSmoothingCoords(blockToCheck.x, blockToCheck.y, blockToCheck.z, customStructureCoordinate.getRotation());
                        int normalizedBlockToCheckX = blockToCheckCoords.getX() + customStructureCoordinate.getX();
                        int normalizedBlockToCheckY = blockToCheckCoords.getY() + customStructureCoordinate.getY();
                        int normalizedBlockToCheckZ = blockToCheckCoords.getZ() + customStructureCoordinate.getZ();
                        if (normalizedNeigbouringBlockX != normalizedBlockToCheckX || normalizedNeigbouringBlockY != normalizedBlockToCheckY && !SmoothStartTop || normalizedNeigbouringBlockZ != normalizedBlockToCheckZ || !this.isMaterialSmoothingAnchor(blockToCheck, customStructureCoordinate, start)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private Object[] rotateSmoothDirections(Boolean smoothDirection1, Boolean smoothDirection2, Boolean smoothDirection3, Boolean smoothDirection4, Rotation rotation) {
        if (rotation == Rotation.NORTH) {
            return new Object[]{smoothDirection1, smoothDirection2, smoothDirection3, smoothDirection4};
        }
        if (rotation == Rotation.EAST) {
            return new Object[]{smoothDirection4, smoothDirection3, smoothDirection1, smoothDirection2};
        }
        if (rotation == Rotation.SOUTH) {
            return new Object[]{smoothDirection2, smoothDirection1, smoothDirection4, smoothDirection3};
        }
        return new Object[]{smoothDirection3, smoothDirection4, smoothDirection2, smoothDirection1};
    }

    private boolean isMaterialSmoothingAnchor(BO4BlockFunction blockToCheck, CustomStructureCoordinate bO3ToCheck, CustomStructureCoordinate start) {
        boolean isSmoothAreaAnchor = false;
        if (blockToCheck instanceof BO4RandomBlockFunction) {
            for (LocalMaterialData material : ((BO4RandomBlockFunction)blockToCheck).blocks) {
                if (material == null || !material.isSmoothAreaAnchor(((BO4)start.getObject()).getSettings().overrideChildSettings && ((BO4)bO3ToCheck.getObject()).getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothStartWood : ((BO4)bO3ToCheck.getObject()).getSettings().smoothStartWood, ((BO4)start.getObject()).getSettings().spawnUnderWater)) continue;
                isSmoothAreaAnchor = true;
                break;
            }
        }
        return isSmoothAreaAnchor || !(blockToCheck instanceof BO4RandomBlockFunction) && blockToCheck.material.isSmoothAreaAnchor(((BO4)start.getObject()).getSettings().overrideChildSettings && ((BO4)bO3ToCheck.getObject()).getSettings().overrideChildSettings ? ((BO4)start.getObject()).getSettings().smoothStartWood : ((BO4)bO3ToCheck.getObject()).getSettings().smoothStartWood, ((BO4)start.getObject()).getSettings().spawnUnderWater);
    }

    private void plotDiagonalLine(Map<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> smoothToBlocksPerChunk, BlockCoordsAndNeighbours blockCoordsAndNeighbours, LocalWorld world) {
        ArrayList beginAndEndPoints;
        ChunkCoordinate chunkcontainingSmoothArea;
        ArrayList<SmoothingAreaLine> beginningAndEndpoints;
        ChunkCoordinate nextBlocksChunkCoord;
        ChunkCoordinate destinationChunk;
        int normalizedSmoothEndPointBlockZ;
        int normalizedSmoothEndPointBlockX;
        int i;
        int beginPointZ;
        short beginPointY;
        int beginPointX;
        int normalizedSmoothFinalEndPointBlockZ1;
        int normalizedSmoothFinalEndPointBlockX1;
        HashMap smoothingAreasToSpawn = new HashMap();
        short normalizedSmoothFinalEndPointBlockY1 = -1;
        BO4CustomStructureCoordinate bO3 = blockCoordsAndNeighbours.bO3;
        int blockX = blockCoordsAndNeighbours.blockX;
        short blockY = blockCoordsAndNeighbours.blockY;
        int blockZ = blockCoordsAndNeighbours.blockZ;
        boolean smoothInDirection1 = blockCoordsAndNeighbours.smoothInDirection1;
        boolean smoothInDirection2 = blockCoordsAndNeighbours.smoothInDirection2;
        boolean smoothInDirection3 = blockCoordsAndNeighbours.smoothInDirection3;
        boolean smoothInDirection4 = blockCoordsAndNeighbours.smoothInDirection4;
        int smoothRadius = blockCoordsAndNeighbours.smoothRadius;
        int smoothRadiusDiagonal = blockCoordsAndNeighbours.smoothRadiusDiagonal;
        if (smoothInDirection1 && smoothInDirection3) {
            normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = (short)(blockY + bO3.getY());
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX - 1, normalizedSmoothEndPointBlockZ - 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList<SmoothingAreaLine>();
                beginningAndEndpoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX - 1;
                beginPointZ = normalizedSmoothEndPointBlockZ - 1;
            }
        }
        if (smoothInDirection1 && smoothInDirection4) {
            normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = (short)(blockY + bO3.getY());
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX - 1, normalizedSmoothEndPointBlockZ + 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX - 1;
                beginPointZ = normalizedSmoothEndPointBlockZ + 1;
            }
        }
        if (smoothInDirection2 && smoothInDirection3) {
            normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = (short)(blockY + bO3.getY());
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX + 1, normalizedSmoothEndPointBlockZ - 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX + 1;
                beginPointZ = normalizedSmoothEndPointBlockZ - 1;
            }
        }
        if (smoothInDirection2 && smoothInDirection4) {
            normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadiusDiagonal + bO3.getX();
            normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadiusDiagonal + bO3.getZ();
            beginPointX = blockX + bO3.getX();
            beginPointY = (short)(blockY + bO3.getY());
            beginPointZ = blockZ + bO3.getZ();
            for (i = 0; i <= smoothRadiusDiagonal; ++i) {
                normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ());
                if (destinationChunk.equals(nextBlocksChunkCoord = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX + 1, normalizedSmoothEndPointBlockZ + 1)) && i != smoothRadiusDiagonal) continue;
                beginningAndEndpoints = new ArrayList();
                beginningAndEndpoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                for (Map.Entry chunkcontainingSmoothAreaSet : smoothingAreasToSpawn.entrySet()) {
                    chunkcontainingSmoothArea = (ChunkCoordinate)chunkcontainingSmoothAreaSet.getKey();
                    if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                    beginAndEndPoints = (ArrayList)chunkcontainingSmoothAreaSet.getValue();
                    beginAndEndPoints.add(new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, normalizedSmoothEndPointBlockX, beginPointY, normalizedSmoothEndPointBlockZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1));
                    break;
                }
                smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                beginPointX = normalizedSmoothEndPointBlockX + 1;
                beginPointZ = normalizedSmoothEndPointBlockZ + 1;
            }
        }
        int diagonalBlockSmoothRadius = 0;
        int diagonalBlockSmoothRadius2 = 0;
        for (Map.Entry smoothingAreaInChunk : smoothingAreasToSpawn.entrySet()) {
            for (SmoothingAreaLine smoothingBeginAndEndPoints : (ArrayList)smoothingAreaInChunk.getValue()) {
                int distanceFromStart = 0;
                SmoothingAreaBlock beginPoint = new SmoothingAreaBlock();
                beginPoint.x = smoothingBeginAndEndPoints.beginPointX;
                beginPoint.y = smoothingBeginAndEndPoints.beginPointY;
                beginPoint.z = smoothingBeginAndEndPoints.beginPointZ;
                SmoothingAreaBlock endPoint = new SmoothingAreaBlock();
                endPoint.x = smoothingBeginAndEndPoints.endPointX;
                endPoint.y = smoothingBeginAndEndPoints.endPointY;
                endPoint.z = smoothingBeginAndEndPoints.endPointZ;
                int originPointX = smoothingBeginAndEndPoints.originPointX;
                short originPointY = smoothingBeginAndEndPoints.originPointY;
                int originPointZ = smoothingBeginAndEndPoints.originPointZ;
                int finalDestinationPointX = smoothingBeginAndEndPoints.finalDestinationPointX;
                short finalDestinationPointY = smoothingBeginAndEndPoints.finalDestinationPointY;
                int finalDestinationPointZ = smoothingBeginAndEndPoints.finalDestinationPointZ;
                diagonalBlockSmoothRadius = smoothRadius;
                distanceFromStart = Math.abs(beginPoint.x - originPointX);
                for (int i2 = 0; i2 <= Math.abs(beginPoint.z - endPoint.z); ++i2) {
                    SmoothingAreaBlock filler = new SmoothingAreaBlock();
                    if (smoothInDirection2) {
                        filler.x = beginPoint.x + i2;
                    }
                    if (smoothInDirection1) {
                        filler.x = beginPoint.x - i2;
                    }
                    if (smoothInDirection4) {
                        filler.z = beginPoint.z + i2;
                    }
                    if (smoothInDirection3) {
                        filler.z = beginPoint.z - i2;
                    }
                    filler.y = beginPoint.y;
                    ArrayList<BlockCoordsAndNeighboursDiagonal> smoothToBlocks = new ArrayList<BlockCoordsAndNeighboursDiagonal>();
                    bO3 = new BO4CustomStructureCoordinate(world, null, null, null, 0, 0, 0, 0, false, false, null);
                    diagonalBlockSmoothRadius2 = (int)Math.round(Math.sqrt(diagonalBlockSmoothRadius * diagonalBlockSmoothRadius - (distanceFromStart + i2) * (distanceFromStart + i2)) - (double)(distanceFromStart + i2));
                    destinationChunk = ChunkCoordinate.fromBlockCoords(beginPoint.x, endPoint.x);
                    if (smoothInDirection1) {
                        smoothToBlocks.add(new BlockCoordsAndNeighboursDiagonal(bO3, filler.x, filler.y, filler.z, true, false, false, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ));
                    }
                    if (smoothInDirection2) {
                        smoothToBlocks.add(new BlockCoordsAndNeighboursDiagonal(bO3, filler.x, filler.y, filler.z, false, true, false, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ));
                    }
                    if (smoothInDirection3) {
                        smoothToBlocks.add(new BlockCoordsAndNeighboursDiagonal(bO3, filler.x, filler.y, filler.z, false, false, true, false, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ));
                    }
                    if (smoothInDirection4) {
                        smoothToBlocks.add(new BlockCoordsAndNeighboursDiagonal(bO3, filler.x, filler.y, filler.z, false, false, false, true, diagonalBlockSmoothRadius2, originPointX, originPointY, originPointZ, finalDestinationPointX, finalDestinationPointY, finalDestinationPointZ));
                    }
                    if (!smoothToBlocksPerChunk.containsKey(destinationChunk)) {
                        smoothToBlocksPerChunk.put(destinationChunk, smoothToBlocks);
                        continue;
                    }
                    smoothToBlocksPerChunk.get(destinationChunk).addAll(smoothToBlocks);
                }
            }
        }
    }

    private Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> calculateBeginAndEndPointsPerChunk(Map<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> smoothToBlocksPerChunk) {
        HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
        int originPointX = 0;
        short originPointY = 0;
        int originPointZ = 0;
        int finalDestinationPointX = 0;
        short finalDestinationPointY = 0;
        int finalDestinationPointZ = 0;
        for (Map.Entry<ChunkCoordinate, ArrayList<BlockCoordsAndNeighbours>> chunkCoordSet : smoothToBlocksPerChunk.entrySet()) {
            for (BlockCoordsAndNeighbours blockCoordsAndNeighbours : chunkCoordSet.getValue()) {
                ArrayList beginAndEndPoints;
                ChunkCoordinate chunkcontainingSmoothArea;
                SmoothingAreaLine objectToAdd;
                ArrayList<SmoothingAreaLine> beginningAndEndpoints;
                int endPointZ;
                short endPointY;
                int endPointX;
                int beginPointZ;
                short beginPointY;
                int beginPointX;
                boolean bFound;
                ChunkCoordinate destinationChunk;
                int normalizedSmoothEndPointBlockZ;
                short normalizedSmoothEndPointBlockY;
                int normalizedSmoothEndPointBlockX;
                int i;
                ArrayList<ChunkCoordinate> smoothingAreasToSpawnForThisBlock;
                ChunkCoordinate finalDestinationChunk;
                short normalizedSmoothFinalEndPointBlockY1;
                int normalizedSmoothFinalEndPointBlockZ1;
                int normalizedSmoothFinalEndPointBlockX1;
                BO4CustomStructureCoordinate bO3 = blockCoordsAndNeighbours.bO3;
                int blockX = blockCoordsAndNeighbours.blockX;
                short blockY = blockCoordsAndNeighbours.blockY;
                int blockZ = blockCoordsAndNeighbours.blockZ;
                boolean smoothInDirection1 = blockCoordsAndNeighbours.smoothInDirection1;
                boolean smoothInDirection2 = blockCoordsAndNeighbours.smoothInDirection2;
                boolean smoothInDirection3 = blockCoordsAndNeighbours.smoothInDirection3;
                boolean smoothInDirection4 = blockCoordsAndNeighbours.smoothInDirection4;
                int smoothRadius = blockCoordsAndNeighbours.smoothRadius;
                if (blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal) {
                    originPointX = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).originPointX;
                    originPointY = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).originPointY;
                    originPointZ = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).originPointZ;
                    finalDestinationPointX = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).finalDestinationPointX;
                    finalDestinationPointY = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).finalDestinationPointY;
                    finalDestinationPointZ = ((BlockCoordsAndNeighboursDiagonal)blockCoordsAndNeighbours).finalDestinationPointZ;
                }
                if (smoothInDirection1) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX - smoothRadius + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList<ChunkCoordinate>();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX - i + bO3.getX();
                        normalizedSmoothEndPointBlockY = (short)(blockY + bO3.getY());
                        normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkX() * 16 : (normalizedSmoothEndPointBlockX -= smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal ? new SmoothingAreaLineDiagonal(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()) : new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1);
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection2) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + smoothRadius + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + i + bO3.getX();
                        normalizedSmoothEndPointBlockY = (short)(blockY + bO3.getY());
                        normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkX() * 16 + 15 : (normalizedSmoothEndPointBlockX += smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal ? new SmoothingAreaLineDiagonal(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()) : new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1);
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection3) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ - smoothRadius + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                        normalizedSmoothEndPointBlockY = (short)(blockY + bO3.getY());
                        normalizedSmoothEndPointBlockZ = blockZ - i + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointZ = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkZ() * 16 : (normalizedSmoothEndPointBlockZ -= smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal ? new SmoothingAreaLineDiagonal(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()) : new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1);
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection4) {
                    normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                    normalizedSmoothFinalEndPointBlockZ1 = blockZ + smoothRadius + bO3.getZ();
                    normalizedSmoothFinalEndPointBlockY1 = -1;
                    finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                    for (i = 0; i <= smoothRadius; ++i) {
                        normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                        normalizedSmoothEndPointBlockY = (short)(blockY + bO3.getY());
                        normalizedSmoothEndPointBlockZ = blockZ + i + bO3.getZ();
                        destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                        bFound = false;
                        for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                            if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        beginPointX = normalizedSmoothEndPointBlockX;
                        beginPointY = normalizedSmoothEndPointBlockY;
                        beginPointZ = normalizedSmoothEndPointBlockZ;
                        endPointX = normalizedSmoothEndPointBlockX;
                        endPointY = normalizedSmoothEndPointBlockY;
                        endPointZ = normalizedSmoothEndPointBlockZ;
                        endPointZ = finalDestinationChunk.getChunkX() != destinationChunk.getChunkX() || finalDestinationChunk.getChunkZ() != destinationChunk.getChunkZ() ? destinationChunk.getChunkZ() * 16 + 15 : (normalizedSmoothEndPointBlockZ += smoothRadius - i);
                        beginningAndEndpoints = new ArrayList();
                        objectToAdd = blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal ? new SmoothingAreaLineDiagonal(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()) : new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1);
                        beginningAndEndpoints.add(objectToAdd);
                        for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                            chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                            if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                            bFound = true;
                            beginAndEndPoints = (ArrayList)entry.getValue();
                            beginAndEndPoints.add(objectToAdd);
                            break;
                        }
                        if (!bFound) {
                            smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                        }
                        smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                    }
                    smoothingAreasToSpawnForThisBlock = new ArrayList();
                }
                if (smoothInDirection1 || smoothInDirection2 || smoothInDirection3 || smoothInDirection4) continue;
                normalizedSmoothFinalEndPointBlockX1 = blockX + bO3.getX();
                normalizedSmoothFinalEndPointBlockZ1 = blockZ + bO3.getZ();
                normalizedSmoothFinalEndPointBlockY1 = -1;
                finalDestinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockZ1);
                smoothingAreasToSpawnForThisBlock = new ArrayList();
                normalizedSmoothEndPointBlockX = blockX + bO3.getX();
                normalizedSmoothEndPointBlockY = (short)(blockY + bO3.getY());
                normalizedSmoothEndPointBlockZ = blockZ + bO3.getZ();
                destinationChunk = ChunkCoordinate.fromBlockCoords(normalizedSmoothEndPointBlockX, normalizedSmoothEndPointBlockZ);
                bFound = false;
                for (ChunkCoordinate chunkCoordinate : smoothingAreasToSpawnForThisBlock) {
                    if (destinationChunk.getChunkX() != chunkCoordinate.getChunkX() || destinationChunk.getChunkZ() != chunkCoordinate.getChunkZ()) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    beginPointX = normalizedSmoothEndPointBlockX;
                    beginPointY = normalizedSmoothEndPointBlockY;
                    beginPointZ = normalizedSmoothEndPointBlockZ;
                    endPointX = normalizedSmoothEndPointBlockX;
                    endPointY = normalizedSmoothEndPointBlockY;
                    endPointZ = normalizedSmoothEndPointBlockZ;
                    beginningAndEndpoints = new ArrayList<SmoothingAreaLine>();
                    objectToAdd = blockCoordsAndNeighbours instanceof BlockCoordsAndNeighboursDiagonal ? new SmoothingAreaLineDiagonal(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), -1, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1, originPointX + bO3.getX(), originPointY, originPointZ + bO3.getZ(), finalDestinationPointX + bO3.getX(), finalDestinationPointY, finalDestinationPointZ + bO3.getZ()) : new SmoothingAreaLine(beginPointX, beginPointY, beginPointZ, endPointX, endPointY, endPointZ, blockX + bO3.getX(), beginPointY, blockZ + bO3.getZ(), normalizedSmoothFinalEndPointBlockX1, normalizedSmoothFinalEndPointBlockY1, normalizedSmoothFinalEndPointBlockZ1);
                    if (normalizedSmoothFinalEndPointBlockY1 != -1) {
                        throw new RuntimeException();
                    }
                    beginningAndEndpoints.add(objectToAdd);
                    for (Map.Entry entry : smoothingAreasToSpawn.entrySet()) {
                        chunkcontainingSmoothArea = (ChunkCoordinate)entry.getKey();
                        if (chunkcontainingSmoothArea.getChunkX() != destinationChunk.getChunkX() || chunkcontainingSmoothArea.getChunkZ() != destinationChunk.getChunkZ()) continue;
                        bFound = true;
                        beginAndEndPoints = (ArrayList)entry.getValue();
                        beginAndEndPoints.add(objectToAdd);
                        break;
                    }
                    if (!bFound) {
                        smoothingAreasToSpawn.put(destinationChunk, beginningAndEndpoints);
                    }
                    smoothingAreasToSpawnForThisBlock.add(destinationChunk);
                }
                smoothingAreasToSpawnForThisBlock = new ArrayList();
            }
        }
        return smoothingAreasToSpawn;
    }

    boolean spawnSmoothAreas(ChunkCoordinate chunkCoordinate, Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn, CustomStructureCoordinate start, LocalWorld world) {
        Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreaInChunk = null;
        for (Map.Entry<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreaToSpawn : smoothingAreasToSpawn.entrySet()) {
            if (smoothingAreaToSpawn.getKey().getChunkX() != chunkCoordinate.getChunkX() || smoothingAreaToSpawn.getKey().getChunkZ() != chunkCoordinate.getChunkZ()) continue;
            smoothingAreaInChunk = smoothingAreaToSpawn;
            break;
        }
        if (smoothingAreaInChunk != null && smoothingAreaInChunk.getValue() != null) {
            LocalMaterialData material;
            ArrayList<SmoothingAreaLineBlock> blocksToSpawn = this.mergeSmoothingAreas(chunkCoordinate, (ArrayList)smoothingAreaInChunk.getValue(), world, start);
            if (blocksToSpawn == null) {
                return false;
            }
            boolean isOnBiomeBorder = false;
            LocalBiome biome = world.getBiome(chunkCoordinate.getChunkX() * 16, chunkCoordinate.getChunkZ() * 16);
            LocalBiome biome2 = world.getBiome(chunkCoordinate.getChunkX() * 16 + 15, chunkCoordinate.getChunkZ() * 16);
            LocalBiome biome3 = world.getBiome(chunkCoordinate.getChunkX() * 16, chunkCoordinate.getChunkZ() * 16 + 15);
            LocalBiome biome4 = world.getBiome(chunkCoordinate.getChunkX() * 16 + 15, chunkCoordinate.getChunkZ() * 16 + 15);
            if (biome != biome2 || biome != biome3 || biome != biome4) {
                isOnBiomeBorder = true;
            }
            BiomeConfig biomeConfig = biome.getBiomeConfig();
            DefaultMaterial surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
            byte surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
            DefaultMaterial groundBlockMaterial = biomeConfig.groundBlock.toDefaultMaterial();
            byte groundBlockMaterialBlockData = biomeConfig.groundBlock.getBlockData();
            boolean surfaceBlockSet = false;
            if (((BO4)start.getObject()).getSettings().smoothingSurfaceBlock != null && ((BO4)start.getObject()).getSettings().smoothingSurfaceBlock.trim().length() > 0) {
                try {
                    LocalMaterialData material2 = MaterialHelper.readMaterial(((BO4)start.getObject()).getSettings().smoothingSurfaceBlock);
                    surfaceBlockSet = true;
                    surfaceBlockMaterial = material2.toDefaultMaterial();
                    surfaceBlockMaterialBlockData = material2.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            boolean groundBlockSet = false;
            if (((BO4)start.getObject()).getSettings().smoothingGroundBlock != null && ((BO4)start.getObject()).getSettings().smoothingGroundBlock.trim().length() > 0) {
                try {
                    LocalMaterialData material3 = MaterialHelper.readMaterial(((BO4)start.getObject()).getSettings().smoothingGroundBlock);
                    groundBlockSet = true;
                    groundBlockMaterial = material3.toDefaultMaterial();
                    groundBlockMaterialBlockData = material3.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                surfaceBlockMaterial = DefaultMaterial.GRASS;
                surfaceBlockMaterialBlockData = 0;
            }
            if (groundBlockMaterial == null || groundBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                groundBlockMaterial = DefaultMaterial.DIRT;
                groundBlockMaterialBlockData = 0;
            }
            DefaultMaterial replaceAboveMaterial = null;
            byte replaceAboveMaterialBlockData = 0;
            DefaultMaterial replaceBelowMaterial = null;
            if (((BO4)start.getObject()).getSettings().replaceAbove != null && ((BO4)start.getObject()).getSettings().replaceAbove.trim().length() > 0) {
                try {
                    material = MaterialHelper.readMaterial(((BO4)start.getObject()).getSettings().replaceAbove);
                    replaceAboveMaterial = material.toDefaultMaterial();
                    replaceAboveMaterialBlockData = material.getBlockData();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (((BO4)start.getObject()).getSettings().replaceBelow != null && ((BO4)start.getObject()).getSettings().replaceBelow.trim().length() > 0) {
                try {
                    material = MaterialHelper.readMaterial(((BO4)start.getObject()).getSettings().replaceBelow);
                    replaceBelowMaterial = material.toDefaultMaterial();
                }
                catch (InvalidConfigException e) {
                    e.printStackTrace();
                }
            }
            if (replaceAboveMaterial == null || replaceAboveMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                replaceAboveMaterial = null;
                replaceAboveMaterialBlockData = 0;
            }
            if (replaceBelowMaterial == null || replaceBelowMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                replaceBelowMaterial = null;
            }
            DefaultMaterial materialToSet = null;
            Byte blockDataToSet = 0;
            SmoothingAreaBlock blockToQueueForSpawn = new SmoothingAreaBlock();
            HashMap<ChunkCoordinate, LocalMaterialData> originalTopBlocks = new HashMap<ChunkCoordinate, LocalMaterialData>();
            block9: for (SmoothingAreaLineBlock blockItemToSpawn : blocksToSpawn) {
                DefaultMaterial sourceBlockMaterialAbove;
                LocalMaterialData sourceBlockMaterial;
                short y;
                short yEnd;
                short yStart;
                SmoothingAreaBlock blockToSpawn = blockItemToSpawn.block;
                boolean goingUp = blockItemToSpawn.goingUp;
                boolean secondPass = blockItemToSpawn.isPass2;
                if (blockToSpawn.y > 255) continue;
                if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z))) {
                    int highestBlockY = world.getHighestBlockYAt(blockToSpawn.x, blockToSpawn.z, true, true, false, false);
                    if (highestBlockY > 0) {
                        originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z), world.getMaterial(blockToSpawn.x, highestBlockY, blockToSpawn.z, true));
                    } else {
                        originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z), null);
                    }
                }
                if (!(!isOnBiomeBorder || surfaceBlockSet && groundBlockSet)) {
                    biome = world.getBiome(blockToSpawn.x, blockToSpawn.z);
                    biomeConfig = biome.getBiomeConfig();
                    if (!surfaceBlockSet) {
                        surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
                        if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                            surfaceBlockMaterial = DefaultMaterial.GRASS;
                            surfaceBlockMaterialBlockData = 0;
                        }
                    }
                    if (!groundBlockSet) {
                        groundBlockMaterial = biomeConfig.groundBlock.toDefaultMaterial();
                        groundBlockMaterialBlockData = biomeConfig.groundBlock.getBlockData();
                        if (groundBlockMaterial == null || groundBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                            groundBlockMaterial = DefaultMaterial.DIRT;
                            groundBlockMaterialBlockData = 0;
                        }
                    }
                }
                if (!surfaceBlockSet && !(biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator)) {
                    LocalMaterialData originalSurfaceBlock = (LocalMaterialData)originalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToSpawn.x, blockToSpawn.z));
                    if (originalSurfaceBlock == null || originalSurfaceBlock.isLiquid() || originalSurfaceBlock.isAir()) {
                        surfaceBlockMaterial = biomeConfig.surfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = biomeConfig.surfaceBlock.getBlockData();
                    } else {
                        surfaceBlockMaterial = originalSurfaceBlock.toDefaultMaterial();
                        surfaceBlockMaterialBlockData = originalSurfaceBlock.getBlockData();
                    }
                    if (surfaceBlockMaterial == null || surfaceBlockMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
                        surfaceBlockMaterial = DefaultMaterial.GRASS;
                        surfaceBlockMaterialBlockData = 0;
                    }
                }
                boolean bBreak = false;
                if (!goingUp) {
                    yStart = blockToSpawn.y;
                    yEnd = 0;
                    for (y = yStart; y > yEnd; y = (short)(y - 1)) {
                        if (y >= 255) continue;
                        sourceBlockMaterial = world.getMaterial(blockToSpawn.x, y, blockToSpawn.z, true);
                        if (sourceBlockMaterial.isSolid() && y < blockToSpawn.y) {
                            bBreak = true;
                        }
                        if (y == blockToSpawn.y) {
                            sourceBlockMaterialAbove = world.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, true).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = surfaceBlockMaterial;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        } else if (y < blockToSpawn.y) {
                            materialToSet = groundBlockMaterial;
                            blockDataToSet = groundBlockMaterialBlockData;
                        } else {
                            throw new RuntimeException();
                        }
                        if (materialToSet != null && materialToSet != DefaultMaterial.UNKNOWN_BLOCK) {
                            blockToQueueForSpawn = new SmoothingAreaBlock();
                            blockToQueueForSpawn.x = blockToSpawn.x;
                            blockToQueueForSpawn.y = y;
                            blockToQueueForSpawn.z = blockToSpawn.z;
                            blockToQueueForSpawn.material = MaterialHelper.toLocalMaterialData(materialToSet, blockDataToSet.byteValue());
                            if (!blockToQueueForSpawn.material.isAir() && !blockToQueueForSpawn.material.isLiquid() && biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.groundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.groundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.surfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.surfaceBlock.getBlockData())) {
                                LocalMaterialData customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                                if (customBlockData != null) {
                                    blockToQueueForSpawn.material = customBlockData;
                                }
                                this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, null, world);
                            } else if (!sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                                this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, null, world);
                            }
                        } else {
                            throw new RuntimeException();
                        }
                        if (bBreak) continue block9;
                    }
                    continue;
                }
                if (!goingUp || replaceAboveMaterial == null) continue;
                yStart = (short)world.getHighestBlockYAt(blockToSpawn.x, blockToSpawn.z, true, true, false, false);
                yEnd = 0;
                for (y = yStart; y >= yEnd; y = (short)(y - 1)) {
                    if (y >= 255) continue;
                    sourceBlockMaterial = world.getMaterial(blockToSpawn.x, y, blockToSpawn.z, true);
                    DefaultMaterial sourceBlockDefaultMaterial = sourceBlockMaterial.toDefaultMaterial();
                    materialToSet = replaceAboveMaterial;
                    blockDataToSet = replaceAboveMaterialBlockData;
                    if (y < blockToSpawn.y) {
                        if (!sourceBlockMaterial.isLiquid() || secondPass && !((BO4)start.getObject()).getSettings().spawnUnderWater) continue block9;
                        if (((BO4)start.getObject()).getSettings().spawnUnderWater) {
                            materialToSet = replaceAboveMaterial;
                            blockDataToSet = replaceAboveMaterialBlockData;
                        } else {
                            sourceBlockMaterialAbove = world.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, true).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = surfaceBlockMaterial;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        }
                    }
                    if (y == blockToSpawn.y) {
                        if (sourceBlockMaterial.isSolid() || !secondPass && sourceBlockMaterial.isLiquid() && !((BO4)start.getObject()).getSettings().spawnUnderWater) {
                            sourceBlockMaterialAbove = world.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, true).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                sourceBlockMaterialAbove = world.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, true).toDefaultMaterial();
                                if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                    materialToSet = surfaceBlockMaterial;
                                    blockDataToSet = surfaceBlockMaterialBlockData;
                                } else {
                                    materialToSet = groundBlockMaterial;
                                    blockDataToSet = groundBlockMaterialBlockData;
                                }
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                        } else if (((BO4)start.getObject()).getSettings().spawnUnderWater) {
                            materialToSet = replaceAboveMaterial;
                            blockDataToSet = replaceAboveMaterialBlockData;
                        } else {
                            if (sourceBlockMaterial.isLiquid() || sourceBlockDefaultMaterial.equals((Object)DefaultMaterial.AIR)) continue block9;
                            sourceBlockMaterialAbove = world.getMaterial(blockToSpawn.x, y + 1, blockToSpawn.z, true).toDefaultMaterial();
                            if (sourceBlockMaterialAbove == null || sourceBlockMaterialAbove == DefaultMaterial.AIR) {
                                materialToSet = DefaultMaterial.AIR;
                                blockDataToSet = surfaceBlockMaterialBlockData;
                            } else {
                                materialToSet = groundBlockMaterial;
                                blockDataToSet = groundBlockMaterialBlockData;
                            }
                            bBreak = true;
                        }
                    }
                    if (materialToSet.isLiquid() && ((BO4)start.getObject()).getSettings().spawnUnderWater && y >= (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax)) {
                        materialToSet = DefaultMaterial.AIR;
                        blockDataToSet = 0;
                    }
                    if (materialToSet != null && materialToSet != DefaultMaterial.UNKNOWN_BLOCK) {
                        blockToQueueForSpawn = new SmoothingAreaBlock();
                        blockToQueueForSpawn.x = blockToSpawn.x;
                        blockToQueueForSpawn.y = y;
                        blockToQueueForSpawn.z = blockToSpawn.z;
                        blockToQueueForSpawn.material = MaterialHelper.toLocalMaterialData(materialToSet, blockDataToSet.byteValue());
                        if (!blockToQueueForSpawn.material.isAir() && !blockToQueueForSpawn.material.isLiquid() && biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.groundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.groundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeConfig.surfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeConfig.surfaceBlock.getBlockData())) {
                            LocalMaterialData customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z);
                            if (customBlockData != null) {
                                blockToQueueForSpawn.material = customBlockData;
                            }
                            this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, null, world);
                        } else if (!sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                            this.setBlock(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, null, world);
                        }
                    } else {
                        throw new RuntimeException();
                    }
                    if (bBreak) continue block9;
                }
            }
            smoothingAreaInChunk.setValue(null);
        }
        return true;
    }

    private void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, LocalWorld world) {
        LocalMaterialData targetBlock;
        HashMap<DefaultMaterial, LocalMaterialData> blocksToReplace = world.getConfigs().getWorldConfig().getReplaceBlocksDict();
        if (blocksToReplace != null && blocksToReplace.size() > 0 && (targetBlock = blocksToReplace.get((Object)material.toDefaultMaterial())) != null) {
            material = targetBlock;
        }
        world.setBlock(x, y, z, material, metaDataTag, true);
    }

    private ArrayList<SmoothingAreaLineBlock> mergeSmoothingAreas(ChunkCoordinate chunkCoordinate, ArrayList<SmoothingAreaLine> smoothingAreas, LocalWorld world, CustomStructureCoordinate start) {
        boolean diagonalLinegoingUp;
        boolean diagonalLinegoingDown;
        LocalMaterialData material;
        int diagonalLineFinalDestinationPointZ;
        short diagonalLineFinalDestinationPointY;
        int diagonalLineFinalDestinationPointX;
        int diagonalLineOriginPointZ;
        short diagonalLineoriginPointY;
        int diagonalLineOriginPointX;
        int finalDestinationPointZ;
        short finalDestinationPointY;
        int finalDestinationPointX;
        int originPointZ;
        short originPointY;
        int originPointX;
        SmoothingAreaBlock beginPoint;
        ArrayList<SmoothingAreaLineBlock> blocksToSpawn = new ArrayList<SmoothingAreaLineBlock>();
        LocalMaterialData block = null;
        LocalMaterialData[] blockColumn = null;
        LocalMaterialData[] blockColumn2 = null;
        int prevfinalDestinationPointX = 0;
        int prevfinalDestinationPointZ = 0;
        int prevDiagonalLineFinalDestinationPointX = 0;
        int prevDiagonalLineFinalDestinationPointZ = 0;
        boolean isInitialised = false;
        for (SmoothingAreaLine smoothingBeginAndEndPoints : smoothingAreas) {
            beginPoint = new SmoothingAreaBlock();
            beginPoint.x = smoothingBeginAndEndPoints.beginPointX;
            beginPoint.y = smoothingBeginAndEndPoints.beginPointY;
            beginPoint.z = smoothingBeginAndEndPoints.beginPointZ;
            originPointX = smoothingBeginAndEndPoints.originPointX;
            originPointY = smoothingBeginAndEndPoints.originPointY;
            originPointZ = smoothingBeginAndEndPoints.originPointZ;
            finalDestinationPointX = smoothingBeginAndEndPoints.finalDestinationPointX;
            finalDestinationPointY = smoothingBeginAndEndPoints.finalDestinationPointY;
            finalDestinationPointZ = smoothingBeginAndEndPoints.finalDestinationPointZ;
            diagonalLineOriginPointX = -1;
            diagonalLineoriginPointY = -1;
            diagonalLineOriginPointZ = -1;
            diagonalLineFinalDestinationPointX = -1;
            diagonalLineFinalDestinationPointY = -1;
            diagonalLineFinalDestinationPointZ = -1;
            if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal) {
                diagonalLineOriginPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineOriginPointX;
                diagonalLineoriginPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineoriginPointY;
                diagonalLineOriginPointZ = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineOriginPointZ;
                diagonalLineFinalDestinationPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointX;
                diagonalLineFinalDestinationPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY;
                diagonalLineFinalDestinationPointZ = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointZ;
                if (diagonalLineFinalDestinationPointY == -2) continue;
            }
            if (!isInitialised || prevfinalDestinationPointX != finalDestinationPointX || prevfinalDestinationPointZ != finalDestinationPointZ) {
                blockColumn = world.getBlockColumn(finalDestinationPointX, finalDestinationPointZ);
                prevfinalDestinationPointX = finalDestinationPointX;
                prevfinalDestinationPointX = finalDestinationPointZ;
            }
            if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal && (!isInitialised || prevDiagonalLineFinalDestinationPointX != diagonalLineFinalDestinationPointX || prevDiagonalLineFinalDestinationPointZ != diagonalLineFinalDestinationPointZ)) {
                blockColumn2 = world.getBlockColumn(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ);
                prevDiagonalLineFinalDestinationPointX = diagonalLineFinalDestinationPointX;
                prevDiagonalLineFinalDestinationPointZ = diagonalLineFinalDestinationPointZ;
            }
            isInitialised = true;
            if (originPointY == -1 && smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal) {
                if (diagonalLineFinalDestinationPointY == -1) {
                    material = null;
                    block = null;
                    for (short i = 255; i > -1; i = (short)((short)(i - 1))) {
                        block = blockColumn2[i];
                        material = block;
                        if (material.isAir() || (i > diagonalLineoriginPointY || material.isLiquid()) && (i <= diagonalLineoriginPointY || ((BO4)start.getObject()).getSettings().spawnUnderWater && material.isLiquid())) continue;
                        diagonalLineFinalDestinationPointY = i;
                        break;
                    }
                }
                if (diagonalLineFinalDestinationPointY == -1) {
                    diagonalLineFinalDestinationPointY = 0;
                }
                diagonalLinegoingDown = false;
                diagonalLinegoingUp = false;
                if (diagonalLineoriginPointY >= diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingDown = true;
                } else if (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingUp = true;
                }
                ArrayList<SmoothingAreaLineDiagonal> smoothingAreasToSpawnPerLineDestination = this.smoothingAreasToSpawnPerDiagonalLineDestination.get(ChunkCoordinate.fromChunkCoords(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ));
                if (smoothingAreasToSpawnPerLineDestination != null) {
                    for (SmoothingAreaLineDiagonal smoothingAreaLineDiagonal : smoothingAreasToSpawnPerLineDestination) {
                        int diagonalLineFinalOriginPointX2 = smoothingAreaLineDiagonal.diagonalLineOriginPointX;
                        int diagonalLineFinalOriginPointZ2 = smoothingAreaLineDiagonal.diagonalLineOriginPointZ;
                        short diagonalLineFinalDestinationPointY2 = smoothingAreaLineDiagonal.diagonalLineFinalDestinationPointY;
                        if (diagonalLineOriginPointX != diagonalLineFinalOriginPointX2 || diagonalLineOriginPointZ != diagonalLineFinalOriginPointZ2 || diagonalLineFinalDestinationPointY2 == -2) continue;
                        smoothingAreaLineDiagonal.diagonalLineFinalDestinationPointY = diagonalLineFinalDestinationPointY;
                    }
                }
                if (((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY == -2) continue;
                ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY = diagonalLineFinalDestinationPointY;
            }
            if (finalDestinationPointY == -1) {
                material = null;
                block = null;
                for (short i = 255; i > -1; i = (short)((short)(i - 1))) {
                    block = blockColumn[i];
                    material = block;
                    if (material.isAir() || (i > (diagonalLineoriginPointY > -1 ? diagonalLineoriginPointY : (short)originPointY) || material.isLiquid()) && (i <= (diagonalLineoriginPointY > -1 ? diagonalLineoriginPointY : (short)originPointY) || ((BO4)start.getObject()).getSettings().spawnUnderWater && material.isLiquid())) continue;
                    finalDestinationPointY = i;
                    smoothingBeginAndEndPoints.finalDestinationPointY = finalDestinationPointY;
                    ArrayList<SmoothingAreaLine> smoothingAreasForLine = this.smoothingAreasToSpawnPerLineOrigin.get(ChunkCoordinate.fromChunkCoords(originPointX, originPointZ));
                    if (smoothingAreasForLine == null) break;
                    for (SmoothingAreaLine smoothingBeginAndEndPoints2 : smoothingAreasForLine) {
                        int finalDestinationPointX2 = smoothingBeginAndEndPoints2.finalDestinationPointX;
                        int finalDestinationPointZ2 = smoothingBeginAndEndPoints2.finalDestinationPointZ;
                        if (finalDestinationPointX != finalDestinationPointX2 || finalDestinationPointZ != finalDestinationPointZ2) continue;
                        smoothingBeginAndEndPoints2.finalDestinationPointY = finalDestinationPointY;
                    }
                    break;
                }
            }
            if (finalDestinationPointY == -1) {
                finalDestinationPointY = 0;
            }
            if (smoothingBeginAndEndPoints.originPointY != -1 || !(smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal)) continue;
            diagonalLineOriginPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineOriginPointX;
            diagonalLineoriginPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineoriginPointY;
            diagonalLineFinalDestinationPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointX;
            diagonalLineFinalDestinationPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY;
            originPointY = (short)Math.round((double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX)));
            originPointY = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (short)(diagonalLineoriginPointY - originPointY) : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (short)((short)(diagonalLineoriginPointY + originPointY)) : diagonalLineoriginPointY);
            smoothingBeginAndEndPoints.originPointY = originPointY;
        }
        block5: for (SmoothingAreaLine smoothingBeginAndEndPoints : smoothingAreas) {
            short i;
            short s;
            if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal && ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY == -2) continue;
            diagonalLinegoingUp = false;
            diagonalLinegoingDown = false;
            boolean goingUp = false;
            boolean goingDown = false;
            int distanceFromStart = 0;
            beginPoint = new SmoothingAreaBlock();
            beginPoint.x = smoothingBeginAndEndPoints.beginPointX;
            beginPoint.y = smoothingBeginAndEndPoints.beginPointY;
            beginPoint.z = smoothingBeginAndEndPoints.beginPointZ;
            originPointX = smoothingBeginAndEndPoints.originPointX;
            originPointY = smoothingBeginAndEndPoints.originPointY;
            originPointZ = smoothingBeginAndEndPoints.originPointZ;
            finalDestinationPointX = smoothingBeginAndEndPoints.finalDestinationPointX;
            finalDestinationPointY = smoothingBeginAndEndPoints.finalDestinationPointY;
            finalDestinationPointZ = smoothingBeginAndEndPoints.finalDestinationPointZ;
            diagonalLineOriginPointX = -1;
            diagonalLineoriginPointY = -1;
            diagonalLineOriginPointZ = -1;
            diagonalLineFinalDestinationPointX = -1;
            diagonalLineFinalDestinationPointY = -1;
            diagonalLineFinalDestinationPointZ = -1;
            if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal) {
                diagonalLineOriginPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineOriginPointX;
                diagonalLineoriginPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineoriginPointY;
                diagonalLineOriginPointZ = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineOriginPointZ;
                diagonalLineFinalDestinationPointX = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointX;
                diagonalLineFinalDestinationPointY = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY;
                diagonalLineFinalDestinationPointZ = ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointZ;
                if (((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineoriginPointY >= ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingDown = true;
                } else if (((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineoriginPointY < ((SmoothingAreaLineDiagonal)smoothingBeginAndEndPoints).diagonalLineFinalDestinationPointY) {
                    diagonalLinegoingUp = true;
                }
            }
            short highestBlock = -1;
            material = null;
            highestBlock = finalDestinationPointY;
            if (prevfinalDestinationPointX != finalDestinationPointX || prevfinalDestinationPointZ != finalDestinationPointZ) {
                blockColumn = world.getBlockColumn(finalDestinationPointX, finalDestinationPointZ);
                prevfinalDestinationPointX = finalDestinationPointX;
                prevfinalDestinationPointZ = finalDestinationPointZ;
            }
            block = null;
            for (short i2 = highestBlock; i2 > -1; i2 = (short)(i2 - 1)) {
                block = blockColumn[i2];
                material = block;
                if (material.isAir() || (i2 > originPointY || material.isLiquid()) && (i2 <= originPointY || ((BO4)start.getObject()).getSettings().spawnUnderWater && material.isLiquid())) continue;
                finalDestinationPointY = i2;
                break;
            }
            if (finalDestinationPointY > beginPoint.y) {
                goingUp = true;
            }
            if (finalDestinationPointY <= beginPoint.y) {
                goingDown = true;
            }
            if (diagonalLinegoingUp && !goingUp) {
                finalDestinationPointY = (short)(originPointY + 75 < 256 ? originPointY + 75 : 255);
                goingUp = true;
                goingDown = false;
            } else if (diagonalLinegoingDown && !goingDown) {
                goingUp = false;
                goingDown = true;
                int distanceFromOrigin = -1;
                s = -1;
                block = null;
                for (i = originPointY; i > -1; i = (short)((short)(i - 1))) {
                    block = blockColumn[i];
                    distanceFromOrigin = Math.abs(originPointY - i);
                    LocalMaterialData materialAbove = blockColumn[i + 1];
                    material = blockColumn[i];
                    if (s == -1 && !material.isAir() && !material.isLiquid()) {
                        s = i;
                    }
                    if (distanceFromOrigin <= 30 && !material.isAir() && !material.isLiquid() && (materialAbove.isAir() || materialAbove.isLiquid())) {
                        finalDestinationPointY = i;
                        break;
                    }
                    if (distanceFromOrigin <= 30 || s <= -1) continue;
                    finalDestinationPointY = s;
                    break;
                }
                if (distanceFromOrigin > 30 && s == -1) {
                    finalDestinationPointY = originPointY;
                }
            }
            short repeats = 1;
            for (s = 0; s <= repeats; ++s) {
                SmoothingAreaBlock existingBlock;
                boolean dontAdd;
                ArrayList<SmoothingAreaLineBlock> blocksToRemove;
                int originPointZ2;
                int originPointX2;
                SmoothingAreaBlock filler;
                short surfaceBlockHeight;
                double surfaceBlockHeight2;
                double originPointY2;
                double adjustedOriginPointY;
                LocalMaterialData materialAbove;
                int distanceFromOrigin;
                if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal && s == 1) {
                    if (diagonalLinegoingDown) {
                        diagonalLineFinalDestinationPointY = (short)(diagonalLineoriginPointY + 75 < 256 ? diagonalLineoriginPointY + 75 : 255);
                    } else if (diagonalLinegoingUp) {
                        distanceFromOrigin = -1;
                        short firstSolidBlock = -1;
                        diagonalLineFinalDestinationPointY = diagonalLineoriginPointY;
                        if (prevDiagonalLineFinalDestinationPointX != diagonalLineFinalDestinationPointX || prevDiagonalLineFinalDestinationPointZ != diagonalLineFinalDestinationPointZ) {
                            blockColumn2 = world.getBlockColumn(diagonalLineFinalDestinationPointX, diagonalLineFinalDestinationPointZ);
                            prevDiagonalLineFinalDestinationPointX = diagonalLineFinalDestinationPointX;
                            prevDiagonalLineFinalDestinationPointZ = diagonalLineFinalDestinationPointZ;
                        }
                        block = null;
                        for (short i3 = diagonalLineoriginPointY; i3 > 0; i3 = (short)((short)(i3 - 1))) {
                            block = blockColumn2[i3];
                            distanceFromOrigin = Math.abs(diagonalLineoriginPointY - i3);
                            materialAbove = blockColumn2[i3 + 1];
                            material = block;
                            if (firstSolidBlock == -1 && !material.isAir() && !material.isLiquid()) {
                                firstSolidBlock = i3;
                            }
                            if (distanceFromOrigin <= 30 && !material.isAir() && !material.isLiquid() && (materialAbove.isAir() || materialAbove.isLiquid())) {
                                diagonalLineFinalDestinationPointY = i3;
                                break;
                            }
                            if (distanceFromOrigin <= 30 || firstSolidBlock <= -1) continue;
                            diagonalLineFinalDestinationPointY = firstSolidBlock;
                            break;
                        }
                    }
                    originPointY = (short)Math.ceil((double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX)));
                    originPointY = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (short)((short)(diagonalLineoriginPointY - originPointY)) : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (short)((short)(diagonalLineoriginPointY + originPointY)) : diagonalLineoriginPointY);
                    if (diagonalLinegoingUp) {
                        material = null;
                        block = null;
                        for (i = highestBlock = originPointY; i > -1; i = (short)((short)(i - 1))) {
                            block = blockColumn[i];
                            material = block;
                            if (material.isAir() || (i > originPointY || material.isLiquid()) && (i <= originPointY || ((BO4)start.getObject()).getSettings().spawnUnderWater && material.isLiquid())) continue;
                            finalDestinationPointY = i;
                            break;
                        }
                        goingUp = false;
                        goingDown = true;
                    } else if (diagonalLinegoingDown) {
                        finalDestinationPointY = (short)world.getHighestBlockYAt(finalDestinationPointX, finalDestinationPointZ, true, true, false, true);
                        if (finalDestinationPointY < diagonalLineoriginPointY) {
                            finalDestinationPointY = (short)(diagonalLineoriginPointY + 75 < 256 ? diagonalLineoriginPointY + 75 : 255);
                        }
                        goingUp = true;
                        goingDown = false;
                    }
                }
                if (s == 1 && !(smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal)) {
                    if (!goingUp) {
                        finalDestinationPointY = (short)(originPointY + 75 < 256 ? originPointY + 75 : 255);
                        goingUp = true;
                        goingDown = false;
                    } else if (goingUp) {
                        goingUp = false;
                        goingDown = true;
                        distanceFromOrigin = -1;
                        short firstSolidBlock = -1;
                        finalDestinationPointY = originPointY;
                        block = null;
                        for (short i4 = originPointY; i4 > -1; i4 = (short)((short)(i4 - 1))) {
                            block = blockColumn[i4];
                            distanceFromOrigin = Math.abs(originPointY - i4);
                            materialAbove = blockColumn[i4 + 1];
                            material = block;
                            if (firstSolidBlock == -1 && !material.isAir() && !material.isLiquid()) {
                                firstSolidBlock = i4;
                            }
                            if (distanceFromOrigin <= 30 && !material.isAir() && !material.isLiquid() && (materialAbove.isAir() || materialAbove.isLiquid())) {
                                finalDestinationPointY = i4;
                                break;
                            }
                            if (distanceFromOrigin <= 30 || firstSolidBlock <= -1) continue;
                            finalDestinationPointY = firstSolidBlock;
                            break;
                        }
                        if (distanceFromOrigin > 30 && firstSolidBlock == -1) {
                            finalDestinationPointY = originPointY;
                        }
                    }
                    material = null;
                }
                SmoothingAreaBlock endPoint = new SmoothingAreaBlock();
                endPoint.x = smoothingBeginAndEndPoints.endPointX;
                endPoint.y = finalDestinationPointY;
                endPoint.z = smoothingBeginAndEndPoints.endPointZ;
                if (originPointX != finalDestinationPointX && originPointZ == finalDestinationPointZ) {
                    adjustedOriginPointY = 0.0;
                    if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal) {
                        originPointY2 = (double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX));
                        originPointY2 = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY - originPointY2 : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY + originPointY2 : (double)diagonalLineoriginPointY);
                        adjustedOriginPointY = Math.abs(originPointY2 - (double)finalDestinationPointY) * ((double)Math.abs(originPointX - diagonalLineOriginPointX) / (double)Math.abs(originPointX - finalDestinationPointX));
                        adjustedOriginPointY = originPointY2 > (double)finalDestinationPointY ? originPointY2 + adjustedOriginPointY : originPointY2 - adjustedOriginPointY;
                    }
                    for (int i5 = 0; i5 <= Math.abs(beginPoint.x - endPoint.x); ++i5) {
                        distanceFromStart = Math.abs(beginPoint.x - originPointX) + i5;
                        if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal && diagonalLineOriginPointX != originPointX) {
                            distanceFromStart = Math.abs(beginPoint.x - diagonalLineOriginPointX) + i5;
                            surfaceBlockHeight2 = Math.abs(adjustedOriginPointY - (double)finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(diagonalLineOriginPointX - finalDestinationPointX));
                            surfaceBlockHeight = adjustedOriginPointY > (double)finalDestinationPointY ? (short)Math.round(adjustedOriginPointY - surfaceBlockHeight2) : (short)Math.round(adjustedOriginPointY + surfaceBlockHeight2);
                        } else {
                            surfaceBlockHeight = (short)Math.round((double)Math.abs(originPointY - finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(originPointX - finalDestinationPointX)));
                            surfaceBlockHeight = originPointY > finalDestinationPointY ? (short)(originPointY - surfaceBlockHeight) : (short)(originPointY + surfaceBlockHeight);
                        }
                        filler = new SmoothingAreaBlock();
                        if (originPointX < finalDestinationPointX) {
                            filler.x = beginPoint.x + i5;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z;
                        }
                        if (originPointX > finalDestinationPointX) {
                            filler.x = beginPoint.x - i5;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z;
                        }
                        boolean abort = false;
                        for (SmoothingAreaLine smoothingBeginAndEndPoints2 : smoothingAreas) {
                            if (smoothingBeginAndEndPoints2 instanceof SmoothingAreaLineDiagonal) continue;
                            originPointX2 = smoothingBeginAndEndPoints2.originPointX;
                            originPointZ2 = smoothingBeginAndEndPoints2.originPointZ;
                            if (originPointX2 != filler.x || originPointZ2 != filler.z || originPointX == originPointX2 && originPointZ == originPointZ2 || !goingUp) continue;
                            abort = true;
                            break;
                        }
                        if (abort) break;
                        blocksToRemove = new ArrayList();
                        dontAdd = false;
                        for (SmoothingAreaLineBlock existingBlockItem : blocksToSpawn) {
                            existingBlock = existingBlockItem.block;
                            if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                            if (filler.y < existingBlock.y && goingUp && existingBlockItem.goingUp) {
                                blocksToRemove.add(existingBlockItem);
                            } else {
                                if (filler.y >= existingBlock.y && goingUp && existingBlockItem.goingUp) {
                                    dontAdd = true;
                                    break;
                                }
                                if (filler.y >= existingBlock.y || goingUp || !existingBlockItem.goingUp) {
                                    if (filler.y > existingBlock.y && !goingUp && existingBlockItem.goingUp) {
                                        blocksToRemove.add(existingBlockItem);
                                    } else if (filler.y != existingBlock.y || goingUp || existingBlockItem.goingUp) {
                                        // empty if block
                                    }
                                }
                            }
                            if (filler.y < existingBlock.y && goingUp && !existingBlockItem.goingUp) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y >= existingBlock.y && goingUp && !existingBlockItem.goingUp) continue;
                            if (filler.y < existingBlock.y && !goingUp && !existingBlockItem.goingUp) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y < existingBlock.y || goingUp || existingBlockItem.goingUp) continue;
                            blocksToRemove.add(existingBlockItem);
                        }
                        if (dontAdd) continue;
                        if (blocksToRemove.size() > 0) {
                            for (SmoothingAreaLineBlock blockToRemove : blocksToRemove) {
                                blocksToSpawn.remove(blockToRemove);
                            }
                        }
                        blocksToSpawn.add(new SmoothingAreaLineBlock(filler, goingUp, goingDown, s == 1));
                    }
                }
                if (originPointX == finalDestinationPointX && originPointZ != finalDestinationPointZ) {
                    adjustedOriginPointY = 0.0;
                    if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal) {
                        originPointY2 = (double)Math.abs(diagonalLineoriginPointY - diagonalLineFinalDestinationPointY) * ((double)Math.abs(diagonalLineOriginPointX - originPointX) / (double)Math.abs(diagonalLineOriginPointX - diagonalLineFinalDestinationPointX));
                        originPointY2 = diagonalLineoriginPointY > diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY - originPointY2 : (diagonalLineoriginPointY < diagonalLineFinalDestinationPointY ? (double)diagonalLineoriginPointY + originPointY2 : (double)diagonalLineoriginPointY);
                        adjustedOriginPointY = Math.abs(originPointY2 - (double)finalDestinationPointY) * ((double)Math.abs(originPointZ - diagonalLineOriginPointZ) / (double)Math.abs(originPointZ - finalDestinationPointZ));
                        adjustedOriginPointY = originPointY2 > (double)finalDestinationPointY ? originPointY2 + adjustedOriginPointY : originPointY2 - adjustedOriginPointY;
                    }
                    for (int i6 = 0; i6 <= Math.abs(beginPoint.z - endPoint.z); ++i6) {
                        distanceFromStart = Math.abs(beginPoint.z - originPointZ) + i6;
                        if (smoothingBeginAndEndPoints instanceof SmoothingAreaLineDiagonal && diagonalLineOriginPointZ != originPointZ) {
                            distanceFromStart = Math.abs(beginPoint.z - diagonalLineOriginPointZ) + i6;
                            surfaceBlockHeight2 = Math.abs(adjustedOriginPointY - (double)finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(diagonalLineOriginPointZ - finalDestinationPointZ));
                            surfaceBlockHeight = adjustedOriginPointY > (double)finalDestinationPointY ? (short)Math.round(adjustedOriginPointY - surfaceBlockHeight2) : (short)Math.round(adjustedOriginPointY + surfaceBlockHeight2);
                        } else {
                            surfaceBlockHeight = (short)Math.round((double)Math.abs(originPointY - finalDestinationPointY) * ((double)distanceFromStart / (double)Math.abs(originPointZ - finalDestinationPointZ)));
                            surfaceBlockHeight = originPointY > finalDestinationPointY ? (short)(originPointY - surfaceBlockHeight) : (short)(originPointY + surfaceBlockHeight);
                        }
                        filler = new SmoothingAreaBlock();
                        if (originPointZ < finalDestinationPointZ) {
                            filler.x = beginPoint.x;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z + i6;
                        }
                        if (originPointZ > finalDestinationPointZ) {
                            filler.x = beginPoint.x;
                            filler.y = surfaceBlockHeight;
                            filler.z = beginPoint.z - i6;
                        }
                        boolean abort = false;
                        for (SmoothingAreaLine smoothingBeginAndEndPoints2 : smoothingAreas) {
                            if (smoothingBeginAndEndPoints2 instanceof SmoothingAreaLineDiagonal) continue;
                            originPointX2 = smoothingBeginAndEndPoints2.originPointX;
                            originPointZ2 = smoothingBeginAndEndPoints2.originPointZ;
                            if (originPointX2 != filler.x || originPointZ2 != filler.z || originPointX == originPointX2 && originPointZ == originPointZ2 || !goingUp) continue;
                            abort = true;
                            break;
                        }
                        if (abort) break;
                        dontAdd = false;
                        blocksToRemove = new ArrayList();
                        for (SmoothingAreaLineBlock existingBlockItem : blocksToSpawn) {
                            existingBlock = existingBlockItem.block;
                            if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                            if (filler.y < existingBlock.y && goingUp && existingBlockItem.goingUp) {
                                blocksToRemove.add(existingBlockItem);
                            } else {
                                if (filler.y >= existingBlock.y && goingUp && existingBlockItem.goingUp) {
                                    dontAdd = true;
                                    break;
                                }
                                if (filler.y >= existingBlock.y || goingUp || !existingBlockItem.goingUp) {
                                    if (filler.y > existingBlock.y && !goingUp && existingBlockItem.goingUp) {
                                        blocksToRemove.add(existingBlockItem);
                                    } else if (filler.y != existingBlock.y || goingUp || existingBlockItem.goingUp) {
                                        // empty if block
                                    }
                                }
                            }
                            if (filler.y < existingBlock.y && goingUp && !existingBlockItem.goingUp) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y >= existingBlock.y && goingUp && !existingBlockItem.goingUp) continue;
                            if (filler.y < existingBlock.y && !goingUp && !existingBlockItem.goingUp) {
                                dontAdd = true;
                                break;
                            }
                            if (filler.y < existingBlock.y || goingUp || existingBlockItem.goingUp) continue;
                            blocksToRemove.add(existingBlockItem);
                        }
                        if (dontAdd) continue;
                        if (blocksToRemove.size() > 0) {
                            for (SmoothingAreaLineBlock blockToRemove : blocksToRemove) {
                                blocksToSpawn.remove(blockToRemove);
                            }
                        }
                        blocksToSpawn.add(new SmoothingAreaLineBlock(filler, goingUp, goingDown, s == 1));
                    }
                }
                if (originPointX != finalDestinationPointX || originPointZ != finalDestinationPointZ) continue;
                filler = new SmoothingAreaBlock();
                filler.x = finalDestinationPointX;
                filler.y = finalDestinationPointY;
                filler.z = finalDestinationPointZ;
                if (!goingUp && !goingDown) {
                    goingDown = true;
                }
                boolean abort = false;
                for (SmoothingAreaLine smoothingBeginAndEndPoints2 : smoothingAreas) {
                    if (smoothingBeginAndEndPoints2 instanceof SmoothingAreaLineDiagonal) continue;
                    int originPointX22 = smoothingBeginAndEndPoints2.originPointX;
                    int originPointZ22 = smoothingBeginAndEndPoints2.originPointZ;
                    if (originPointX22 != filler.x || originPointZ22 != filler.z || originPointX == originPointX22 && originPointZ == originPointZ22 || !goingUp) continue;
                    abort = true;
                    break;
                }
                if (abort) continue block5;
                dontAdd = false;
                blocksToRemove = new ArrayList<SmoothingAreaLineBlock>();
                for (SmoothingAreaLineBlock existingBlockItem : blocksToSpawn) {
                    existingBlock = existingBlockItem.block;
                    if (existingBlock.x != filler.x || existingBlock.z != filler.z) continue;
                    if (filler.y < existingBlock.y && goingUp && existingBlockItem.goingUp) {
                        blocksToRemove.add(existingBlockItem);
                    } else {
                        if (filler.y >= existingBlock.y && goingUp && existingBlockItem.goingUp) {
                            dontAdd = true;
                            break;
                        }
                        if (filler.y >= existingBlock.y || goingUp || !existingBlockItem.goingUp) {
                            if (filler.y > existingBlock.y && !goingUp && existingBlockItem.goingUp) {
                                blocksToRemove.add(existingBlockItem);
                            } else if (filler.y != existingBlock.y || goingUp || existingBlockItem.goingUp) {
                                // empty if block
                            }
                        }
                    }
                    if (filler.y < existingBlock.y && goingUp && !existingBlockItem.goingUp) {
                        dontAdd = true;
                        break;
                    }
                    if (filler.y >= existingBlock.y && goingUp && !existingBlockItem.goingUp) continue;
                    if (filler.y < existingBlock.y && !goingUp && !existingBlockItem.goingUp) {
                        dontAdd = true;
                        break;
                    }
                    if (filler.y < existingBlock.y || goingUp || existingBlockItem.goingUp) continue;
                    blocksToRemove.add(existingBlockItem);
                }
                if (dontAdd) continue;
                if (blocksToRemove.size() > 0) {
                    for (SmoothingAreaLineBlock blockToRemove : blocksToRemove) {
                        blocksToSpawn.remove(blockToRemove);
                    }
                }
                blocksToSpawn.add(new SmoothingAreaLineBlock(filler, goingUp, goingDown, s == 1));
            }
        }
        return blocksToSpawn;
    }

    private class SmoothingAreaLineBlock {
        SmoothingAreaBlock block;
        boolean goingUp;
        boolean goingDown;
        boolean isPass2;

        public SmoothingAreaLineBlock(SmoothingAreaBlock block, boolean goingUp, boolean goingDown, boolean isPass2) {
            this.block = block;
            this.goingUp = goingUp;
            this.goingDown = goingDown;
            this.isPass2 = isPass2;
        }
    }

    private class BlockCoordsAndNeighboursDiagonal
    extends BlockCoordsAndNeighbours {
        public int originPointX;
        public short originPointY;
        public int originPointZ;
        public int finalDestinationPointX;
        public short finalDestinationPointY;
        public int finalDestinationPointZ;

        public BlockCoordsAndNeighboursDiagonal(BO4CustomStructureCoordinate bO3, int blockX, short blockY, int blockZ, boolean smoothInDirection1, boolean smoothInDirection2, boolean smoothInDirection3, boolean smoothInDirection4, int smoothRadius, int originPointX, short originPointY, int originPointZ, int finalDestinationPointX, short finalDestinationPointY, int finalDestinationPointZ) {
            super(bO3, blockX, blockY, blockZ, smoothInDirection1, smoothInDirection2, smoothInDirection3, smoothInDirection4, smoothRadius, 0);
            this.originPointX = originPointX;
            this.originPointY = originPointY;
            this.originPointZ = originPointZ;
            this.finalDestinationPointX = finalDestinationPointX;
            this.finalDestinationPointY = finalDestinationPointY;
            this.finalDestinationPointZ = finalDestinationPointZ;
        }
    }

    private class BlockCoordsAndNeighbours {
        public BO4CustomStructureCoordinate bO3;
        public int blockX;
        public short blockY;
        public int blockZ;
        public boolean smoothInDirection1;
        public boolean smoothInDirection2;
        public boolean smoothInDirection3;
        public boolean smoothInDirection4;
        public int smoothRadius;
        public int smoothRadiusDiagonal;

        public BlockCoordsAndNeighbours(BO4CustomStructureCoordinate bO3, int blockX, short blockY, int blockZ, boolean smoothInDirection1, boolean smoothInDirection2, boolean smoothInDirection3, boolean smoothInDirection4, int smoothRadius) {
            this(bO3, blockX, blockY, blockZ, smoothInDirection1, smoothInDirection2, smoothInDirection3, smoothInDirection4, smoothRadius, 0);
        }

        public BlockCoordsAndNeighbours(BO4CustomStructureCoordinate bO3, int blockX, short blockY, int blockZ, boolean smoothInDirection1, boolean smoothInDirection2, boolean smoothInDirection3, boolean smoothInDirection4, int smoothRadius, int smoothRadiusDiagonal) {
            this.bO3 = bO3;
            this.blockX = blockX;
            this.blockY = blockY;
            this.blockZ = blockZ;
            this.smoothInDirection1 = smoothInDirection1;
            this.smoothInDirection2 = smoothInDirection2;
            this.smoothInDirection3 = smoothInDirection3;
            this.smoothInDirection4 = smoothInDirection4;
            this.smoothRadius = smoothRadius;
            this.smoothRadiusDiagonal = smoothRadiusDiagonal;
        }
    }

    private class SmoothingAreaBlock {
        public LocalMaterialData material;
        public int x;
        public short y;
        public int z;
    }
}

