/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureFileManager;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class CustomStructurePlotter {
    private boolean processing = false;
    private HashMap<ChunkCoordinate, ArrayList<String>> structuresPerChunk = new HashMap();
    private HashMap<String, ArrayList<ChunkCoordinate>> spawnedStructuresByName = new HashMap();
    private HashMap<String, HashMap<ChunkCoordinate, Integer>> spawnedStructuresByGroup = new HashMap();

    public int getStructureCount() {
        return this.spawnedStructuresByName.entrySet().size();
    }

    public void saveSpawnedStructures(LocalWorld world) {
        CustomStructureFileManager.saveChunksMapFile(WorldStandardValues.SpawnedStructuresFileName, world, this.spawnedStructuresByName, this.spawnedStructuresByGroup);
    }

    public void loadSpawnedStructures(LocalWorld world) {
        CustomStructureFileManager.loadChunksMapFile(WorldStandardValues.SpawnedStructuresFileName, world, this.spawnedStructuresByName, this.spawnedStructuresByGroup);
    }

    public void addToStructuresPerChunkCache(ChunkCoordinate chunkCoord, ArrayList<String> BO3Names) {
        this.structuresPerChunk.put(chunkCoord, BO3Names);
    }

    public void plotStructures(LocalWorld world, Random rand, ChunkCoordinate chunkCoord, boolean spawningStructureAtSpawn, Map<ChunkCoordinate, BO4CustomStructure> structureCache, Map<ChunkCoordinate, CustomStructure> worldInfoChunks) {
        if (!this.processing) {
            this.processing = true;
            if (!world.isInsidePregeneratedRegion(chunkCoord) && !structureCache.containsKey(chunkCoord)) {
                LocalBiome biome = world.getBiome(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 7);
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                ArrayList<CustomStructureGen> customStructureGens = new ArrayList<CustomStructureGen>();
                if (!world.chunkHasDefaultStructure(rand, chunkCoord)) {
                    for (CustomStructureGen res : biomeConfig.getCustomStructures()) {
                        customStructureGens.add(res);
                    }
                }
                if (customStructureGens.size() > 0) {
                    Random random = new Random();
                    HashMap<StructuredCustomObject, Double> structuredCustomObjects = new HashMap<StructuredCustomObject, Double>();
                    for (CustomStructureGen structureGen : customStructureGens) {
                        int i = 0;
                        for (StructuredCustomObject structure : structureGen.getObjects(world.getName())) {
                            if (structure == null) continue;
                            if (structure instanceof BO4) {
                                structuredCustomObjects.put(structure, structureGen.objectChances.get(i));
                                ++i;
                                continue;
                            }
                            if (!OTG.getPluginConfig().spawnLog) continue;
                            OTG.log(LogMarker.WARN, "CustomStructure " + structure.getName() + " in biome " + biome.getName() + " has IsOTGPlus:false, ignoring.", new Object[0]);
                        }
                    }
                    if (structuredCustomObjects.size() > 0) {
                        double BO3size;
                        Object[] topLeftAndLowerRightChunkCoordinates = null;
                        BO4CustomStructureCoordinate structureCoord = null;
                        BO4CustomStructure structureStart2 = null;
                        ArrayList<Object[]> BO3sBySize = new ArrayList<Object[]>();
                        ArrayList<String> structuresToSpawn1 = new ArrayList<String>();
                        if (spawningStructureAtSpawn) {
                            for (Map.Entry bo3AndRarity : structuredCustomObjects.entrySet()) {
                                if (((BO4)bo3AndRarity.getKey()).isInvalidConfig || !((BO4)bo3AndRarity.getKey()).getSettings().isSpawnPoint) continue;
                                structuresToSpawn1.add(((StructuredCustomObject)bo3AndRarity.getKey()).getName());
                                structureCoord = new BO4CustomStructureCoordinate(world, (StructuredCustomObject)bo3AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), 0, false, false, null);
                                structureStart2 = new BO4CustomStructure(world, structureCoord, false, false);
                                try {
                                    topLeftAndLowerRightChunkCoordinates = structureStart2.getMinimumSize(world);
                                    BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                                    BO3sBySize.add(new Object[]{bo3AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo3AndRarity.getValue()});
                                }
                                catch (InvalidConfigException e) {
                                    ((BO4)bo3AndRarity.getKey()).isInvalidConfig = true;
                                }
                            }
                        }
                        if (!spawningStructureAtSpawn || BO3sBySize.size() == 0) {
                            for (Map.Entry bo3AndRarity : structuredCustomObjects.entrySet()) {
                                if (((BO4)bo3AndRarity.getKey()).isInvalidConfig || (int)Math.round((Double)bo3AndRarity.getValue()) <= 0 || !this.isBO3AllowedToSpawnAt(chunkCoord, (BO4)bo3AndRarity.getKey())) continue;
                                structuresToSpawn1.add(((StructuredCustomObject)bo3AndRarity.getKey()).getName());
                                structureCoord = new BO4CustomStructureCoordinate(world, (StructuredCustomObject)bo3AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), 0, false, false, null);
                                structureStart2 = new BO4CustomStructure(world, structureCoord, false, false);
                                try {
                                    topLeftAndLowerRightChunkCoordinates = structureStart2.getMinimumSize(world);
                                    BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                                    int insertAtIndex = BO3sBySize.size();
                                    int i = 0;
                                    for (Object[] entry : BO3sBySize) {
                                        if (((BO4)bo3AndRarity.getKey()).getSettings().timesSpawned < ((BO4)entry[0]).getSettings().timesSpawned || BO3size > (Double)entry[2] && ((BO4)bo3AndRarity.getKey()).getSettings().timesSpawned == ((BO4)entry[0]).getSettings().timesSpawned) {
                                            insertAtIndex = i;
                                            break;
                                        }
                                        ++i;
                                    }
                                    BO3sBySize.add(insertAtIndex, new Object[]{bo3AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo3AndRarity.getValue()});
                                }
                                catch (InvalidConfigException e) {
                                    ((BO4)bo3AndRarity.getKey()).isInvalidConfig = true;
                                }
                            }
                        }
                        if (BO3sBySize.size() > 0) {
                            int pass = 1;
                            Object[] currentStructureSpawning = BO3sBySize.size() > 0 ? (spawningStructureAtSpawn ? (Object[])BO3sBySize.get(random.nextInt(BO3sBySize.size())) : (Object[])BO3sBySize.get(0)) : null;
                            int left = 0;
                            int right = 0;
                            int top = 0;
                            int bottom = 0;
                            int areaSizeX = 0;
                            int areaSizeZ = 0;
                            int structureSizeX = 0;
                            int structureSizeZ = 0;
                            int maxPass = 4;
                            while (pass <= maxPass && currentStructureSpawning != null) {
                                int i;
                                boolean bFound;
                                boolean spawned = false;
                                topLeftAndLowerRightChunkCoordinates = (Object[])currentStructureSpawning[1];
                                structureSizeX = (Integer)topLeftAndLowerRightChunkCoordinates[1] + (Integer)topLeftAndLowerRightChunkCoordinates[3] + 1;
                                structureSizeZ = (Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2] + 1;
                                if ((int)Math.round((Double)currentStructureSpawning[3]) > 0 || spawningStructureAtSpawn && ((BO4)currentStructureSpawning[0]).getSettings().isSpawnPoint) {
                                    left = 0;
                                    right = 0;
                                    top = 0;
                                    bottom = 0;
                                    boolean leftEdgeFound = false;
                                    boolean rightEdgeFound = false;
                                    boolean topEdgeFound = false;
                                    boolean bottomEdgeFound = false;
                                    if (pass == 1) {
                                        topEdgeFound = true;
                                        rightEdgeFound = true;
                                    }
                                    if (pass == 2) {
                                        topEdgeFound = true;
                                        leftEdgeFound = true;
                                    }
                                    if (pass == 3) {
                                        bottomEdgeFound = true;
                                        rightEdgeFound = true;
                                    }
                                    if (pass == 4) {
                                        bottomEdgeFound = true;
                                        leftEdgeFound = true;
                                    }
                                    boolean passHandled = false;
                                    int j = 0;
                                    if (!spawningStructureAtSpawn) {
                                        while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                                            ArrayList<String> structuresToSpawn;
                                            BiomeConfig biomeConfig3;
                                            LocalBiome biome3;
                                            ArrayList<String> biomeStructures;
                                            boolean canSpawnHere;
                                            int i2;
                                            ++j;
                                            if (right >= structureSizeX - 1 || left >= structureSizeX - 1 || right + left + 1 >= structureSizeX) {
                                                rightEdgeFound = true;
                                            }
                                            if (!rightEdgeFound) {
                                                for (i2 = -top; i2 <= bottom; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!world.isInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i2))) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i2));
                                                        if (biomeStructures == null) {
                                                            if (!world.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                                biome3 = world.getBiome((chunkCoord.getChunkX() + j) * 16 + 8, (chunkCoord.getChunkZ() + i2) * 16 + 7);
                                                                if (!biome3.getName().equals(biome.getName())) {
                                                                    biomeConfig3 = biome3.getBiomeConfig();
                                                                    structuresToSpawn = new ArrayList<String>();
                                                                    for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                                                                        for (String bo3Name : res.objectNames) {
                                                                            structuresToSpawn.add(bo3Name);
                                                                        }
                                                                    }
                                                                    biomeStructures = structuresToSpawn;
                                                                } else {
                                                                    canSpawnHere = true;
                                                                    biomeStructures = structuresToSpawn1;
                                                                }
                                                            } else {
                                                                biomeStructures = new ArrayList();
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i2), biomeStructures);
                                                        }
                                                        for (String structureToSpawn : biomeStructures) {
                                                            if (!structureToSpawn.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i2));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    rightEdgeFound = true;
                                                }
                                                if (!rightEdgeFound) {
                                                    ++right;
                                                }
                                            }
                                            if (right >= structureSizeX - 1 || left >= structureSizeX - 1 || right + left + 1 >= structureSizeX) {
                                                leftEdgeFound = true;
                                            }
                                            if (!leftEdgeFound) {
                                                for (i2 = -top; i2 <= bottom; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!world.isInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2))) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2));
                                                        if (biomeStructures == null) {
                                                            if (!world.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                                biome3 = world.getBiome((chunkCoord.getChunkX() - j) * 16 + 8, (chunkCoord.getChunkZ() + i2) * 16 + 7);
                                                                if (!biome3.getName().equals(biome.getName())) {
                                                                    biomeConfig3 = biome3.getBiomeConfig();
                                                                    structuresToSpawn = new ArrayList();
                                                                    for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                                                                        for (String bo3Name : res.objectNames) {
                                                                            structuresToSpawn.add(bo3Name);
                                                                        }
                                                                    }
                                                                    biomeStructures = structuresToSpawn;
                                                                } else {
                                                                    canSpawnHere = true;
                                                                    biomeStructures = structuresToSpawn1;
                                                                }
                                                            } else {
                                                                biomeStructures = new ArrayList();
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2), biomeStructures);
                                                        }
                                                        for (String structureToSpawn : biomeStructures) {
                                                            if (!structureToSpawn.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    leftEdgeFound = true;
                                                }
                                                if (!leftEdgeFound) {
                                                    ++left;
                                                }
                                            }
                                            if (bottom >= structureSizeZ - 1 || top >= structureSizeZ - 1 || bottom + top + 1 >= structureSizeZ) {
                                                bottomEdgeFound = true;
                                            }
                                            if (!bottomEdgeFound) {
                                                for (i2 = -left; i2 <= right; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!world.isInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j))) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j));
                                                        if (biomeStructures == null) {
                                                            if (!world.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                                biome3 = world.getBiome((chunkCoord.getChunkX() + i2) * 16 + 8, (chunkCoord.getChunkZ() + j) * 16 + 7);
                                                                if (!biome3.getName().equals(biome.getName())) {
                                                                    biomeConfig3 = biome3.getBiomeConfig();
                                                                    structuresToSpawn = new ArrayList();
                                                                    for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                                                                        for (String bo3Name : res.objectNames) {
                                                                            structuresToSpawn.add(bo3Name);
                                                                        }
                                                                    }
                                                                    biomeStructures = structuresToSpawn;
                                                                } else {
                                                                    canSpawnHere = true;
                                                                    biomeStructures = structuresToSpawn1;
                                                                }
                                                            } else {
                                                                biomeStructures = new ArrayList();
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j), biomeStructures);
                                                        }
                                                        for (String structureToSpawn : biomeStructures) {
                                                            if (!structureToSpawn.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    bottomEdgeFound = true;
                                                }
                                                if (!bottomEdgeFound) {
                                                    ++bottom;
                                                }
                                            }
                                            if (top >= structureSizeZ - 1 || bottom >= structureSizeZ - 1 || bottom + top >= structureSizeZ + 1) {
                                                topEdgeFound = true;
                                            }
                                            if (!topEdgeFound) {
                                                for (i2 = -left; i2 <= right; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!world.isInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j))) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j));
                                                        if (biomeStructures == null) {
                                                            if (!world.chunkHasDefaultStructure(rand, chunkCoord)) {
                                                                biome3 = world.getBiome((chunkCoord.getChunkX() + i2) * 16 + 8, (chunkCoord.getChunkZ() - j) * 16 + 7);
                                                                if (!biome3.getName().equals(biome.getName())) {
                                                                    biomeConfig3 = biome3.getBiomeConfig();
                                                                    structuresToSpawn = new ArrayList();
                                                                    for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                                                                        for (String bo3Name : res.objectNames) {
                                                                            structuresToSpawn.add(bo3Name);
                                                                        }
                                                                    }
                                                                    biomeStructures = structuresToSpawn;
                                                                } else {
                                                                    canSpawnHere = true;
                                                                    biomeStructures = structuresToSpawn1;
                                                                }
                                                            } else {
                                                                biomeStructures = new ArrayList();
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j), biomeStructures);
                                                        }
                                                        for (String structureToSpawn : biomeStructures) {
                                                            if (!structureToSpawn.equals(((BO4)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    topEdgeFound = true;
                                                }
                                                if (!topEdgeFound) {
                                                    ++top;
                                                }
                                            }
                                            if (passHandled) continue;
                                            if (pass == 1 && bottomEdgeFound && leftEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                topEdgeFound = false;
                                                rightEdgeFound = false;
                                            }
                                            if (pass == 2 && bottomEdgeFound && rightEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                topEdgeFound = false;
                                                leftEdgeFound = false;
                                            }
                                            if (pass == 3 && topEdgeFound && leftEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                bottomEdgeFound = false;
                                                rightEdgeFound = false;
                                            }
                                            if (pass != 4 || !topEdgeFound || !rightEdgeFound) continue;
                                            passHandled = true;
                                            j = 0;
                                            bottomEdgeFound = false;
                                            leftEdgeFound = false;
                                        }
                                    } else {
                                        left = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates[3] + (Integer)topLeftAndLowerRightChunkCoordinates[1]) / 2.0);
                                        right = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates[3] + (Integer)topLeftAndLowerRightChunkCoordinates[1]) / 2.0);
                                        top = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2]) / 2.0);
                                        bottom = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2]) / 2.0);
                                        if (world.getWorldSession().getWorldBorderRadius() > 0 && (world.getWorldSession().getWorldBorderRadius() < left || world.getWorldSession().getWorldBorderRadius() < right || world.getWorldSession().getWorldBorderRadius() < top || world.getWorldSession().getWorldBorderRadius() < bottom)) {
                                            left = 0;
                                            right = 0;
                                            top = 0;
                                            bottom = 0;
                                        }
                                    }
                                    areaSizeX = left + right + 1;
                                    areaSizeZ = top + bottom + 1;
                                    if (structureSizeX <= areaSizeX && structureSizeZ <= areaSizeZ) {
                                        int spawnCoordX = 0;
                                        int spawnCoordZ = 0;
                                        if (pass == 1) {
                                            spawnCoordX = chunkCoord.getChunkX() - (left > 0 && left - (Integer)topLeftAndLowerRightChunkCoordinates[3] > (Integer)topLeftAndLowerRightChunkCoordinates[1] ? structureSizeX - 1 : left) + (Integer)topLeftAndLowerRightChunkCoordinates[3];
                                            spawnCoordZ = chunkCoord.getChunkZ() + (bottom > 0 && bottom - (Integer)topLeftAndLowerRightChunkCoordinates[2] > (Integer)topLeftAndLowerRightChunkCoordinates[0] ? structureSizeZ - 1 : bottom) - (Integer)topLeftAndLowerRightChunkCoordinates[2];
                                        }
                                        if (pass == 2) {
                                            spawnCoordX = chunkCoord.getChunkX() + (right > 0 && right - (Integer)topLeftAndLowerRightChunkCoordinates[1] > (Integer)topLeftAndLowerRightChunkCoordinates[3] ? structureSizeX - 1 : right) - (Integer)topLeftAndLowerRightChunkCoordinates[1];
                                            spawnCoordZ = chunkCoord.getChunkZ() + (bottom > 0 && bottom - (Integer)topLeftAndLowerRightChunkCoordinates[2] > (Integer)topLeftAndLowerRightChunkCoordinates[0] ? structureSizeZ - 1 : bottom) - (Integer)topLeftAndLowerRightChunkCoordinates[2];
                                        }
                                        if (pass == 3) {
                                            spawnCoordX = chunkCoord.getChunkX() - (left > 0 && left - (Integer)topLeftAndLowerRightChunkCoordinates[3] > (Integer)topLeftAndLowerRightChunkCoordinates[1] ? structureSizeX - 1 : left) + (Integer)topLeftAndLowerRightChunkCoordinates[3];
                                            spawnCoordZ = chunkCoord.getChunkZ() - (top > 0 && top - (Integer)topLeftAndLowerRightChunkCoordinates[0] > (Integer)topLeftAndLowerRightChunkCoordinates[2] ? structureSizeZ - 1 : top) + (Integer)topLeftAndLowerRightChunkCoordinates[0];
                                        }
                                        if (pass == 4) {
                                            spawnCoordX = chunkCoord.getChunkX() + (right > 0 && right - (Integer)topLeftAndLowerRightChunkCoordinates[1] > (Integer)topLeftAndLowerRightChunkCoordinates[3] ? structureSizeX - 1 : right) - (Integer)topLeftAndLowerRightChunkCoordinates[1];
                                            spawnCoordZ = chunkCoord.getChunkZ() - (top > 0 && top - (Integer)topLeftAndLowerRightChunkCoordinates[0] > (Integer)topLeftAndLowerRightChunkCoordinates[2] ? structureSizeZ - 1 : top) + (Integer)topLeftAndLowerRightChunkCoordinates[0];
                                        }
                                        if (this.isBO3AllowedToSpawnAt(ChunkCoordinate.fromChunkCoords((int)Math.round((double)spawnCoordX - (double)((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[1]).intValue() / 2.0), (int)Math.round((double)spawnCoordZ - (double)((Integer)topLeftAndLowerRightChunkCoordinates[0]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue() / 2.0)), (BO4)currentStructureSpawning[0])) {
                                            structureCoord = new BO4CustomStructureCoordinate(world, (BO4)currentStructureSpawning[0], null, Rotation.NORTH, spawnCoordX * 16, 0, spawnCoordZ * 16, 0, false, false, null);
                                            structureStart2 = new BO4CustomStructure(world, structureCoord, true, spawningStructureAtSpawn);
                                            if (structureStart2.IsSpawned) {
                                                structureCache.put(chunkCoord, structureStart2);
                                                this.structuresPerChunk.put(chunkCoord, new ArrayList());
                                                worldInfoChunks.put(chunkCoord, structureStart2);
                                                ++((BO4)structureCoord.getObject()).getSettings().timesSpawned;
                                                if (OTG.getPluginConfig().spawnLog) {
                                                    OTG.log(LogMarker.INFO, "Plotted structure " + structureCoord.getObject().getName() + " at chunk X" + spawnCoordX + " Z" + spawnCoordZ + " (" + spawnCoordX * 16 + " 100 " + spawnCoordZ * 16 + ")", new Object[0]);
                                                }
                                                if (((BO4)currentStructureSpawning[0]).getSettings().frequency > 0 || ((BO4)currentStructureSpawning[0]).getSettings().bo3Groups.size() > 0) {
                                                    String bO3Name = ((BO4)currentStructureSpawning[0]).getName();
                                                    ArrayList<ChunkCoordinate> chunkCoords = this.spawnedStructuresByName.get(bO3Name);
                                                    if (chunkCoords != null) {
                                                        chunkCoords.add(ChunkCoordinate.fromChunkCoords(spawnCoordX, spawnCoordZ));
                                                    } else {
                                                        ArrayList<ChunkCoordinate> centerChunk = new ArrayList<ChunkCoordinate>();
                                                        centerChunk.add(ChunkCoordinate.fromChunkCoords((int)Math.round((double)spawnCoordX - (double)((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[1]).intValue() / 2.0), (int)Math.round((double)spawnCoordZ - (double)((Integer)topLeftAndLowerRightChunkCoordinates[0]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue() / 2.0)));
                                                        this.spawnedStructuresByName.put(bO3Name, centerChunk);
                                                        if (((BO4)currentStructureSpawning[0]).getSettings().bo3Groups.size() > 0) {
                                                            for (Map.Entry<String, Integer> entry : ((BO4)currentStructureSpawning[0]).getSettings().bo3Groups.entrySet()) {
                                                                String bo3GroupName = entry.getKey();
                                                                int bo3GroupFrequency = entry.getValue();
                                                                if (bo3GroupFrequency <= 0) continue;
                                                                HashMap<ChunkCoordinate, Integer> spawnedStructures = this.spawnedStructuresByGroup.get(bo3GroupName);
                                                                if (spawnedStructures == null) {
                                                                    spawnedStructures = new HashMap();
                                                                    spawnedStructures.put((ChunkCoordinate)centerChunk.get(0), entry.getValue());
                                                                    this.spawnedStructuresByGroup.put(bo3GroupName, spawnedStructures);
                                                                    continue;
                                                                }
                                                                Integer frequency = spawnedStructures.get(centerChunk.get(0));
                                                                if (frequency != null) {
                                                                    if (frequency >= bo3GroupFrequency) continue;
                                                                    spawnedStructures.put((ChunkCoordinate)centerChunk.get(0), (int)entry.getValue());
                                                                    continue;
                                                                }
                                                                spawnedStructures.put((ChunkCoordinate)centerChunk.get(0), (int)entry.getValue());
                                                            }
                                                        }
                                                    }
                                                }
                                                spawned = true;
                                                random = new Random();
                                            }
                                            if (spawned) {
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    pass = maxPass;
                                }
                                if (!spawned) {
                                    if (++pass <= maxPass) continue;
                                    if (BO3sBySize.size() == 1) {
                                        structureCache.put(chunkCoord, new BO4CustomStructure(world, null, false, false));
                                        continue;
                                    }
                                    bFound = false;
                                    i = 0;
                                    for (Object[] nextStructure : BO3sBySize) {
                                        if (bFound) {
                                            BO3sBySize.remove(currentStructureSpawning);
                                            currentStructureSpawning = nextStructure;
                                            break;
                                        }
                                        if (nextStructure == currentStructureSpawning) {
                                            if (i == BO3sBySize.size() - 1) {
                                                BO3sBySize.remove(currentStructureSpawning);
                                                currentStructureSpawning = (Object[])BO3sBySize.get(0);
                                                break;
                                            }
                                            bFound = true;
                                        }
                                        ++i;
                                    }
                                    pass = 1;
                                    continue;
                                }
                                bFound = false;
                                i = 0;
                                for (Object[] nextStructure : BO3sBySize) {
                                    if (bFound) {
                                        currentStructureSpawning = nextStructure;
                                        break;
                                    }
                                    if (nextStructure == currentStructureSpawning) {
                                        if (i == BO3sBySize.size() - 1) {
                                            currentStructureSpawning = (Object[])BO3sBySize.get(0);
                                            break;
                                        }
                                        bFound = true;
                                    }
                                    ++i;
                                }
                                pass = 1;
                            }
                        } else {
                            structureCache.put(chunkCoord, new BO4CustomStructure(world, null, false, false));
                        }
                    } else {
                        structureCache.put(chunkCoord, new BO4CustomStructure(world, null, false, false));
                    }
                } else {
                    structureCache.put(chunkCoord, new BO4CustomStructure(world, null, false, false));
                }
            }
        } else {
            OTG.log(LogMarker.FATAL, "Illegal double spawn detected, aborting...", new Object[0]);
            throw new RuntimeException("Illegal double spawn detected, aborting...");
        }
        this.processing = false;
        this.structuresPerChunk.put(chunkCoord, new ArrayList());
    }

    private boolean isBO3AllowedToSpawnAt(ChunkCoordinate chunkCoord, BO4 BO3ToSpawn) {
        float distanceBetweenStructures;
        int radius = BO3ToSpawn.getSettings().frequency;
        String bO3Name = BO3ToSpawn.getName();
        if (radius > 0) {
            distanceBetweenStructures = 0.0f;
            ArrayList<ChunkCoordinate> chunkCoords = this.spawnedStructuresByName.get(bO3Name);
            if (chunkCoords != null) {
                for (ChunkCoordinate cachedChunk : chunkCoords) {
                    distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenStructures <= (float)radius)) continue;
                    return false;
                }
            }
        }
        if (BO3ToSpawn.getSettings().bo3Groups.size() > 0) {
            distanceBetweenStructures = 0.0f;
            int cachedChunkRadius = 0;
            ChunkCoordinate cachedChunk = null;
            for (Map.Entry<String, Integer> entry : BO3ToSpawn.getSettings().bo3Groups.entrySet()) {
                HashMap<ChunkCoordinate, Integer> spawnedStructure = this.spawnedStructuresByGroup.get(entry.getKey());
                if (spawnedStructure == null) continue;
                for (Map.Entry<ChunkCoordinate, Integer> cachedChunkEntry : spawnedStructure.entrySet()) {
                    cachedChunk = cachedChunkEntry.getKey();
                    cachedChunkRadius = cachedChunkEntry.getValue();
                    int n = radius = entry.getValue() >= cachedChunkRadius ? entry.getValue() : cachedChunkRadius;
                    distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenStructures <= (float)radius)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

