/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.structures.Branch;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.Random;
import java.util.Stack;

class BranchDataItem {
    private static int BranchDataItemCounter = -1;
    BO4CustomStructureCoordinate branch;
    ChunkCoordinate chunkCoordinate;
    BranchDataItem parent;
    boolean doneSpawning = false;
    boolean spawnDelayed = false;
    boolean cannotSpawn = false;
    boolean wasDeleted = false;
    boolean isBeingRolledBack = false;
    int branchNumber = -1;
    int currentDepth = 0;
    int maxDepth = 0;
    private boolean minimumSize = false;
    private Random random;
    private Stack<BranchDataItem> children = new Stack();
    private String startBO3Name;

    BranchDataItem(Random random, BranchDataItem parent, BO4CustomStructureCoordinate branch, String startBO3Name, int currentDepth, int maxDepth, boolean minimumSize) {
        this.random = random;
        this.parent = parent;
        this.branch = branch;
        this.startBO3Name = startBO3Name;
        this.currentDepth = currentDepth;
        this.maxDepth = maxDepth;
        this.minimumSize = minimumSize;
        this.chunkCoordinate = ChunkCoordinate.fromBlockCoords(this.branch.getX(), this.branch.getZ());
        this.branchNumber = ++BranchDataItemCounter;
    }

    Stack<BranchDataItem> getChildren(boolean dontSpawn, LocalWorld world) {
        if (world == null) {
            throw new RuntimeException();
        }
        if (!dontSpawn && this.children.size() == 0) {
            Branch[] branches;
            for (Branch branch1 : branches = this.branch.getStructuredObject().getBranches()) {
                BO4 childBO3;
                BO4CustomStructureCoordinate childCoordObject = (BO4CustomStructureCoordinate)branch1.toCustomObjectCoordinate(world, this.random, this.branch.getRotation(), this.branch.getX(), this.branch.getY(), this.branch.getZ(), this.startBO3Name != null ? this.startBO3Name : this.branch.bo3Name);
                if (childCoordObject == null || (childBO3 = (BO4)childCoordObject.getObject()) == null) continue;
                if (childCoordObject.branchGroup != null && childCoordObject.branchGroup.trim().length() > 0 && childBO3.getSettings().canOverride && !childCoordObject.isRequiredBranch) {
                    if (!OTG.getPluginConfig().spawnLog) continue;
                    OTG.log(LogMarker.WARN, "canOverride optional branches cannot be in a branch group, ignoring branch: " + childBO3.getName() + " in BO3: " + this.branch.bo3Name, new Object[0]);
                    continue;
                }
                if (childBO3.getSettings().overrideParentHeight) {
                    if (childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock || childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock || childBO3.getSettings().spawnAtWaterLevel) {
                        childCoordObject.y = (short)world.getHighestBlockYAt(childCoordObject.getX(), childCoordObject.getZ(), true, childBO3.getSettings().spawnHeight != BO3Settings.SpawnHeightEnum.highestSolidBlock || childBO3.getSettings().spawnAtWaterLevel, childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock && !childBO3.getSettings().spawnAtWaterLevel, true);
                    } else if (childBO3.getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                        childCoordObject.y = (short)RandomHelper.numberInRange(this.random, childBO3.getSettings().minHeight, childBO3.getSettings().maxHeight);
                    }
                }
                childCoordObject.y = (short)(childCoordObject.y + childBO3.getSettings().heightOffset);
                int currentDepth1 = childCoordObject.isRequiredBranch ? this.currentDepth : this.currentDepth + 1;
                int maxDepth1 = this.maxDepth;
                if (childCoordObject.branchDepth > 0 && !this.minimumSize) {
                    currentDepth1 = 0;
                    maxDepth1 = childCoordObject.branchDepth;
                }
                if (this.minimumSize) {
                    maxDepth1 = 0;
                }
                if ((maxDepth1 <= 0 || currentDepth1 > maxDepth1) && !childCoordObject.isRequiredBranch) continue;
                this.children.add(new BranchDataItem(this.random, this, childCoordObject, this.startBO3Name != null ? this.startBO3Name : this.branch.bo3Name, currentDepth1, maxDepth1, this.minimumSize));
            }
        }
        return this.children;
    }

    public boolean getHasOptionalBranches(LocalWorld world) {
        Branch[] branches;
        for (Branch branch1 : branches = this.branch.getStructuredObject().getBranches()) {
            boolean hasRandomBranches;
            BO4CustomStructureCoordinate childCoordObject = (BO4CustomStructureCoordinate)branch1.toCustomObjectCoordinate(world, this.random, this.branch.getRotation(), this.branch.getX(), this.branch.getY(), this.branch.getZ(), this.startBO3Name != null ? this.startBO3Name : this.branch.bo3Name);
            if (childCoordObject == null) continue;
            if (!childCoordObject.isRequiredBranch && this.maxDepth > 0) {
                return true;
            }
            if (!childCoordObject.isRequiredBranch) continue;
            BranchDataItem parent = this.parent;
            Boolean bInfinite = false;
            while (parent != null && parent.branch.isRequiredBranch) {
                if (parent.branch.getObject().getName().equals(childCoordObject.getObject().getName())) {
                    bInfinite = true;
                    break;
                }
                parent = parent.parent;
            }
            if (bInfinite.booleanValue()) continue;
            int currentDepth1 = childCoordObject.isRequiredBranch ? this.currentDepth : this.currentDepth + 1;
            int maxDepth1 = this.maxDepth;
            if (childCoordObject.branchDepth > 0 && !this.minimumSize) {
                currentDepth1 = 0;
                maxDepth1 = childCoordObject.branchDepth;
            }
            if (this.minimumSize) {
                maxDepth1 = 0;
            }
            if (!(hasRandomBranches = new BranchDataItem(this.random, this, childCoordObject, this.startBO3Name != null ? this.startBO3Name : this.branch.bo3Name, currentDepth1, maxDepth1, this.minimumSize).getHasOptionalBranches(world))) continue;
            return true;
        }
        return false;
    }
}

