/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.customobjects.bofunctions.ParticleFunction;
import com.pg85.otg.customobjects.bofunctions.SpawnerFunction;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureFileManager;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructure;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructure;
import com.pg85.otg.customobjects.structures.bo4.CustomStructurePlotter;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class CustomStructureCache {
    private Map<ChunkCoordinate, BO3CustomStructure> bo3StructureCache;
    public Map<ChunkCoordinate, BO4CustomStructure> bo4StructureCache;
    public Map<ChunkCoordinate, CustomStructure> worldInfoChunks;
    private LocalWorld world;
    private CustomStructurePlotter plotter;

    public CustomStructureCache(LocalWorld world) {
        this.world = world;
        this.bo3StructureCache = new HashMap<ChunkCoordinate, BO3CustomStructure>();
        this.bo4StructureCache = new HashMap<ChunkCoordinate, BO4CustomStructure>();
        this.worldInfoChunks = new HashMap<ChunkCoordinate, CustomStructure>();
        this.plotter = new CustomStructurePlotter();
        this.loadStructureCache();
    }

    public CustomStructurePlotter getPlotter() {
        return this.plotter;
    }

    public void plotStructures(Random rand, ChunkCoordinate chunkCoord, boolean spawningStructureAtSpawn) {
        this.plotter.plotStructures(this.world, rand, chunkCoord, spawningStructureAtSpawn, this.bo4StructureCache, this.worldInfoChunks);
    }

    public void reload(LocalWorld world) {
        this.world = world;
        this.bo3StructureCache.clear();
    }

    public CustomStructure getStructureStart(Random worldRandom, int chunkX, int chunkZ) {
        BO3CustomStructureCoordinate customObject;
        ChunkCoordinate coord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        BO3CustomStructure structureStart = this.bo3StructureCache.get(coord);
        if (this.bo3StructureCache.size() > 400) {
            this.bo3StructureCache.clear();
        }
        if (structureStart != null) {
            return structureStart;
        }
        Random random = RandomHelper.getRandomForCoords(chunkX ^ 2, (chunkZ + 1) * 2, this.world.getSeed());
        BiomeConfig biomeConfig = this.world.getBiome(chunkX * 16 + 15, chunkZ * 16 + 15).getBiomeConfig();
        CustomStructureGen structureGen = biomeConfig.structureGen;
        if (structureGen != null && (customObject = structureGen.getRandomObjectCoordinate(this.world, random, chunkX, chunkZ)) != null) {
            structureStart = new BO3CustomStructure(this.world, customObject);
            this.bo3StructureCache.put(coord, structureStart);
            return structureStart;
        }
        return null;
    }

    public void compressCache() {
        OTG.log(LogMarker.INFO, "Compressing structure-cache and pre-generator data", new Object[0]);
        int structuresRemoved = 0;
        int a = 0;
        HashMap<ChunkCoordinate, BO4CustomStructure> newStructureCache = new HashMap<ChunkCoordinate, BO4CustomStructure>();
        for (Map.Entry<ChunkCoordinate, BO4CustomStructure> cachedChunk : this.bo4StructureCache.entrySet()) {
            if (!this.world.isInsidePregeneratedRegion(cachedChunk.getKey())) {
                newStructureCache.put(cachedChunk.getKey(), cachedChunk.getValue());
                continue;
            }
            ++structuresRemoved;
            if (cachedChunk.getValue() == null) continue;
            ++a;
            OTG.log(LogMarker.FATAL, "Running " + this.world.getWorldSession().getPreGeneratorIsRunning() + " L" + this.world.getWorldSession().getPregeneratedBorderLeft() + " R" + this.world.getWorldSession().getPregeneratedBorderRight() + " T" + this.world.getWorldSession().getPregeneratedBorderTop() + " B" + this.world.getWorldSession().getPregeneratedBorderBottom(), new Object[0]);
            OTG.log(LogMarker.FATAL, "Error at Chunk X" + cachedChunk.getKey().getChunkX() + " Z" + cachedChunk.getKey().getChunkZ() + ". " + (!this.bo4StructureCache.containsKey(cachedChunk.getKey()) ? (this.world.isInsidePregeneratedRegion(cachedChunk.getKey()) ? "Inside pregenned region" : "Not plotted") : (this.bo4StructureCache.get(cachedChunk.getKey()) == null ? "Plotted and spawned" : (this.bo4StructureCache.get((Object)cachedChunk.getKey()).start != null ? this.bo4StructureCache.get((Object)cachedChunk.getKey()).start.bo3Name : "Trees"))), new Object[0]);
        }
        if (a > 0) {
            throw new RuntimeException();
        }
        this.bo4StructureCache = newStructureCache;
        OTG.log(LogMarker.INFO, "Removed " + structuresRemoved + " cached chunks", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToDisk() {
        Object object;
        block10: {
            int interval;
            OTG.log(LogMarker.DEBUG, "Saving structure data", new Object[0]);
            boolean firstLog = false;
            long starTime = System.currentTimeMillis();
            do {
                object = this.world.getObjectSpawner().lockingObject;
                synchronized (object) {
                    if (!this.world.getObjectSpawner().populating) {
                        this.world.getObjectSpawner().saving = true;
                        break block10;
                    }
                }
                if (firstLog) {
                    OTG.log(LogMarker.WARN, "SaveToDisk waiting on Populate. Although other mods could be causing this and there may not be any problem, this can potentially cause an endless loop!", new Object[0]);
                    firstLog = false;
                }
                interval = 300;
            } while (System.currentTimeMillis() - starTime <= (long)(interval * 1000));
            OTG.log(LogMarker.FATAL, "SaveToDisk waited on populate longer than " + interval + " seconds, something went wrong!", new Object[0]);
            throw new RuntimeException("SaveToDisk waited on populate longer than " + interval + " seconds, something went wrong!");
        }
        if (this.world.getConfigs().getWorldConfig().isOTGPlus) {
            this.compressCache();
        }
        this.saveStructureCache();
        object = this.world.getObjectSpawner().lockingObject;
        synchronized (object) {
            this.world.getObjectSpawner().saveRequired = false;
            this.world.getObjectSpawner().saving = false;
        }
    }

    private void saveStructureCache() {
        OTG.log(LogMarker.DEBUG, "Saving structures and pre-generator data", new Object[0]);
        HashMap<ChunkCoordinate, CustomStructure> worldInfoChunksToSave = new HashMap<ChunkCoordinate, CustomStructure>();
        for (Map.Entry<ChunkCoordinate, CustomStructure> cachedChunk : this.worldInfoChunks.entrySet()) {
            if (cachedChunk.getValue() != null) {
                worldInfoChunksToSave.put(cachedChunk.getKey(), cachedChunk.getValue());
                continue;
            }
            throw new RuntimeException();
        }
        CustomStructureFileManager.saveStructuresFile(worldInfoChunksToSave, this.world);
        if (this.world.getConfigs().getWorldConfig().isOTGPlus) {
            ArrayList<ChunkCoordinate> nullChunks = new ArrayList<ChunkCoordinate>();
            for (Map.Entry<ChunkCoordinate, BO4CustomStructure> cachedChunk : this.bo4StructureCache.entrySet()) {
                if (cachedChunk.getValue() != null || this.world.isInsidePregeneratedRegion(cachedChunk.getKey())) continue;
                nullChunks.add(cachedChunk.getKey());
            }
            CustomStructureFileManager.saveChunksFile(nullChunks, WorldStandardValues.NullChunksFileName, this.world);
            this.plotter.saveSpawnedStructures(this.world);
        }
        OTG.log(LogMarker.DEBUG, "Saving done", new Object[0]);
    }

    private void loadStructureCache() {
        OTG.log(LogMarker.DEBUG, "Loading structures and pre-generator data", new Object[0]);
        int structuresLoaded = 0;
        Map<ChunkCoordinate, CustomStructure> loadedStructures = CustomStructureFileManager.loadStructuresFile(this.world);
        for (Map.Entry<ChunkCoordinate, CustomStructure> loadedStructure : loadedStructures.entrySet()) {
            ++structuresLoaded;
            if (loadedStructure == null) {
                throw new RuntimeException();
            }
            this.worldInfoChunks.put(loadedStructure.getKey(), loadedStructure.getValue());
            if (this.world.getConfigs().getWorldConfig().isOTGPlus) {
                if (!this.world.isInsidePregeneratedRegion(loadedStructure.getKey()) && !this.bo4StructureCache.containsKey(loadedStructure.getKey())) {
                    this.bo4StructureCache.put(loadedStructure.getKey(), (BO4CustomStructure)loadedStructure.getValue());
                }
                for (ChunkCoordinate chunkCoordinate : ((BO4CustomStructure)loadedStructure.getValue()).objectsToSpawn.keySet()) {
                    if (!this.world.isInsidePregeneratedRegion(chunkCoordinate)) {
                        this.bo4StructureCache.put(chunkCoordinate, (BO4CustomStructure)loadedStructure.getValue());
                        continue;
                    }
                    throw new RuntimeException();
                }
                for (ChunkCoordinate chunkCoordinate : ((BO4CustomStructure)loadedStructure.getValue()).smoothingAreasToSpawn.keySet()) {
                    if (!this.world.isInsidePregeneratedRegion(chunkCoordinate)) {
                        this.bo4StructureCache.put(chunkCoordinate, (BO4CustomStructure)loadedStructure.getValue());
                        continue;
                    }
                    throw new RuntimeException();
                }
            }
            for (ModDataFunction<?> modDataFunction : loadedStructure.getValue().modDataManager.modData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(modDataFunction.x, modDataFunction.z), loadedStructure.getValue());
            }
            for (SpawnerFunction spawnerFunction : loadedStructure.getValue().spawnerManager.spawnerData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(spawnerFunction.x, spawnerFunction.z), loadedStructure.getValue());
            }
            for (ParticleFunction particleFunction : loadedStructure.getValue().particlesManager.particleData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(particleFunction.x, particleFunction.z), loadedStructure.getValue());
            }
        }
        OTG.log(LogMarker.DEBUG, "Loaded " + structuresLoaded + " structure chunks", new Object[0]);
        if (this.world.getConfigs().getWorldConfig().isOTGPlus) {
            ArrayList<ChunkCoordinate> nullChunks = CustomStructureFileManager.loadChunksFile(WorldStandardValues.NullChunksFileName, this.world);
            for (ChunkCoordinate chunkCoord : nullChunks) {
                this.bo4StructureCache.remove(chunkCoord);
                if (!this.world.isInsidePregeneratedRegion(chunkCoord)) {
                    this.bo4StructureCache.put(chunkCoord, null);
                    continue;
                }
                OTG.log(LogMarker.FATAL, "Running " + this.world.getWorldSession().getPreGeneratorIsRunning() + " L" + this.world.getWorldSession().getPregeneratedBorderLeft() + " R" + this.world.getWorldSession().getPregeneratedBorderRight() + " T" + this.world.getWorldSession().getPregeneratedBorderTop() + " B" + this.world.getWorldSession().getPregeneratedBorderBottom(), new Object[0]);
                OTG.log(LogMarker.FATAL, "Error at Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ(), new Object[0]);
                throw new RuntimeException("Error at Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ());
            }
            this.plotter.loadSpawnedStructures(this.world);
            for (ChunkCoordinate chunkCoord : this.bo4StructureCache.keySet()) {
                this.plotter.addToStructuresPerChunkCache(chunkCoord, new ArrayList<String>());
            }
            if (loadedStructures.size() > 0 || nullChunks.size() > 0 || this.plotter.getStructureCount() > 0) {
                this.world.getObjectSpawner().StructurePlottedAtSpawn = true;
            }
        }
        OTG.log(LogMarker.DEBUG, "Loading done", new Object[0]);
    }
}

