/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import java.util.List;

public abstract class ParticleFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public int x;
    public int y;
    public int z;
    public Boolean firstSpawn = true;
    public String particleName = "";
    public double interval = 1.0;
    public double intervalOffset = 0.0;
    public double velocityX = 0.0;
    public double velocityY = 0.0;
    public double velocityZ = 0.0;
    public boolean velocityXSet = false;
    public boolean velocityYSet = false;
    public boolean velocityZSet = false;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.particleName = args.get(3);
        this.interval = this.readDouble(args.get(4), 0.0, 2.147483647E9);
        if (args.size() > 5) {
            this.velocityX = this.readDouble(args.get(5), -2.147483648E9, 2.147483647E9);
            this.velocityXSet = true;
        }
        if (args.size() > 6) {
            this.velocityY = this.readDouble(args.get(6), -2.147483648E9, 2.147483647E9);
            this.velocityYSet = true;
        }
        if (args.size() > 7) {
            this.velocityZ = this.readDouble(args.get(7), -2.147483648E9, 2.147483647E9);
            this.velocityZSet = true;
        }
    }

    @Override
    public String makeString() {
        return "Particle(" + this.x + ',' + this.y + ',' + this.z + ',' + this.particleName + ',' + this.interval + ',' + this.velocityX + ',' + this.velocityY + ',' + this.velocityZ + ')';
    }

    public String makeStringForPacket() {
        return "Particle(" + this.x + ',' + this.y + ',' + this.z + ',' + this.particleName + ',' + this.interval + ',' + this.velocityX + ',' + this.velocityY + ',' + this.velocityZ + ',' + this.velocityXSet + ',' + this.velocityYSet + ',' + this.velocityZSet + ')';
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ParticleFunction block = (ParticleFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.particleName.equalsIgnoreCase(this.particleName) && block.interval == this.interval && block.velocityX == this.velocityX && block.velocityY == this.velocityY && block.velocityZ == this.velocityZ;
    }

    public abstract ParticleFunction<T> getNewInstance();
}

