/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public abstract class EntityFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public int x;
    public int y;
    public int z;
    public String mobName = "";
    public int groupSize = 1;
    public String nameTagOrNBTFileName = "";
    public String originalNameTagOrNBTFileName = "";
    private String metaDataTag;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.mobName = args.get(3);
        this.groupSize = this.readInt(args.get(4), 0, Integer.MAX_VALUE);
        if (args.size() > 5) {
            this.originalNameTagOrNBTFileName = args.get(5);
        }
        if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
            this.nameTagOrNBTFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
        }
    }

    @Override
    public String makeString() {
        return "Entity(" + this.x + ',' + this.y + ',' + this.z + ',' + this.mobName + ',' + this.groupSize + (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.length() > 0 ? ',' + this.originalNameTagOrNBTFileName : "") + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetaData() {
        if (this.nameTagOrNBTFileName != null && this.nameTagOrNBTFileName.length() > 0 && this.metaDataTag == null) {
            File metaDataFile = new File(this.nameTagOrNBTFileName);
            StringBuilder stringbuilder = new StringBuilder();
            if (metaDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(metaDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.metaDataTag = stringbuilder.toString();
        }
        return this.metaDataTag;
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        EntityFunction block = (EntityFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.mobName.equalsIgnoreCase(this.mobName) && block.groupSize == this.groupSize && block.originalNameTagOrNBTFileName == this.originalNameTagOrNBTFileName;
    }

    public abstract EntityFunction<T> createNewInstance();
}

