/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.io.FileSettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo3.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BlockFunction;
import com.pg85.otg.customobjects.bo4.bo4function.BO4RandomBlockFunction;
import com.pg85.otg.customobjects.structures.Branch;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.surface.MesaSurfaceGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.BoundingBox;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class BO4
implements StructuredCustomObject {
    public static HashMap<ChunkCoordinate, LocalMaterialData> OriginalTopBlocks = new HashMap();
    public boolean isInvalidConfig;
    private BO4Config settings;
    private final String name;
    private final File file;

    BO4(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BO4Config getSettings() {
        return this.settings;
    }

    @Override
    public boolean onEnable() {
        try {
            this.settings = new BO4Config(new FileSettingsReaderOTGPlus(this.name, this.file), true);
            if (this.settings.settingsMode != WorldConfig.ConfigMode.WriteDisable) {
                FileSettingsWriterOTGPlus.writeToFile(this.settings, this.settings.settingsMode);
            }
        }
        catch (InvalidConfigException ex) {
            this.isInvalidConfig = true;
            return false;
        }
        return true;
    }

    public void generateBO4Data() {
        String filePath = this.settings.getFile().getAbsolutePath().endsWith(".BO4") ? this.settings.getFile().getAbsolutePath().replace(".BO4", ".BO4Data") : (this.settings.getFile().getAbsolutePath().endsWith(".bo4") ? this.settings.getFile().getAbsolutePath().replace(".bo4", ".BO4Data") : (this.settings.getFile().getAbsolutePath().endsWith(".BO3") ? this.settings.getFile().getAbsolutePath().replace(".BO3", ".BO4Data") : (this.settings.getFile().getAbsolutePath().endsWith(".bo3") ? this.settings.getFile().getAbsolutePath().replace(".bo3", ".BO4Data") : this.settings.getFile().getAbsolutePath())));
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                DataOutputStream dos = new DataOutputStream(fos);
                this.settings.writeToStream(dos);
                dos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canSpawnAsTree() {
        return false;
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }

    @Override
    public boolean spawnFromSapling(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, int minY, int maxY) {
        return false;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        return false;
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z, int minY, int maxY) {
        return false;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        return false;
    }

    @Override
    public Branch[] getBranches() {
        return this.settings.getbranches();
    }

    @Override
    public Branch[] getBranches(Rotation rotation) {
        return null;
    }

    @Override
    public CustomStructureCoordinate makeCustomObjectCoordinate(LocalWorld world, Random random, int chunkX, int chunkZ) {
        return null;
    }

    @Override
    public StructurePartSpawnHeight getStructurePartSpawnHeight() {
        return null;
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return null;
    }

    @Override
    public int getMaxBranchDepth() {
        return -1;
    }

    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, ChunkCoordinate chunkCoord, int x, int y, int z, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        return this.spawnForcedOTGPlus(world, random, rotation, chunkCoord, x, y, z, replaceAbove, replaceBelow, replaceWithBiomeBlocks, replaceWithSurfaceBlock, replaceWithGroundBlock, spawnUnderWater, waterLevel, isStructureAtSpawn, doReplaceAboveBelowOnly);
    }

    public boolean isCollidable() {
        return this.getSettings().isCollidable();
    }

    private void setBlock(LocalWorld world, int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isStructureAtSpawn) {
        DefaultMaterial worldMaterial;
        LocalMaterialData targetBlock;
        HashMap<DefaultMaterial, LocalMaterialData> blocksToReplace = world.getConfigs().getWorldConfig().getReplaceBlocksDict();
        if (blocksToReplace != null && blocksToReplace.size() > 0 && (targetBlock = blocksToReplace.get((Object)material.toDefaultMaterial())) != null) {
            material = targetBlock;
        }
        if (OTG.getPluginConfig().developerMode && ((worldMaterial = world.getMaterial(x, y, z, false).toDefaultMaterial()) == DefaultMaterial.GOLD_BLOCK || worldMaterial == DefaultMaterial.IRON_BLOCK || worldMaterial == DefaultMaterial.REDSTONE_BLOCK || worldMaterial == DefaultMaterial.DIAMOND_BLOCK || worldMaterial == DefaultMaterial.LAPIS_BLOCK || worldMaterial == DefaultMaterial.COAL_BLOCK || worldMaterial == DefaultMaterial.QUARTZ_BLOCK || worldMaterial == DefaultMaterial.EMERALD_BLOCK)) {
            if (material.toDefaultMaterial() == DefaultMaterial.GOLD_BLOCK || material.toDefaultMaterial() == DefaultMaterial.IRON_BLOCK || material.toDefaultMaterial() == DefaultMaterial.REDSTONE_BLOCK || material.toDefaultMaterial() == DefaultMaterial.DIAMOND_BLOCK || material.toDefaultMaterial() == DefaultMaterial.LAPIS_BLOCK || material.toDefaultMaterial() == DefaultMaterial.COAL_BLOCK || material.toDefaultMaterial() == DefaultMaterial.QUARTZ_BLOCK || material.toDefaultMaterial() == DefaultMaterial.EMERALD_BLOCK) {
                world.setBlock(x, y, z, MaterialHelper.toLocalMaterialData(DefaultMaterial.GLOWSTONE, 0), null, true);
            }
            return;
        }
        world.setBlock(x, y, z, material, metaDataTag, true);
    }

    private boolean spawnForcedOTGPlus(LocalWorld world, Random random, Rotation rotation, ChunkCoordinate chunkCoord, int x, int y, int z, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        LocalMaterialData airMaterial;
        LocalMaterialData bo3GroundBlock;
        LocalMaterialData bo3SurfaceBlock;
        LocalMaterialData replaceAboveMaterial;
        LocalMaterialData replaceBelowMaterial;
        block91: {
            block90: {
                block89: {
                    block88: {
                        replaceBelowMaterial = null;
                        replaceAboveMaterial = null;
                        bo3SurfaceBlock = null;
                        bo3GroundBlock = null;
                        airMaterial = null;
                        airMaterial = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
                        if (this.settings == null) {
                            OTG.log(LogMarker.FATAL, "Settings was null for BO3 " + this.getName() + ". This should not be happening, please contact the developer.", new Object[0]);
                            throw new RuntimeException("Settings was null for BO3 " + this.getName() + ". This should not be happening, please contact the developer.");
                        }
                        try {
                            bo3SurfaceBlock = replaceWithSurfaceBlock != null && replaceWithSurfaceBlock.length() > 0 ? MaterialHelper.readMaterial(replaceWithSurfaceBlock) : MaterialHelper.readMaterial("GRASS");
                        }
                        catch (InvalidConfigException e1) {
                            bo3SurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.GRASS, 0);
                            if (!OTG.getPluginConfig().spawnLog) break block88;
                            OTG.log(LogMarker.WARN, "Value " + replaceWithSurfaceBlock + " for replaceWithSurfaceBlock in BO3 " + this.getName() + " was not recognised. Using GRASS instead.", new Object[0]);
                        }
                    }
                    try {
                        bo3GroundBlock = replaceWithGroundBlock != null && replaceWithGroundBlock.length() > 0 ? MaterialHelper.readMaterial(replaceWithGroundBlock) : MaterialHelper.readMaterial("DIRT");
                    }
                    catch (InvalidConfigException e1) {
                        bo3GroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 0);
                        if (!OTG.getPluginConfig().spawnLog) break block89;
                        OTG.log(LogMarker.WARN, "Value " + replaceWithGroundBlock + " for replaceWithGroundBlock in BO3 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
                    }
                }
                try {
                    replaceBelowMaterial = this.settings.replaceBelow != null && this.settings.replaceBelow.toLowerCase().equals("none") ? null : (replaceBelow != null && replaceBelow.length() > 0 ? MaterialHelper.readMaterial(replaceBelow) : null);
                }
                catch (InvalidConfigException e1) {
                    replaceBelowMaterial = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 0);
                    if (!OTG.getPluginConfig().spawnLog) break block90;
                    OTG.log(LogMarker.INFO, "Value " + this.settings.replaceBelow + " for replaceBelow in BO3 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
                }
            }
            try {
                replaceAboveMaterial = this.settings.replaceAbove != null && this.settings.replaceAbove.toLowerCase().equals("none") ? null : (replaceAbove != null && replaceAbove.length() > 0 ? MaterialHelper.readMaterial(replaceAbove) : null);
            }
            catch (InvalidConfigException e1) {
                replaceAboveMaterial = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
                if (!OTG.getPluginConfig().spawnLog) break block91;
                OTG.log(LogMarker.INFO, "Value " + this.settings.replaceAbove + " for replaceAbove in BO3 " + this.getName() + " was not recognised. Using AIR instead.", new Object[0]);
            }
        }
        boolean isOnBiomeBorder = false;
        LocalBiome biome = null;
        LocalBiome biome2 = null;
        LocalBiome biome3 = null;
        LocalBiome biome4 = null;
        BiomeConfig biomeConfig = null;
        LocalMaterialData biomeSurfaceBlock = null;
        LocalMaterialData biomeGroundBlock = null;
        if (replaceWithBiomeBlocks) {
            biome = world.getBiome(x, z);
            biome2 = world.getBiome(x + 15, z);
            biome3 = world.getBiome(x, z + 15);
            biome4 = world.getBiome(x + 15, z + 15);
            if (biome != biome2 || biome != biome3 || biome != biome4) {
                isOnBiomeBorder = true;
            }
            biomeConfig = biome.getBiomeConfig();
            biomeSurfaceBlock = biomeConfig.surfaceBlock;
            if (biomeSurfaceBlock == null) {
                biomeSurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.GRASS, 0);
            }
            if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                biomeGroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 0);
            }
            if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                biomeSurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
            }
            if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                biomeGroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
            }
        }
        ArrayList<Object[]> coordsAboveDone = new ArrayList<Object[]>();
        ArrayList<Object[]> coordsBelowDone = new ArrayList<Object[]>();
        BO4BlockFunction blockToQueueForSpawn = new BO4BlockFunction();
        boolean outOfBounds = false;
        long startTime = System.currentTimeMillis();
        for (BO4BlockFunction block : this.settings.getBlocks()) {
            LocalMaterialData sourceBlockMaterial;
            if (block instanceof BO4RandomBlockFunction) {
                BO4RandomBlockFunction randomBlockFunction = (BO4RandomBlockFunction)block;
                for (int i = 0; i < randomBlockFunction.blockCount; ++i) {
                    if (random.nextInt(100) >= randomBlockFunction.blockChances[i]) continue;
                    block.metaDataName = randomBlockFunction.metaDataNames[i];
                    block.metaDataTag = randomBlockFunction.metaDataTags[i];
                    block.material = randomBlockFunction.blocks[i];
                    break;
                }
            }
            if (block.material == null || block.material.toDefaultMaterial() == DefaultMaterial.UNKNOWN_BLOCK) continue;
            if (rotation != Rotation.NORTH) {
                boolean bFound;
                BO4BlockFunction newBlock = new BO4BlockFunction();
                int rotations = 0;
                if (rotation == Rotation.WEST) {
                    rotations = 1;
                } else if (rotation == Rotation.SOUTH) {
                    rotations = 2;
                } else if (rotation == Rotation.EAST) {
                    rotations = 3;
                }
                if (rotations == 0) {
                    newBlock.x = block.x;
                    newBlock.z = block.z;
                }
                if (rotations == 1) {
                    newBlock.x = block.z;
                    newBlock.z = -block.x + 15;
                    newBlock.material = block.material.rotate();
                }
                if (rotations == 2) {
                    newBlock.x = -block.x + 15;
                    newBlock.z = -block.z + 15;
                    newBlock.material = block.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                }
                if (rotations == 3) {
                    newBlock.x = -block.z + 15;
                    newBlock.z = block.x;
                    newBlock.material = block.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                }
                newBlock.y = block.y;
                newBlock.metaDataName = block.metaDataName;
                newBlock.metaDataTag = block.metaDataTag;
                if (!OriginalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(x + newBlock.x, z + newBlock.z))) {
                    int highestBlockY = world.getHighestBlockYAt(x + newBlock.x, z + newBlock.z, true, true, false, false);
                    if (highestBlockY <= 0) {
                        highestBlockY = 1;
                    }
                    if (highestBlockY >= 256) {
                        highestBlockY = 255;
                    }
                    OriginalTopBlocks.put(ChunkCoordinate.fromChunkCoords(x + newBlock.x, z + newBlock.z), world.getMaterial(x + newBlock.x, highestBlockY, z + newBlock.z, true));
                }
                if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                    bFound = false;
                    for (Object[] coords : coordsAboveDone) {
                        if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        coordsAboveDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                        int highestBlockToReplace = world.getHighestBlockYAt(x + newBlock.x, z + newBlock.z, true, true, false, false);
                        for (int blockY = y + newBlock.y + 1; blockY <= highestBlockToReplace && blockY > y + newBlock.y; ++blockY) {
                            blockToQueueForSpawn = new BO4BlockFunction();
                            blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? airMaterial : replaceAboveMaterial;
                            blockToQueueForSpawn.x = x + newBlock.x;
                            blockToQueueForSpawn.y = (short)blockY;
                            blockToQueueForSpawn.z = z + newBlock.z;
                            blockToQueueForSpawn.metaDataName = block.metaDataName;
                            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
                            if (sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                            if (chunkCoord.equals(destChunk)) {
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                continue;
                            }
                            outOfBounds = true;
                        }
                    }
                }
                if (replaceBelowMaterial != null && block.y == 0 && !block.material.isAir() && doReplaceAboveBelowOnly) {
                    bFound = false;
                    for (Object[] coords : coordsBelowDone) {
                        if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        coordsBelowDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                        for (int blockY = y + newBlock.y - 1; blockY > 0; --blockY) {
                            if (blockY >= 256) continue;
                            blockToQueueForSpawn = new BO4BlockFunction();
                            blockToQueueForSpawn.x = x + newBlock.x;
                            blockToQueueForSpawn.y = (short)blockY;
                            blockToQueueForSpawn.z = z + newBlock.z;
                            blockToQueueForSpawn.material = replaceBelowMaterial;
                            blockToQueueForSpawn.metaDataName = block.metaDataName;
                            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
                            if (!sourceBlockMaterial.isSolid() && !sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                                ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                                if (chunkCoord.equals(destChunk)) {
                                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                    continue;
                                }
                                outOfBounds = true;
                                continue;
                            }
                            if (sourceBlockMaterial.isSolid()) break;
                        }
                    }
                }
                if (y + newBlock.y <= 0 || y + newBlock.y >= 256 || doReplaceAboveBelowOnly) continue;
                blockToQueueForSpawn = new BO4BlockFunction();
                blockToQueueForSpawn.x = x + newBlock.x;
                blockToQueueForSpawn.y = (short)(y + newBlock.y);
                blockToQueueForSpawn.z = z + newBlock.z;
                blockToQueueForSpawn.material = newBlock.material;
                blockToQueueForSpawn.metaDataName = block.metaDataName;
                blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
                if (replaceWithBiomeBlocks) {
                    LocalMaterialData customBlockData;
                    if (isOnBiomeBorder) {
                        biome = world.getBiome(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                        biomeConfig = biome.getBiomeConfig();
                        biomeSurfaceBlock = biomeConfig.surfaceBlock;
                        if (biomeSurfaceBlock == null) {
                            biomeSurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.GRASS, 0);
                        }
                        if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                            biomeGroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.DIRT, 0);
                        }
                        if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                            biomeSurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                        }
                        if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                            biomeGroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                        }
                    }
                    if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3GroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3GroundBlock.getBlockData()) {
                        blockToQueueForSpawn.material = biomeGroundBlock;
                    } else if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3SurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3SurfaceBlock.getBlockData()) {
                        blockToQueueForSpawn.material = biomeSurfaceBlock;
                        LocalMaterialData originalSurfaceBlock = OriginalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z));
                        if (originalSurfaceBlock != null && originalSurfaceBlock.toDefaultMaterial() != DefaultMaterial.UNKNOWN_BLOCK && !originalSurfaceBlock.isLiquid() && !originalSurfaceBlock.isAir()) {
                            blockToQueueForSpawn.material = originalSurfaceBlock;
                        }
                    }
                    if (biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeGroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeGroundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeSurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeSurfaceBlock.getBlockData()) && (customBlockData = ((MesaSurfaceGenerator)biomeConfig.surfaceAndGroundControl).getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z)) != null) {
                        blockToQueueForSpawn.material = customBlockData;
                    }
                }
                if (spawnUnderWater && blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)DefaultMaterial.TORCH) && sourceBlockMaterial.isLiquid() || sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                if (chunkCoord.equals(destChunk)) {
                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                    continue;
                }
                outOfBounds = true;
                continue;
            }
            if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                boolean bFound = false;
                for (Object[] coords : coordsAboveDone) {
                    if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    coordsAboveDone.add(new Object[]{x + block.x, z + block.z});
                    int heighestBlockToReplace = world.getHighestBlockYAt(x + block.x, z + block.z, true, true, false, false);
                    for (short blockY = (short)(y + block.y + 1); blockY <= heighestBlockToReplace && blockY > y + block.y; blockY = (short)(blockY + 1)) {
                        blockToQueueForSpawn = new BO4BlockFunction();
                        blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? airMaterial : replaceAboveMaterial;
                        blockToQueueForSpawn.x = x + block.x;
                        blockToQueueForSpawn.y = blockY;
                        blockToQueueForSpawn.z = z + block.z;
                        blockToQueueForSpawn.metaDataName = block.metaDataName;
                        blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                        sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
                        if (!OriginalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                            int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                            if (highestBlockY <= 0) {
                                highestBlockY = 1;
                            }
                            if (highestBlockY >= 256) {
                                highestBlockY = 255;
                            }
                            OriginalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, true));
                        }
                        if (sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                        ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                        if (chunkCoord.equals(destChunk)) {
                            this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                            continue;
                        }
                        outOfBounds = true;
                    }
                }
            }
            if (replaceBelowMaterial != null && block.y == 0 && !block.material.isAir() && doReplaceAboveBelowOnly) {
                boolean bFound = false;
                for (Object[] coords : coordsBelowDone) {
                    if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    coordsBelowDone.add(new Object[]{x + block.x, z + block.z});
                    for (short blockY = (short)(y + block.y - 1); blockY > 0; blockY = (short)(blockY - 1)) {
                        if (blockY >= 256) continue;
                        blockToQueueForSpawn = new BO4BlockFunction();
                        blockToQueueForSpawn.x = x + block.x;
                        blockToQueueForSpawn.y = blockY;
                        blockToQueueForSpawn.z = z + block.z;
                        blockToQueueForSpawn.material = replaceBelowMaterial;
                        blockToQueueForSpawn.metaDataName = block.metaDataName;
                        blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                        sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
                        if (!OriginalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                            int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                            if (highestBlockY <= 0) {
                                highestBlockY = 1;
                            }
                            if (highestBlockY >= 256) {
                                highestBlockY = 255;
                            }
                            OriginalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, true));
                        }
                        if (!sourceBlockMaterial.isSolid() && !sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                            if (chunkCoord.equals(destChunk)) {
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                continue;
                            }
                            outOfBounds = true;
                            continue;
                        }
                        if (sourceBlockMaterial.isSolid()) break;
                    }
                }
            }
            if (y + block.y <= 0 || y + block.y >= 256 || doReplaceAboveBelowOnly) continue;
            blockToQueueForSpawn = new BO4BlockFunction();
            blockToQueueForSpawn.x = x + block.x;
            blockToQueueForSpawn.y = (short)(y + block.y);
            blockToQueueForSpawn.z = z + block.z;
            blockToQueueForSpawn.material = block.material;
            blockToQueueForSpawn.metaDataName = block.metaDataName;
            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, true);
            if (!OriginalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                if (highestBlockY > 0) {
                    OriginalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, true));
                } else {
                    OriginalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), null);
                }
            }
            if (replaceWithBiomeBlocks) {
                LocalMaterialData customBlockData;
                if (isOnBiomeBorder) {
                    biome = world.getBiome(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                    biomeConfig = biome.getBiomeConfig();
                    biomeSurfaceBlock = biomeConfig.surfaceBlock;
                    if (biomeSurfaceBlock == null) {
                        biomeSurfaceBlock = bo3SurfaceBlock;
                    }
                    if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                        biomeGroundBlock = bo3GroundBlock;
                    }
                    if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                        biomeSurfaceBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                    }
                    if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                        biomeGroundBlock = MaterialHelper.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                    }
                }
                if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3GroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3GroundBlock.getBlockData()) {
                    blockToQueueForSpawn.material = biomeGroundBlock;
                } else if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3SurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3SurfaceBlock.getBlockData()) {
                    blockToQueueForSpawn.material = biomeSurfaceBlock;
                    LocalMaterialData originalSurfaceBlock = OriginalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z));
                    if (originalSurfaceBlock != null && originalSurfaceBlock.toDefaultMaterial() != DefaultMaterial.UNKNOWN_BLOCK && !originalSurfaceBlock.isLiquid() && !originalSurfaceBlock.isAir()) {
                        blockToQueueForSpawn.material = originalSurfaceBlock;
                    }
                }
                if (biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeGroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeGroundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeSurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeSurfaceBlock.getBlockData()) && (customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z)) != null) {
                    blockToQueueForSpawn.material = customBlockData;
                }
            }
            if (spawnUnderWater && blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)DefaultMaterial.TORCH) && sourceBlockMaterial.isLiquid() || sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
            if (chunkCoord.equals(destChunk)) {
                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                continue;
            }
            outOfBounds = true;
        }
        if (outOfBounds && OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "BO3 " + this.getName() + " tried to spawn blocks outside of the chunk being populated, the blocks have been ignored. This can happen if a BO3 is not sliced into 16x16 pieces or has branches positioned in such a way that they cross a chunk border. OTG is more strict than TC in how branching BO3's used as CustomStructures() should be designed, BO3 creators have to design their BO3's and position their branches so that they fit neatly into a 16x16 grid. Hopefully in a future release OTG can be made to automatically slice branching structures instead of forcing the BO3 creator to do it.", new Object[0]);
        }
        if (OTG.getPluginConfig().spawnLog && System.currentTimeMillis() - startTime > 50L) {
            OTG.log(LogMarker.WARN, "Warning: Spawning BO3 " + this.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.", new Object[0]);
        }
        return true;
    }
}

