/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3.bo3function;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bofunctions.BranchFunction;
import com.pg85.otg.customobjects.bofunctions.BranchNode;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo3.BO3CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.bo3.Rotation;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class BO3BranchFunction
extends BranchFunction<BO3Config> {
    public BO3BranchFunction rotate() {
        BO3BranchFunction rotatedBranch = new BO3BranchFunction();
        rotatedBranch.x = this.z;
        rotatedBranch.y = this.y;
        rotatedBranch.z = -this.x;
        rotatedBranch.branches = new TreeSet();
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        for (BranchNode holder : this.branches) {
            rotatedBranch.branches.add(new BranchNode(holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, null), holder.customObjectName));
        }
        return rotatedBranch;
    }

    @Override
    protected double readArgs(List<String> args, boolean accumulateChances) throws InvalidConfigException {
        int i;
        double cumulativeChance = 0.0;
        this.assureSize(6, args);
        this.x = this.readInt(args.get(0), -32, 32);
        this.y = this.readInt(args.get(1), -64, 64);
        this.z = this.readInt(args.get(2), -32, 32);
        for (i = 3; i < args.size() - 2; i += 3) {
            double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
            if (accumulateChances) {
                this.branches.add(new BranchNode(Rotation.getRotation(args.get(i + 1)), cumulativeChance += branchChance, null, args.get(i)));
                continue;
            }
            this.branches.add(new BranchNode(Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i)));
        }
        if (i < args.size()) {
            this.totalChanceSet = true;
            this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
        }
        return cumulativeChance;
    }

    @Override
    public CustomStructureCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, String startBO3Name) {
        for (BranchNode branch : this.branches) {
            double randomChance = random.nextDouble() * this.totalChance;
            if (!(randomChance < branch.getChance())) continue;
            return new BO3CustomStructureCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, branch.getRotation(), x + this.x, (short)(y + this.y), z + this.z);
        }
        return null;
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

