/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo3.bo3function.BO3BlockFunction;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.ArrayList;
import java.util.Random;

class ObjectExtrusionHelper {
    private int blockExtrusionY;
    private BO3Settings.ExtrudeMode extrudeMode;
    private MaterialSet extrudeThroughBlocks;
    private ArrayList<BO3BlockFunction> blocksToExtrude = new ArrayList();

    ObjectExtrusionHelper(BO3Settings.ExtrudeMode extrudeMode, MaterialSet extrudeThroughBlocks) {
        this.extrudeMode = extrudeMode;
        this.extrudeThroughBlocks = extrudeThroughBlocks;
        this.blockExtrusionY = extrudeMode.getStartingHeight();
    }

    void addBlock(BO3BlockFunction block) {
        if (this.extrudeMode != BO3Settings.ExtrudeMode.None) {
            if (this.extrudeMode == BO3Settings.ExtrudeMode.BottomDown && block.y < this.blockExtrusionY) {
                this.blocksToExtrude.clear();
                this.blockExtrusionY = block.y;
            } else if (this.extrudeMode == BO3Settings.ExtrudeMode.TopUp && block.y > this.blockExtrusionY) {
                this.blocksToExtrude.clear();
                this.blockExtrusionY = block.y;
            }
            if (block.y == this.blockExtrusionY) {
                this.blocksToExtrude.add(block);
            }
        }
    }

    void extrude(LocalWorld world, Random random, int x, int y, int z) {
        for (BO3BlockFunction block : this.blocksToExtrude) {
            int yi;
            if (this.extrudeMode == BO3Settings.ExtrudeMode.BottomDown) {
                for (yi = y + block.y - 1; yi > this.extrudeMode.getEndingHeight() && this.extrudeThroughBlocks.contains(world.getMaterial(x + block.x, yi, z + block.z, false)); --yi) {
                    world.setBlock(x + block.x, yi, z + block.z, block.material, block.metaDataTag, false);
                }
                continue;
            }
            if (this.extrudeMode != BO3Settings.ExtrudeMode.TopUp) continue;
            for (yi = y + block.y + 1; yi < this.extrudeMode.getEndingHeight() && this.extrudeThroughBlocks.contains(world.getMaterial(x + block.x, yi, z + block.z, false)); ++yi) {
                world.setBlock(x + block.x, yi, z + block.z, block.material, block.metaDataTag, false);
            }
        }
    }
}

