/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.util.Random;

public class TreeObject
implements CustomObject {
    private TreeType type;
    public int defaultMinHeight = 0;
    public int defaultMaxHeight = 256;
    public int minHeight = 0;
    public int maxHeight = 256;

    TreeObject(TreeType type) {
        this.type = type;
    }

    @Override
    public boolean onEnable() {
        return true;
    }

    @Override
    public String getName() {
        return this.type.name();
    }

    @Override
    public boolean canSpawnAsTree() {
        return true;
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        if (y < this.minHeight || y > this.maxHeight) {
            return false;
        }
        return this.spawnForced(world, random, rotation, x, y, z);
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, int minY, int maxY) {
        return false;
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getBlockXCenter() + random.nextInt(16);
        int z = chunkCoord.getBlockZCenter() + random.nextInt(16);
        int y = world.getHighestBlockYAt(x, z);
        return this.trySpawnAt(world, random, Rotation.NORTH, x, y, z);
    }

    @Override
    public boolean spawnFromSapling(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return world.placeTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return world.placeTree(this.type, random, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        Rotation rotation = Rotation.getRandomRotation(random);
        return this.trySpawnAt(world, random, rotation, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z, int minY, int maxY) {
        int y = world.getHighestBlockYAt(x, z);
        Rotation rotation = Rotation.getRandomRotation(random);
        if (y < minY || y > maxY) {
            return false;
        }
        return this.spawnForced(world, random, rotation, x, y, z);
    }

    @Override
    public boolean canRotateRandomly() {
        return false;
    }
}

