/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.settingType;

import com.pg85.otg.configuration.settingType.Setting;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.helpers.StringHelper;

class FloatSetting
extends Setting<Float> {
    private final float defaultValue;
    private final float minValue;
    private final float maxValue;

    FloatSetting(String name, float defaultValue, float minValue, float maxValue) {
        super(name);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public Float read(String string) throws InvalidConfigException {
        return Float.valueOf((float)StringHelper.readDouble(string, this.minValue, this.maxValue));
    }

    public Float getMinValue() {
        return Float.valueOf(this.minValue);
    }

    public Float getMaxValue() {
        return Float.valueOf(this.maxValue);
    }
}

