/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.dimensions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.shaded.fasterxml.jackson.core.JsonGenerationException;
import com.pg85.otg.shaded.fasterxml.jackson.core.JsonParseException;
import com.pg85.otg.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.pg85.otg.shaded.fasterxml.jackson.databind.JsonMappingException;
import com.pg85.otg.shaded.fasterxml.jackson.databind.ObjectMapper;
import com.pg85.otg.shaded.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DimensionsConfig {
    private static HashMap<String, DimensionsConfig> DefaultConfigs = new HashMap();
    private File worldSavesDir;
    public String WorldName;
    public DimensionConfig Overworld;
    public ArrayList<DimensionConfig> Dimensions = new ArrayList();

    public DimensionsConfig() {
    }

    public DimensionsConfig(File mcWorldSaveDir) {
        this.WorldName = mcWorldSaveDir.getName();
        this.worldSavesDir = mcWorldSaveDir.getParentFile();
    }

    public DimensionsConfig(File mcWorldSavesDir, String worldDir) {
        this.worldSavesDir = mcWorldSavesDir;
        this.WorldName = worldDir;
    }

    public static DimensionsConfig getModPackConfig(String presetName) {
        DimensionsConfig forgeWorldConfig = DefaultConfigs.get(presetName);
        if (forgeWorldConfig != null) {
            return forgeWorldConfig;
        }
        File configDir = new File(OTG.getEngine().getOTGRootFolder().getParentFile().getParentFile() + File.separator + "config" + File.separator + "OpenTerrainGenerator" + File.separator);
        if (configDir.exists()) {
            for (File f : configDir.listFiles()) {
                DimensionsConfig forgeWorldConfig2 = DimensionsConfig.defaultConfigfromFile(f);
                if (forgeWorldConfig2 == null || (forgeWorldConfig2.Overworld.PresetName != null || presetName != null) && (forgeWorldConfig2.Overworld.PresetName == null || !forgeWorldConfig2.Overworld.PresetName.equals(presetName))) continue;
                DefaultConfigs.put(presetName, forgeWorldConfig2);
                return forgeWorldConfig2;
            }
        }
        return null;
    }

    private static DimensionsConfig defaultConfigfromFile(File file) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        DimensionsConfig presetsConfig = null;
        try {
            presetsConfig = mapper.readValue(file, DimensionsConfig.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return presetsConfig;
    }

    public static DimensionsConfig loadFromFile(File mcWorldSaveDir) {
        File forgeWorldConfigFile = new File(mcWorldSaveDir + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigFileName);
        DimensionsConfig presetsConfig = null;
        if (forgeWorldConfigFile.exists()) {
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            try {
                presetsConfig = mapper.readValue(forgeWorldConfigFile, DimensionsConfig.class);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
            }
            catch (JsonMappingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            presetsConfig.WorldName = mcWorldSaveDir.getName();
            presetsConfig.worldSavesDir = mcWorldSaveDir.getParentFile();
        }
        return presetsConfig;
    }

    public String toYamlString() {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        try {
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save() {
        if (this.worldSavesDir != null) {
            File forgeWorldConfigFile = new File(this.worldSavesDir.getAbsolutePath() + File.separator + this.WorldName + File.separator + "OpenTerrainGenerator" + File.separator + WorldStandardValues.DimensionsConfigFileName);
            if (!forgeWorldConfigFile.exists()) {
                forgeWorldConfigFile.getParentFile().mkdirs();
                try {
                    forgeWorldConfigFile.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("OTG encountered a critical error, exiting.");
                }
            }
            ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
            try {
                try {
                    mapper.writeValue(forgeWorldConfigFile, (Object)this);
                }
                catch (JsonGenerationException e) {
                    e.printStackTrace();
                    throw new RuntimeException("OTG encountered a critical error, exiting.");
                }
                catch (JsonMappingException e) {
                    e.printStackTrace();
                    throw new RuntimeException("OTG encountered a critical error, exiting.");
                }
                BufferedReader read = new BufferedReader(new FileReader(forgeWorldConfigFile));
                ArrayList<String> list = new ArrayList<String>();
                String dataRow = read.readLine();
                while (dataRow != null) {
                    list.add(dataRow);
                    dataRow = read.readLine();
                }
                read.close();
                FileWriter writer = new FileWriter(forgeWorldConfigFile);
                String headerComments = "#TODO: Provide instructions for modpack devs.";
                writer.append(headerComments);
                for (int i = 0; i < list.size(); ++i) {
                    writer.append(System.getProperty("line.separator"));
                    writer.append((CharSequence)list.get(i));
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("OTG encountered a critical error, exiting.");
            }
        }
    }

    public DimensionConfig getDimensionConfig(String worldName) {
        if (worldName.equals("overworld") || worldName.equals(this.WorldName)) {
            return this.Overworld;
        }
        if (this.Dimensions != null) {
            for (DimensionConfig dimConfig : this.Dimensions) {
                if (!dimConfig.PresetName.equals(worldName)) continue;
                return dimConfig;
            }
        }
        return null;
    }

    public static DimensionsConfig fromYamlString(String readStringFromStream) {
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        DimensionsConfig presetsConfig = null;
        try {
            presetsConfig = mapper.readValue(readStringFromStream, DimensionsConfig.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return presetsConfig;
    }
}

