/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.biome.settings;

import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.helpers.StringHelper;
import com.pg85.otg.util.minecraft.defaults.MobNames;
import java.util.ArrayList;
import java.util.List;

public class WeightedMobSpawnGroup {
    private final String mob;
    private final int max;
    private final int weight;
    private final int min;

    public WeightedMobSpawnGroup(String mobName, int weight, int min, int max) {
        this.mob = mobName;
        this.weight = weight;
        this.min = min;
        this.max = max;
    }

    public WeightedMobSpawnGroup(MobNames mobName, int weight, int min, int max) {
        this(mobName.getInternalName(), weight, min, max);
    }

    public String getInternalName() {
        return MobNames.toInternalName(this.getMob());
    }

    public int getWeight() {
        return this.weight;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static List<WeightedMobSpawnGroup> fromJson(String originalJson) throws InvalidConfigException {
        String[] groups;
        ArrayList<WeightedMobSpawnGroup> mobGroups = new ArrayList<WeightedMobSpawnGroup>();
        String json = originalJson.trim();
        if (json.length() <= 2) {
            return mobGroups;
        }
        json = WeightedMobSpawnGroup.removeFirstAndLastChar(json);
        json = json.replace('{', '(');
        json = json.replace('}', ')');
        for (String group : groups = StringHelper.readCommaSeperatedString(json)) {
            mobGroups.add(WeightedMobSpawnGroup.readSingleGroup(group));
        }
        return mobGroups;
    }

    private static WeightedMobSpawnGroup readSingleGroup(String json) throws InvalidConfigException {
        String group = WeightedMobSpawnGroup.removeFirstAndLastChar(json.trim());
        String[] groupParts = StringHelper.readCommaSeperatedString(group);
        String mobName = null;
        int weight = -1;
        int min = -1;
        int max = -1;
        for (String option : groupParts) {
            String[] optionParts = option.split(":");
            if (optionParts.length != 2) {
                throw new InvalidConfigException("Invalid JSON structure near " + option);
            }
            String key = optionParts[0].trim();
            String value = optionParts[1].trim();
            if (key.equalsIgnoreCase("\"mob\"")) {
                mobName = WeightedMobSpawnGroup.removeFirstAndLastChar(value);
            }
            if (key.equalsIgnoreCase("\"weight\"")) {
                weight = StringHelper.readInt(value, 0, 1000);
            }
            if (key.equalsIgnoreCase("\"min\"")) {
                min = StringHelper.readInt(value, 0, 1000);
            }
            if (!key.equalsIgnoreCase("\"max\"")) continue;
            max = StringHelper.readInt(value, 0, 1000);
        }
        if (mobName == null || min == -1 || max == -1 || weight == -1) {
            throw new InvalidConfigException("Excepted mob, weight, min and max, but one or more were missing in mob group " + json);
        }
        if (min > max) {
            throw new InvalidConfigException("Minimum group size may not be larger that maximum group size for mob group " + json);
        }
        return new WeightedMobSpawnGroup(mobName, weight, min, max);
    }

    public static String toJson(List<WeightedMobSpawnGroup> list) {
        StringBuilder json = new StringBuilder("[");
        for (WeightedMobSpawnGroup group : list) {
            group.toJson(json);
            json.append(", ");
        }
        if (json.length() != 1) {
            json.deleteCharAt(json.length() - 1);
            json.deleteCharAt(json.length() - 1);
        }
        json.append(']');
        return json.toString();
    }

    private void toJson(StringBuilder json) {
        json.append("{\"mob\": \"");
        json.append(this.getInternalName());
        json.append("\", \"weight\": ");
        json.append(this.getWeight());
        json.append(", \"min\": ");
        json.append(this.getMin());
        json.append(", \"max\": ");
        json.append(this.getMax());
        json.append("}");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toJson(builder);
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.max;
        result = prime * result + this.min;
        result = prime * result + this.getMob().hashCode();
        result = prime * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedMobSpawnGroup)) {
            return false;
        }
        WeightedMobSpawnGroup other = (WeightedMobSpawnGroup)obj;
        if (this.max != other.max || this.min != other.min || this.weight != other.weight) {
            return false;
        }
        return this.getMob().equals(other.getMob());
    }

    private static String removeFirstAndLastChar(String string) {
        return string.substring(1, string.length() - 1);
    }

    public String getMob() {
        return this.mob;
    }
}

