/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.common;

import com.pg85.otg.common.BiomeIds;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.WorldSession;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.customobjects.SpawnableObject;
import com.pg85.otg.customobjects.bofunctions.EntityFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCache;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.minecraft.defaults.TreeType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

public interface LocalWorld {
    public String getName();

    public String getWorldSettingsName();

    public int getDimensionId();

    public long getSeed();

    public File getWorldSaveDir();

    public ConfigProvider getConfigs();

    public ObjectSpawner getObjectSpawner();

    public CustomStructureCache getStructureCache();

    public WorldSession getWorldSession();

    public void deleteWorldSessionData();

    public int getHeightCap();

    public int getHeightScale();

    public BiomeGenerator getBiomeGenerator();

    public LocalBiome createBiomeFor(BiomeConfig var1, BiomeIds var2, ConfigProvider var3, boolean var4);

    public int getMaxBiomesCount();

    public int getMaxSavedBiomesCount();

    public ArrayList<LocalBiome> getAllBiomes();

    public LocalBiome getBiomeByOTGIdOrNull(int var1);

    public LocalBiome getFirstBiomeOrNull();

    public LocalBiome getBiomeByNameOrNull(String var1);

    public Collection<? extends BiomeLoadInstruction> getDefaultBiomes();

    public LocalBiome getBiome(int var1, int var2) throws BiomeNotFoundException;

    public String getSavedBiomeName(int var1, int var2);

    public LocalBiome getCalculatedBiome(int var1, int var2);

    public int getRegisteredBiomeId(String var1);

    public void prepareDefaultStructures(int var1, int var2, boolean var3);

    public boolean placeDungeon(Random var1, int var2, int var3, int var4);

    public boolean placeFossil(Random var1, ChunkCoordinate var2);

    public boolean placeTree(TreeType var1, Random var2, int var3, int var4, int var5);

    public boolean placeDefaultStructures(Random var1, ChunkCoordinate var2);

    public SpawnableObject getMojangStructurePart(String var1);

    public boolean chunkHasDefaultStructure(Random var1, ChunkCoordinate var2);

    public void placePopulationMobs(LocalBiome var1, Random var2, ChunkCoordinate var3);

    public void mergeVanillaBiomeMobSpawnSettings(BiomeConfigFinder.BiomeConfigStub var1, String var2);

    public void spawnEntity(EntityFunction<?> var1);

    public void startPopulation(ChunkCoordinate var1);

    public void endPopulation();

    public LocalMaterialData getMaterial(int var1, int var2, int var3, boolean var4);

    public boolean isNullOrAir(int var1, int var2, int var3, boolean var4);

    public NamedBinaryTag getMetadata(int var1, int var2, int var3);

    public int getLiquidHeight(int var1, int var2);

    public int getSolidHeight(int var1, int var2);

    public int getHighestBlockYAt(int var1, int var2);

    public int getHighestBlockYAt(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6);

    public int getLightLevel(int var1, int var2, int var3);

    public boolean isLoaded(int var1, int var2, int var3);

    public void setBlock(int var1, int var2, int var3, LocalMaterialData var4, NamedBinaryTag var5, boolean var6);

    public LocalMaterialData[] getBlockColumn(int var1, int var2);

    public void replaceBlocks(ChunkCoordinate var1);

    public boolean isInsidePregeneratedRegion(ChunkCoordinate var1);

    public ChunkCoordinate getSpawnChunk();

    public void setAllowSpawningOutsideBounds(boolean var1);

    public boolean generateModdedCaveGen(int var1, int var2, ChunkBuffer var3);
}

