/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class EnumHelper {
    private static Object ReflectionFactory = null;
    private static Method NewConstructorAccessor = null;
    private static Method NewInstance = null;
    private static Method NewFieldAccessor = null;
    private static Method FieldAccessorSet = null;

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return NewConstructorAccessor.invoke(ReflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return (T)((Enum)enumClass.cast(NewInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{parms})));
    }

    private static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = NewFieldAccessor.invoke(ReflectionFactory, field, false);
        FieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = 4122;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            throw new RuntimeException("Could not find $VALUES field for enum " + enumType.getName());
        }
        valuesField.setAccessible(true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            T newValue = EnumHelper.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)newValue);
            EnumHelper.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            ReflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            NewConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            NewInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            NewFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            FieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

