/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.events;

import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.generator.resource.SaplingGen;
import com.pg85.otg.generator.resource.SaplingType;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.event.world.StructureGrowEvent;

class SaplingListener {
    SaplingListener() {
    }

    void onStructureGrow(StructureGrowEvent event) {
        LocalBiome biome;
        LocalWorld world = WorldHelper.toLocalWorld(event.getWorld());
        if (world == null) {
            return;
        }
        Location location = event.getLocation();
        try {
            biome = world.getBiome(location.getBlockX(), location.getBlockZ());
        }
        catch (BiomeNotFoundException e) {
            return;
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        SaplingType saplingType = this.toSaplingType(event.getSpecies());
        if (saplingType == null && biomeConfig.inheritSaplingResource && biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0) {
            biome = world.getBiomeByNameOrNull(biomeConfig.replaceToBiomeName);
            if (biome == null) {
                return;
            }
            biomeConfig = biome.getBiomeConfig();
            saplingType = this.toSaplingType(event.getSpecies());
        }
        if (saplingType == null) {
            return;
        }
        boolean wideTrunk = saplingType.requiresFourSaplings();
        if (wideTrunk) {
            Location lowestXZ = this.searchLowestXZLocation(location.getBlockY(), event.getBlocks());
            if (lowestXZ == null) {
                return;
            }
            location = lowestXZ;
        }
        for (BlockState b : event.getBlocks()) {
            b.getBlock().setType(Material.AIR);
        }
        SaplingGen sapling = biomeConfig.getSaplingGen(saplingType);
        if (sapling == null) {
            return;
        }
        boolean success = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!sapling.growSapling(world, random, wideTrunk, location.getBlockX(), location.getBlockY(), location.getBlockZ())) continue;
            success = true;
            break;
        }
        if (success) {
            event.getBlocks().clear();
        } else {
            event.setCancelled(true);
            for (BlockState b : event.getBlocks()) {
                b.update(true, false);
            }
        }
    }

    private Location searchLowestXZLocation(int y, List<BlockState> blocks) {
        BlockState lowestXZ = null;
        for (BlockState blockState : blocks) {
            if (blockState.getY() != y || blockState.getType() != Material.LOG && blockState.getType() != Material.LOG_2) continue;
            if (lowestXZ == null) {
                lowestXZ = blockState;
                continue;
            }
            if (blockState.getX() > lowestXZ.getX() || blockState.getZ() > lowestXZ.getZ()) continue;
            lowestXZ = blockState;
        }
        if (lowestXZ == null) {
            return null;
        }
        return lowestXZ.getLocation();
    }

    private SaplingType toSaplingType(TreeType treeType) {
        switch (treeType) {
            case REDWOOD: 
            case TALL_REDWOOD: {
                return SaplingType.Redwood;
            }
            case BIRCH: 
            case TALL_BIRCH: {
                return SaplingType.Birch;
            }
            case JUNGLE: {
                return SaplingType.BigJungle;
            }
            case SMALL_JUNGLE: {
                return SaplingType.SmallJungle;
            }
            case TREE: 
            case BIG_TREE: {
                return SaplingType.Oak;
            }
            case RED_MUSHROOM: {
                return SaplingType.RedMushroom;
            }
            case BROWN_MUSHROOM: {
                return SaplingType.BrownMushroom;
            }
            case ACACIA: {
                return SaplingType.Acacia;
            }
            case DARK_OAK: {
                return SaplingType.DarkOak;
            }
            case MEGA_REDWOOD: {
                return SaplingType.HugeRedwood;
            }
        }
        return null;
    }
}

