/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.bukkit.OTGBiomeBase;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.common.BiomeIds;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.configuration.biome.BiomeConfig;
import net.minecraft.server.v1_12_R1.BiomeBase;
import net.minecraft.server.v1_12_R1.BlockPosition;

public class BukkitBiome
implements LocalBiome {
    private final BiomeBase biomeBase;
    private final boolean isCustom;
    private final BiomeIds biomeIds;
    private final BiomeConfig biomeConfig;

    private BukkitBiome(BiomeConfig biomeConfig, BiomeBase biome) {
        this.biomeBase = biome;
        int savedBiomeId = BiomeBase.a((BiomeBase)this.biomeBase);
        this.biomeIds = new BiomeIds(WorldHelper.getOTGBiomeId(this.biomeBase), savedBiomeId);
        this.biomeConfig = biomeConfig;
        this.isCustom = biome instanceof OTGBiomeBase;
    }

    static BukkitBiome forCustomBiome(BiomeConfig biomeConfig, BiomeIds biomeIds, String worldName, boolean isReload) {
        return new BukkitBiome(biomeConfig, OTGBiomeBase.createInstance(biomeConfig, biomeIds, worldName, isReload));
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    public BiomeBase getHandle() {
        return this.biomeBase;
    }

    @Override
    public String getName() {
        return this.biomeConfig.getName();
    }

    @Override
    public BiomeIds getIds() {
        return this.biomeIds;
    }

    @Override
    public float getTemperatureAt(int x, int y, int z) {
        return this.biomeBase.a(new BlockPosition(x, y, z));
    }

    @Override
    public BiomeConfig getBiomeConfig() {
        return this.biomeConfig;
    }

    public String toString() {
        return this.getName();
    }
}

