/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.item.PresserRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public class TileEntityPresser
extends TileEntity
implements ITickable {
    public short cookTime;
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEMS_CAP;
    private final ItemStackHandler itemstackhandler = new ItemStackHandler(3);
    private final RangedWrapper top = new RangedWrapper((IItemHandlerModifiable)this.itemstackhandler, 0, 1);
    private final RangedWrapper bottom = new RangedWrapper((IItemHandlerModifiable)this.itemstackhandler, 1, 3){

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }
    };

    public ItemStackHandler getInventory() {
        return this.itemstackhandler;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEMS_CAP) {
            if (facing == EnumFacing.UP) {
                return (T)this.top;
            }
            if (facing == EnumFacing.DOWN) {
                return (T)this.bottom;
            }
            if (facing != null) {
                return (T)this.top;
            }
            return (T)this.itemstackhandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        ITEMS_CAP.readNBT((Object)this.itemstackhandler, null, compound.func_74781_a("Items"));
        this.cookTime = compound.func_74765_d("CookTime");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74777_a("CookTime", this.cookTime);
        compound.func_74782_a("Items", ITEMS_CAP.writeNBT((Object)this.itemstackhandler, null));
        return super.func_189515_b(compound);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 125;
    }

    public void func_73660_a() {
        boolean needsUpdate = false;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canRun()) {
            this.cookTime = (short)(this.cookTime + 1);
            if (this.cookTime >= 125) {
                this.cookTime = 0;
                this.pressComb();
                needsUpdate = true;
            }
        } else {
            this.cookTime = 0;
        }
        if (needsUpdate != this.cookTime > 0) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    private boolean canRun() {
        if (this.itemstackhandler.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack[] results = PresserRecipes.getPressingResult(this.itemstackhandler.getStackInSlot(0));
        if (results == null) {
            return false;
        }
        if (!this.itemstackhandler.getStackInSlot(1).func_190926_b()) {
            if (!this.itemstackhandler.getStackInSlot(1).func_77969_a(results[0])) {
                return false;
            }
            if (this.itemstackhandler.getStackInSlot(1).func_190916_E() + results[0].func_190916_E() > this.itemstackhandler.getStackInSlot(1).func_77976_d()) {
                return false;
            }
        }
        if (results[1] != null && !results[1].func_190926_b() && !this.itemstackhandler.getStackInSlot(2).func_190926_b()) {
            if (!this.itemstackhandler.getStackInSlot(2).func_77969_a(results[1])) {
                return false;
            }
            if (this.itemstackhandler.getStackInSlot(2).func_190916_E() + results[1].func_190916_E() > this.itemstackhandler.getStackInSlot(2).func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    private void pressComb() {
        if (!this.canRun()) {
            return;
        }
        ItemStack[] results = PresserRecipes.getPressingResult(this.itemstackhandler.getStackInSlot(0));
        if (results == null) {
            return;
        }
        if (this.itemstackhandler.getStackInSlot(1).func_190926_b()) {
            this.itemstackhandler.setStackInSlot(1, results[0].func_77946_l());
        } else if (this.itemstackhandler.getStackInSlot(1).func_190916_E() + results[0].func_190916_E() <= results[0].func_77976_d()) {
            this.itemstackhandler.getStackInSlot(1).func_190920_e(this.itemstackhandler.getStackInSlot(1).func_190916_E() + results[0].func_190916_E());
        }
        if (!results[1].func_190926_b()) {
            if (this.itemstackhandler.getStackInSlot(2).func_190926_b()) {
                this.itemstackhandler.setStackInSlot(2, results[1].func_77946_l());
            } else if (this.itemstackhandler.getStackInSlot(2).func_77969_a(results[1])) {
                this.itemstackhandler.getStackInSlot(2).func_190920_e(this.itemstackhandler.getStackInSlot(2).func_190916_E() + results[1].func_190916_E());
            }
        }
        this.itemstackhandler.getStackInSlot(0).func_190920_e(this.itemstackhandler.getStackInSlot(0).func_190916_E() - 1);
        if (this.itemstackhandler.getStackInSlot(0).func_190916_E() <= 0) {
            this.itemstackhandler.getStackInSlot(0).func_190926_b();
        }
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public String getGuiID() {
        return "harvestcraft:presser";
    }
}

