/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSlime;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class BlockSlimeSapling
extends BlockSapling {
    public static PropertyEnum<BlockSlimeGrass.FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

    public BlockSlimeSapling() {
        this.func_149647_a((CreativeTabs)TinkerRegistry.tabWorld);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (BlockSlimeGrass.FoliageType type : BlockSlimeGrass.FoliageType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= BlockSlimeGrass.FoliageType.values().length) {
            meta = 0;
        }
        BlockSlimeGrass.FoliageType grass = BlockSlimeGrass.FoliageType.values()[meta];
        return this.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)grass));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockSlimeGrass.FoliageType)((Object)state.func_177229_b(BlockSlimeGrass.FOLIAGE))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_176200_f(IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block ground = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return TinkerWorld.slimePlantType;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BlockSlime.SlimeType slimeType = BlockSlime.SlimeType.GREEN;
        if (state.func_177229_b(FOLIAGE) == BlockSlimeGrass.FoliageType.ORANGE) {
            slimeType = BlockSlime.SlimeType.MAGMA;
        }
        IBlockState slimeGreen = TinkerCommons.blockSlimeCongealed.func_176223_P().func_177226_a(BlockSlime.TYPE, (Comparable)((Object)slimeType));
        IBlockState leaves = TinkerWorld.slimeLeaves.func_176223_P().func_177226_a(BlockSlimeGrass.FOLIAGE, state.func_177229_b(FOLIAGE));
        SlimeTreeGenerator gen = new SlimeTreeGenerator(5, 4, slimeGreen, leaves, null);
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }
}

