/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import slimeknights.mantle.block.BlockStairsBase;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.block.EnumBlockSlab;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.mantle.item.ItemBlockSlab;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.Util;

public abstract class TinkerPulse {
    protected static boolean isToolsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerTools");
    }

    protected static boolean isSmelteryLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
    }

    protected static boolean isWorldLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerWorld");
    }

    protected static boolean isGadgetsLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("TinkerGadgets");
    }

    protected static boolean isChiselPluginLoaded() {
        return TConstruct.pulseManager.isPulseLoaded("chiselIntegration");
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        TinkerPulse.register(registry, block, name);
        return block;
    }

    protected static <E extends Enum<E> & IStringSerializable> BlockStairsBase registerBlockStairsFrom(IForgeRegistry<Block> registry, EnumBlock<E> block, E value, String name) {
        return TinkerPulse.registerBlock(registry, new BlockStairsBase(block.func_176223_P().func_177226_a((IProperty)block.prop, value)), name);
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        TinkerPulse.register(registry, itemBlock, block.getRegistryName());
        return block;
    }

    protected static <T extends EnumBlock<?>> T registerEnumItemBlock(IForgeRegistry<Item> registry, T block) {
        ItemBlockMeta itemBlock = new ItemBlockMeta(block);
        itemBlock.func_77655_b(block.func_149739_a());
        TinkerPulse.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Block> T registerItemBlock(IForgeRegistry<Item> registry, ItemBlock itemBlock) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        TinkerPulse.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends Block> T registerItemBlockProp(IForgeRegistry<Item> registry, ItemBlock itemBlock, IProperty<?> property) {
        itemBlock.func_77655_b(itemBlock.func_179223_d().func_149739_a());
        TinkerPulse.register(registry, itemBlock, itemBlock.func_179223_d().getRegistryName());
        ItemBlockMeta.setMappingProperty((Block)itemBlock.func_179223_d(), property);
        return (T)itemBlock.func_179223_d();
    }

    protected static <T extends EnumBlockSlab<?>> T registerEnumItemBlockSlab(IForgeRegistry<Item> registry, T block) {
        ItemBlockSlab itemBlock = new ItemBlockSlab(block);
        itemBlock.func_77655_b(block.func_149739_a());
        TinkerPulse.register(registry, itemBlock, block.getRegistryName());
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    protected static <T extends Item> T registerItem(IForgeRegistry<Item> registry, T item, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Item: %s", name));
        }
        item.func_77655_b(Util.prefix(name));
        item.setRegistryName(Util.getResource(name));
        registry.register(item);
        return item;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        registry.register(thing);
        return thing;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, ResourceLocation name) {
        thing.setRegistryName(name);
        registry.register(thing);
        return thing;
    }

    protected static void registerTE(Class<? extends TileEntity> teClazz, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! TE: %s", name));
        }
        GameRegistry.registerTileEntity(teClazz, (String)Util.prefix(name));
    }
}

