/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.packets;

import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.igcm.IGCM;
import com.creativemd.igcm.IGCMConfig;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigTab;
import com.creativemd.igcm.client.gui.SubGuiConfigSegement;
import com.creativemd.igcm.jei.JEIHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BranchInformationPacket
extends CreativeCorePacket {
    public ConfigBranch branch;

    public BranchInformationPacket() {
    }

    public BranchInformationPacket(ConfigBranch branch) {
        this.branch = branch;
    }

    public void writeBytes(ByteBuf buf) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        this.branch.onPacketSend(side);
        BranchInformationPacket.writeString((ByteBuf)buf, (String)this.branch.getPath());
        NBTTagCompound nbt = new NBTTagCompound();
        this.branch.save(nbt);
        BranchInformationPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.branch = (ConfigBranch)ConfigTab.getSegmentByPath(BranchInformationPacket.readString((ByteBuf)buf));
        this.branch.onBeforeReceived(FMLCommonHandler.instance().getEffectiveSide());
        this.branch.load(BranchInformationPacket.readNBT((ByteBuf)buf));
    }

    public void receiveUpdate(Side side) {
        this.branch.onRecieveFromPre(side);
        this.branch.onRecieveFrom(side);
        this.branch.onRecieveFromPost(side);
        if (side == Side.CLIENT && JEIHandler.isActive) {
            this.branch.updateJEI();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        this.receiveUpdate(Side.CLIENT);
        if (player != null && player.field_71070_bA instanceof ContainerSub && ((ContainerSub)player.field_71070_bA).gui.getTopLayer() instanceof SubGuiConfigSegement) {
            SubGuiConfigSegement gui = (SubGuiConfigSegement)((ContainerSub)player.field_71070_bA).gui.getTopLayer();
            if (gui.element == this.branch) {
                double scrolled = ((GuiScrollBox)gui.get((String)"scrollbox")).scrolled.aimed();
                gui.createSegmentControls(true);
                GuiScrollBox box = (GuiScrollBox)gui.get("scrollbox");
                box.scrolled.setStart(scrolled);
                if (box.scrolled.aimed() > (double)box.maxScroll) {
                    box.scrolled.setStart((double)box.maxScroll);
                }
            }
        }
    }

    public void executeServer(EntityPlayer player) {
        if (IGCM.gui.func_184882_a(player.func_184102_h(), (ICommandSender)player)) {
            this.receiveUpdate(Side.SERVER);
            IGCM.sendUpdatePacket(this.branch);
            IGCMConfig.saveConfig();
            this.branch.onUpdateSendToClient(player);
        } else {
            IGCM.sendUpdatePacket(this.branch, player);
        }
    }
}

