/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.machines;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.recipe.BetterShapedRecipe;
import com.creativemd.creativecore.common.recipe.BetterShapelessRecipe;
import com.creativemd.creativecore.common.recipe.RecipeLoader;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.jei.JEIHandler;
import com.google.common.collect.BiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WorkbenchMachine
extends RecipeMachine<IRecipe> {
    ForgeRegistry<IRecipe> registry = (ForgeRegistry)GameRegistry.findRegistry(IRecipe.class);
    private static Field owners = ReflectionHelper.findField(ForgeRegistry.class, (String[])new String[]{"owners"});
    private List<RecipeBookCache> cachesServer;
    @SideOnly(value=Side.CLIENT)
    private RecipeBookCache cacheClient;
    public static final Field recipePlayer = ReflectionHelper.findField(RecipeBook.class, (String[])new String[]{"recipes", "field_194077_a"});
    public static final Field newRecipePlayer = ReflectionHelper.findField(RecipeBook.class, (String[])new String[]{"newRecipes", "field_194078_b"});

    public WorkbenchMachine(String id, String title, ItemStack avatar) {
        super(id, title, avatar);
    }

    @Override
    public int getWidth() {
        return 3;
    }

    @Override
    public int getHeight() {
        return 3;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addEmpty() {
        for (CreativeTabs tab : CreativeTabs.field_78032_a) {
            RecipeList recipelist = new RecipeList();
            RecipeBookClient.field_194087_f.add(recipelist);
            RecipeBookClient.field_194086_e.computeIfAbsent(tab, p_194083_0_ -> new ArrayList()).add(recipelist);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveClient() {
        if (this.cacheClient != null) {
            this.cacheClient.updateBook();
        }
        this.cacheClient = null;
        FMLCommonHandler.instance().resetClientRecipeBook();
        WorkbenchMachine.addEmpty();
    }

    @Override
    public void onReceiveFrom(Side side) {
        super.onReceiveFrom(side);
        if (side.isClient()) {
            this.receiveClient();
        } else {
            if (FMLCommonHandler.instance().getMinecraftServerInstance().func_71264_H()) {
                this.receiveClient();
            }
            for (RecipeBookCache cache : this.cachesServer) {
                cache.updateBook();
            }
            this.cachesServer = null;
        }
        this.registry.freeze();
    }

    @Override
    public void addRecipeToList(Side side, IRecipe recipe) {
        this.registry.register((IForgeRegistryEntry)recipe);
    }

    @SideOnly(value=Side.CLIENT)
    public void setupCacheClient() {
        this.cacheClient = new RecipeBookCache((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public void clearRecipeList(Side side) {
        if (side.isClient()) {
            this.setupCacheClient();
        } else {
            this.cachesServer = new ArrayList<RecipeBookCache>();
            for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                this.cachesServer.add(new RecipeBookCache((EntityPlayer)player));
            }
        }
        this.registry.unfreeze();
        this.registry.clear();
        try {
            ((BiMap)owners.get(this.registry)).clear();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String recipeToString(IRecipe recipe) {
        return recipe.getRegistryName().toString();
    }

    @Override
    public ItemStack[] getOutput(IRecipe recipe) {
        return new ItemStack[]{recipe.func_77571_b()};
    }

    @Override
    public List<IRecipe> getAllExitingRecipes() {
        return this.registry.getValues();
    }

    public void getInput(ItemStack[] grid, Object[] items, int width, int height) {
        if (items == null) {
            return;
        }
        for (int zahl = 0; zahl < width * height; ++zahl) {
            int row = zahl / height;
            int index = row * 3 + zahl - row * width;
            if (items.length <= zahl || index >= 9 || index <= -1) continue;
            grid[index] = this.getItemStack(items[zahl]);
        }
    }

    public ItemStack getItemStack(Object object) {
        ItemStack[] result = this.ObjectoItemStack(object);
        ItemStack stack = null;
        if (result.length > 0) {
            stack = result[result.length - 1];
        }
        if (stack != null) {
            stack.func_190920_e(1);
        }
        return stack;
    }

    public ItemStack[] ObjectoItemStack(Object object) {
        try {
            if (object instanceof Item) {
                return new ItemStack[]{new ItemStack((Item)object)};
            }
            if (object instanceof Block) {
                return new ItemStack[]{new ItemStack((Block)object)};
            }
            if (object instanceof ItemStack) {
                ItemStack stack = ((ItemStack)object).func_77946_l();
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
                return new ItemStack[]{stack};
            }
            if (object instanceof List) {
                List stacks = (List)object;
                ItemStack[] result = new ItemStack[stacks.size()];
                for (int zahl = 0; zahl < stacks.size(); ++zahl) {
                    if (!(stacks.get(zahl) instanceof ItemStack)) continue;
                    ItemStack stack = ((ItemStack)stacks.get(zahl)).func_77946_l();
                    if (stack.func_77952_i() == Short.MAX_VALUE) {
                        stack.func_77964_b(0);
                    }
                    result[zahl] = stack;
                }
                return result;
            }
            if (object instanceof Ingredient) {
                return ((Ingredient)object).func_193365_a();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ItemStack[0];
    }

    @Override
    public void fillGrid(ItemStack[] grid, IRecipe recipe) {
        int[] size = RecipeLoader.getRecipeDimensions((IRecipe)recipe);
        this.getInput(grid, RecipeLoader.getInput((IRecipe)recipe), size[0], size[1]);
    }

    @Override
    public boolean doesSupportStackSize() {
        return false;
    }

    @Override
    public void fillGridInfo(InfoStack[] grid, IRecipe recipe) {
        block3: {
            block2: {
                if (!(recipe instanceof BetterShapedRecipe)) break block2;
                for (int i = 0; i < ((BetterShapedRecipe)recipe).info.length; ++i) {
                    int row = i / ((BetterShapedRecipe)recipe).getWidth();
                    int index = row * 3 + (i - row * ((BetterShapedRecipe)recipe).getWidth());
                    grid[index] = ((BetterShapedRecipe)recipe).info[i];
                }
                break block3;
            }
            if (!(recipe instanceof BetterShapelessRecipe)) break block3;
            for (int i = 0; i < ((BetterShapelessRecipe)recipe).info.size(); ++i) {
                grid[i] = (InfoStack)((BetterShapelessRecipe)recipe).info.get(i);
            }
        }
    }

    @Override
    public IRecipe parseRecipe(InfoStack[] input, ItemStack[] output, NBTTagCompound nbt, int width, int height) {
        if (output.length == 1 && output[0] != null) {
            BetterShapedRecipe recipe = null;
            ItemStack result = output[0].func_77946_l();
            if (nbt.func_74767_n("shaped")) {
                recipe = new BetterShapedRecipe(width, input, result);
            } else {
                ArrayList<InfoStack> info = new ArrayList<InfoStack>();
                for (int i = 0; i < input.length; ++i) {
                    if (input[i] == null) continue;
                    info.add(input[i]);
                }
                if (info.size() > 0) {
                    recipe = new BetterShapelessRecipe(info, result);
                }
            }
            if (recipe != null) {
                if (nbt.func_74764_b("location")) {
                    recipe.setRegistryName(new ResourceLocation(nbt.func_74779_i("location")));
                }
                return recipe;
            }
        }
        return null;
    }

    private boolean containsName(List<AddRecipeSegment> segments, ResourceLocation location) {
        for (int i = 0; i < segments.size(); ++i) {
            if (((IRecipe)segments.get((int)i).value).getRegistryName() == null || !((IRecipe)segments.get((int)i).value).getRegistryName().equals((Object)location)) continue;
            return true;
        }
        return false;
    }

    private ResourceLocation findNextName(List<AddRecipeSegment> segments) {
        int i = 0;
        ResourceLocation location = new ResourceLocation("igcm", "added" + i);
        while (this.containsName(segments, location)) {
            location = new ResourceLocation("igcm", "added" + ++i);
        }
        return location;
    }

    @Override
    public void onRecipeParsed(List<AddRecipeSegment> segments) {
        for (int i = 0; i < segments.size(); ++i) {
            if (((IRecipe)segments.get((int)i).value).getRegistryName() != null) continue;
            ((IRecipe)segments.get((int)i).value).setRegistryName(this.findNextName(segments));
        }
    }

    @Override
    public void writeExtraInfo(IRecipe recipe, NBTTagCompound nbt) {
        nbt.func_74778_a("location", recipe.getRegistryName().toString());
        nbt.func_74757_a("shaped", recipe instanceof BetterShapedRecipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void parseExtraInfo(NBTTagCompound nbt, AddRecipeSegment segment, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        for (int i = 0; i < guiControls.size(); ++i) {
            if (!guiControls.get(i).is(new String[]{"type"})) continue;
            nbt.func_74757_a("shaped", ((GuiStateButton)guiControls.get(i)).getState() == 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onControlCreated(IRecipe recipe, boolean isAdded, int x, int y, int maxWidth, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        if (isAdded) {
            guiControls.add((GuiControl)new GuiStateButton("type", recipe instanceof BetterShapelessRecipe ? 1 : 0, x + maxWidth - 80, y + 30, 70, 14, new String[]{"Shaped", "Shapeless"}));
        }
    }

    @Override
    public boolean hasJEISupport() {
        return true;
    }

    @Override
    public String getJEICategory() {
        return "minecraft.crafting";
    }

    @Override
    @Optional.Method(modid="jei")
    public List getJEIRecipes() {
        return this.registry.getValues();
    }

    @Override
    @Optional.Method(modid="jei")
    public void updateJEI() {
        super.updateJEI();
        if (JEIHandler.isSilentGemInstalled()) {
            for (IRecipe recipe : this.registry) {
                if (!recipe.getRegistryName().func_110624_b().equals("silentgems")) continue;
                JEIHandler.addSilentGemRecipes();
                break;
            }
        }
    }

    @Override
    public void onUpdateSendToClient(EntityPlayer player) {
    }

    public class RecipeBookCache {
        public List<IRecipe> recipes = new ArrayList<IRecipe>();
        public List<IRecipe> newRecipes = new ArrayList<IRecipe>();
        public EntityPlayer player;

        public RecipeBookCache(EntityPlayer player) {
            this.player = player;
            try {
                Object book = player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).func_192037_E() : ((EntityPlayerSP)player).func_192035_E();
                ArrayList<IRecipe> toDelete = new ArrayList<IRecipe>();
                BitSet recipesBook = (BitSet)recipePlayer.get(book);
                for (int i = 0; i < recipesBook.size(); ++i) {
                    if (!recipesBook.get(i)) continue;
                    IRecipe recipe = (IRecipe)WorkbenchMachine.this.registry.getValue(i);
                    this.recipes.add(recipe);
                    toDelete.add(recipe);
                }
                BitSet newRecipesBook = (BitSet)newRecipePlayer.get(book);
                for (int i = 0; i < newRecipesBook.size(); ++i) {
                    if (!newRecipesBook.get(i)) continue;
                    this.newRecipes.add((IRecipe)WorkbenchMachine.this.registry.getValue(i));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }

        public void updateBook() {
            Object book = this.player instanceof EntityPlayerMP ? ((EntityPlayerMP)this.player).func_192037_E() : ((EntityPlayerSP)this.player).func_192035_E();
            try {
                ((BitSet)recipePlayer.get(book)).clear();
                ((BitSet)newRecipePlayer.get(book)).clear();
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            for (IRecipe recipe : this.recipes) {
                if (CraftingManager.field_193380_a.func_148757_b((Object)recipe) == -1) continue;
                book.func_194073_a(recipe);
            }
            for (IRecipe recipe : this.newRecipes) {
                if (CraftingManager.field_193380_a.func_148757_b((Object)recipe) == -1) continue;
                book.func_193825_e(recipe);
            }
        }
    }
}

