/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.machines;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.jei.JEIHandler;
import com.creativemd.igcm.machines.FurnaceRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.plugins.vanilla.furnace.SmeltingRecipeMaker;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FurnaceMachine
extends RecipeMachine<FurnaceRecipe> {
    public FurnaceMachine(String id, String title, ItemStack avatar) {
        super(id, title, avatar);
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @Override
    public void addRecipeToList(Side side, FurnaceRecipe recipe) {
        InfoStack info = recipe.input[0];
        ItemStack output = recipe.output[0];
        if (info != null && output != null) {
            if (info instanceof InfoBlock) {
                FurnaceRecipes.func_77602_a().func_151393_a(((InfoBlock)info).block, output, recipe.experience);
            } else if (info instanceof InfoItem) {
                FurnaceRecipes.func_77602_a().func_151396_a(((InfoItem)info).item, output, recipe.experience);
            } else if (info instanceof InfoItemStack) {
                FurnaceRecipes.func_77602_a().func_151394_a(((InfoItemStack)info).stack.func_77946_l(), output, recipe.experience);
            } else {
                ArrayList stacks = info.getAllPossibleItemStacks();
                for (int i = 0; i < stacks.size(); ++i) {
                    FurnaceRecipes.func_77602_a().func_151394_a(((ItemStack)stacks.get(i)).func_77946_l(), output, recipe.experience);
                }
            }
        }
    }

    @Override
    public void clearRecipeList(Side side) {
        FurnaceRecipes.func_77602_a().func_77599_b().clear();
    }

    @Override
    public ItemStack[] getOutput(FurnaceRecipe recipe) {
        return recipe.output;
    }

    @Override
    public ArrayList<FurnaceRecipe> getAllExitingRecipes() {
        ArrayList<FurnaceRecipe> recipes = new ArrayList<FurnaceRecipe>();
        for (Map.Entry recipe : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            recipes.add(new FurnaceRecipe((ItemStack)recipe.getValue(), recipe.getKey(), FurnaceRecipes.func_77602_a().func_151398_b((ItemStack)recipe.getValue())));
        }
        return recipes;
    }

    @Override
    public void fillGrid(ItemStack[] grid, FurnaceRecipe recipe) {
        if (recipe.input[0] != null) {
            grid[0] = recipe.input[0].getItemStack();
        }
    }

    @Override
    public void fillGridInfo(InfoStack[] grid, FurnaceRecipe recipe) {
        grid[0] = recipe.input[0];
    }

    @Override
    public FurnaceRecipe parseRecipe(InfoStack[] input, ItemStack[] output, NBTTagCompound nbt, int width, int height) {
        if (input.length == 1 && input[0] != null && output.length == 1 && output[0] != null) {
            return new FurnaceRecipe(output[0], input[0], nbt.func_74760_g("exp"));
        }
        return null;
    }

    @Override
    public void writeExtraInfo(FurnaceRecipe recipe, NBTTagCompound nbt) {
        nbt.func_74776_a("exp", recipe.experience);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void parseExtraInfo(NBTTagCompound nbt, AddRecipeSegment segment, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        for (int i = 0; i < guiControls.size(); ++i) {
            if (!guiControls.get(i).is(new String[]{"exp"})) continue;
            float exp = 0.0f;
            try {
                exp = Float.parseFloat(((GuiTextfield)guiControls.get((int)i)).text);
            }
            catch (Exception e) {
                exp = 0.0f;
            }
            nbt.func_74776_a("exp", exp);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onControlCreated(FurnaceRecipe recipe, boolean isAdded, int x, int y, int maxWidth, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        if (isAdded) {
            guiControls.add((GuiControl)new GuiTextfield("exp", recipe != null ? "" + recipe.experience : "0.0", x + maxWidth - 80, y, 40, 14).setFloatOnly());
        } else {
            guiControls.add((GuiControl)new GuiLabel("exp: " + recipe.experience, x + maxWidth - 60, y));
        }
    }

    @Override
    public boolean doesSupportStackSize() {
        return false;
    }

    @Override
    public boolean hasJEISupport() {
        return true;
    }

    @Override
    public String getJEICategory() {
        return "minecraft.smelting";
    }

    @Override
    @Optional.Method(modid="jei")
    public List getJEIRecipes() {
        return SmeltingRecipeMaker.getFurnaceRecipes((IJeiHelpers)((IModRegistry)JEIHandler.modRegistry).getJeiHelpers());
    }
}

