/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.machines;

import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.api.machine.RecipeMachine;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class BrewingStandMachine
extends RecipeMachine<IBrewingRecipe> {
    private static List<IBrewingRecipe> brewingRecipes = (List)ReflectionHelper.getPrivateValue(BrewingRecipeRegistry.class, null, (String[])new String[]{"recipes"});

    public BrewingStandMachine(String id, String title, ItemStack avatar) {
        super(id, title, avatar);
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 2;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @Override
    public void addRecipeToList(Side side, IBrewingRecipe recipe) {
        brewingRecipes.add(recipe);
    }

    @Override
    public void clearRecipeList(Side side) {
        brewingRecipes.clear();
    }

    @Override
    public ItemStack[] getOutput(IBrewingRecipe recipe) {
        ItemStack[] output = new ItemStack[1];
        if (recipe instanceof VanillaBrewingRecipe) {
            output[0] = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185233_e);
        } else {
            try {
                output[0] = recipe.getOutput(ItemStack.field_190927_a, ItemStack.field_190927_a);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (output[0] == null) {
                output[0] = ItemStack.field_190927_a;
            }
        }
        return output;
    }

    @Override
    public List<IBrewingRecipe> getAllExitingRecipes() {
        return brewingRecipes;
    }

    @Override
    public void fillGrid(ItemStack[] grid, IBrewingRecipe recipe) {
        if (recipe instanceof VanillaBrewingRecipe) {
            grid[0] = new ItemStack(Items.field_151075_bm);
            grid[1] = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
        }
    }

    @Override
    public boolean doesSupportStackSize() {
        return true;
    }

    @Override
    public void fillGridInfo(InfoStack[] grid, IBrewingRecipe recipe) {
        if (recipe instanceof IGCMBrewingRecipe) {
            grid[0] = ((IGCMBrewingRecipe)recipe).ingredient;
            grid[1] = ((IGCMBrewingRecipe)recipe).input;
        }
    }

    @Override
    public IBrewingRecipe parseRecipe(InfoStack[] input, ItemStack[] output, NBTTagCompound nbt, int width, int height) {
        if (input.length < 2) {
            return null;
        }
        return new IGCMBrewingRecipe(input[1], input[0], output[0]);
    }

    @Override
    public boolean hasJEISupport() {
        return false;
    }

    @Override
    public String getJEICategory() {
        return null;
    }

    @Override
    public List getJEIRecipes() {
        return null;
    }

    public static class IGCMBrewingRecipe
    implements IBrewingRecipe {
        public InfoStack input;
        public InfoStack ingredient;
        public ItemStack output;

        public IGCMBrewingRecipe(InfoStack input, InfoStack ingredient, ItemStack output) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
        }

        public boolean isInput(ItemStack input) {
            return this.input.isInstance(input);
        }

        public boolean isIngredient(ItemStack ingredient) {
            return this.ingredient.isInstance(ingredient);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            return this.output;
        }
    }
}

