/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.machines;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.IGCM;
import com.creativemd.igcm.api.machine.RecipeMachine;
import com.creativemd.igcm.api.segments.BooleanSegment;
import com.creativemd.igcm.api.segments.advanced.AddRecipeSegment;
import com.creativemd.igcm.block.AdvancedGridRecipe;
import com.creativemd.igcm.block.BlockAdvancedWorkbench;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AdvancedWorkbench
extends RecipeMachine<AdvancedGridRecipe> {
    public AdvancedWorkbench(String id, String title, ItemStack avatar) {
        super(id, title, avatar);
    }

    @Override
    public int getWidth() {
        return 6;
    }

    @Override
    public int getHeight() {
        return 6;
    }

    @Override
    public int getOutputCount() {
        return 4;
    }

    @Override
    public boolean hasDisableBranch() {
        return false;
    }

    @Override
    public void addRecipeToList(Side side, AdvancedGridRecipe recipe) {
        BlockAdvancedWorkbench.recipes.add(recipe);
    }

    @Override
    public void clearRecipeList(Side side) {
        BlockAdvancedWorkbench.recipes.clear();
    }

    @Override
    public ItemStack[] getOutput(AdvancedGridRecipe recipe) {
        return recipe.output;
    }

    @Override
    public ArrayList<AdvancedGridRecipe> getAllExitingRecipes() {
        return BlockAdvancedWorkbench.recipes;
    }

    @Override
    public void fillGrid(ItemStack[] grid, AdvancedGridRecipe recipe) {
    }

    @Override
    public void fillGridInfo(InfoStack[] grid, AdvancedGridRecipe recipe) {
        for (int i = 0; i < recipe.input.length; ++i) {
            int row = i / recipe.width;
            int index = row * this.getWidth() + (i - row * recipe.width);
            grid[index] = recipe.input[i];
        }
    }

    @Override
    public AdvancedGridRecipe parseRecipe(InfoStack[] input, ItemStack[] output, NBTTagCompound nbt, int width, int height) {
        if (input.length > 0 && output.length > 0) {
            return new AdvancedGridRecipe(output, width, height, input, nbt.func_74762_e("duration"));
        }
        return null;
    }

    @Override
    public void writeExtraInfo(AdvancedGridRecipe recipe, NBTTagCompound nbt) {
        nbt.func_74768_a("duration", recipe.duration);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void parseExtraInfo(NBTTagCompound nbt, AddRecipeSegment segment, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        for (int i = 0; i < guiControls.size(); ++i) {
            if (!guiControls.get(i).is(new String[]{"duration"})) continue;
            int duration = 0;
            try {
                duration = Integer.parseInt(((GuiTextfield)guiControls.get((int)i)).text);
            }
            catch (Exception e) {
                duration = 0;
            }
            nbt.func_74768_a("duration", duration);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onControlCreated(AdvancedGridRecipe recipe, boolean isAdded, int x, int y, int maxWidth, ArrayList<GuiControl> guiControls, ArrayList<ContainerControl> containerControls) {
        if (isAdded) {
            guiControls.add((GuiControl)new GuiTextfield("duration", recipe != null ? "" + recipe.duration : "0", x + maxWidth - 80, y + 40, 70, 14).setNumbersOnly());
        }
    }

    @Override
    public boolean doesSupportStackSize() {
        return true;
    }

    @Override
    public boolean hasJEISupport() {
        return true;
    }

    @Override
    public String getJEICategory() {
        return "igcm.advcrafting";
    }

    @Override
    public List getJEIRecipes() {
        return BlockAdvancedWorkbench.recipes;
    }

    @Override
    public void createExtraSegments() {
        this.mainBranch.registerElement("overrideWorkbench", new BooleanSegment("Override default workbench", false));
    }

    @Override
    public void onReceiveFrom(Side side) {
        IGCM.overrideWorkbench = (Boolean)this.mainBranch.getValue("overrideWorkbench");
    }
}

