/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.jei;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.MultiMap;
import mezz.jei.collect.Table;
import mezz.jei.recipes.RecipeMap;
import mezz.jei.recipes.RecipeRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class JEIHandler {
    public static boolean isActive = false;
    public static Field plugins;
    public static Field starter;
    public static Object modRegistry;
    public static Object recipeRegistry;
    private static Field hiddenRecipesField;
    private static Field wrapperMapsField;
    private static Field recipeInputMapField;
    private static Field recipeOutputMapField;
    private static Field recipeWrapperTableField;
    private static Field categoryUidMapField;
    private static Field recipeWrappersForCategoriesField;
    private static Field recipeCategoriesVisibleCacheField;
    private static Field mapMultiMapField;
    private static Field tableField;
    private static boolean silentGemRecipes;
    private static Field exampleRecipes;

    private static void loadReflections() {
        if (hiddenRecipesField == null) {
            hiddenRecipesField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"hiddenRecipes"});
            wrapperMapsField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"wrapperMaps"});
            recipeInputMapField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"recipeInputMap"});
            recipeOutputMapField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"recipeOutputMap"});
            recipeWrapperTableField = ReflectionHelper.findField(RecipeMap.class, (String[])new String[]{"recipeWrapperTable"});
            categoryUidMapField = ReflectionHelper.findField(RecipeMap.class, (String[])new String[]{"categoryUidMap"});
            recipeWrappersForCategoriesField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"recipeWrappersForCategories"});
            recipeCategoriesVisibleCacheField = ReflectionHelper.findField(RecipeRegistry.class, (String[])new String[]{"recipeCategoriesVisibleCache"});
            mapMultiMapField = ReflectionHelper.findField(MultiMap.class, (String[])new String[]{"map"});
            tableField = ReflectionHelper.findField(Table.class, (String[])new String[]{"table"});
        }
    }

    private static void clearMultiMap(Object multimap, Object key) {
        try {
            ((Map)mapMultiMapField.get(multimap)).remove(key);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static void clearTable(Object table, Object key) {
        try {
            ((Map)tableField.get(table)).remove(key);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void clearCategory(String categoryId) {
        JEIHandler.loadReflections();
        try {
            IRecipeCategory category = ((IRecipeRegistry)recipeRegistry).getRecipeCategory(categoryId);
            if (category == null) {
                return;
            }
            JEIHandler.clearMultiMap(hiddenRecipesField.get(recipeRegistry), categoryId);
            JEIHandler.clearTable(wrapperMapsField.get(recipeRegistry), categoryId);
            RecipeMap recipeInputMap = (RecipeMap)recipeInputMapField.get(recipeRegistry);
            JEIHandler.clearTable(recipeWrapperTableField.get(recipeInputMap), category);
            Iterator iterator = ((ListMultiMap)categoryUidMapField.get(recipeInputMap)).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                ((List)entry.getValue()).remove(categoryId);
                if (!((List)entry.getValue()).isEmpty()) continue;
                iterator.remove();
            }
            RecipeMap recipeOutputMap = (RecipeMap)recipeOutputMapField.get(recipeRegistry);
            JEIHandler.clearTable(recipeWrapperTableField.get(recipeOutputMap), category);
            Iterator iterator2 = ((ListMultiMap)categoryUidMapField.get(recipeOutputMap)).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                ((List)entry.getValue()).remove(categoryId);
                if (!((List)entry.getValue()).isEmpty()) continue;
                iterator2.remove();
            }
            JEIHandler.clearMultiMap(recipeWrappersForCategoriesField.get(recipeRegistry), category);
            ((List)recipeCategoriesVisibleCacheField.get(recipeRegistry)).clear();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSilentGemInstalled() {
        if (!silentGemRecipes) {
            try {
                Class<?> toolHelperClass = Class.forName("net.silentchaos512.gems.util.ToolHelper");
                if (toolHelperClass != null) {
                    exampleRecipes = ReflectionHelper.findField(toolHelperClass, (String[])new String[]{"EXAMPLE_RECIPES"});
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            silentGemRecipes = true;
        }
        return exampleRecipes != null;
    }

    public static void addSilentGemRecipes() {
        try {
            ((IModRegistry)modRegistry).addRecipes((Collection)exampleRecipes.get(null), "minecraft.crafting");
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    static {
        silentGemRecipes = false;
        exampleRecipes = null;
    }
}

