/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.jei;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.container.client.GuiSlotControl;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class AdvCraftingRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    public static final String CategoryUiD = "igcm.advcrafting";
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 4;
    public static final int width = 116;
    public static final int height = 54;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    private final String localizedName;
    @Nonnull
    private final ICraftingGridHelper craftingGridHelper;

    public AdvCraftingRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/gui/container/crafting_table.png");
        this.background = new IDrawable(){

            public int getWidth() {
                return 180;
            }

            public int getHeight() {
                return 180;
            }

            public void draw(Minecraft minecraft, int xOffset, int yOffset) {
                GlStateManager.func_179109_b((float)xOffset, (float)yOffset, (float)0.0f);
                this.draw(minecraft);
            }

            public void draw(Minecraft minecraft) {
                int borderWidth = 1;
                Style style = GuiSlotControl.slotStyle;
                int width = 18;
                int height = 18;
                for (int y = 0; y < 6; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)(x * 18), (float)(y * 18), (float)0.0f);
                        style.getBorder(null).renderStyle(GuiRenderHelper.instance, width, height);
                        GlStateManager.func_179109_b((float)borderWidth, (float)borderWidth, (float)0.0f);
                        style.getBackground(null).renderStyle(GuiRenderHelper.instance, width - borderWidth * 2, height - borderWidth * 2);
                        GlStateManager.func_179121_F();
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)120.0f, (float)(18 + i * 18), (float)0.0f);
                    style.getBorder(null).renderStyle(GuiRenderHelper.instance, width, height);
                    GlStateManager.func_179109_b((float)borderWidth, (float)borderWidth, (float)0.0f);
                    style.getBackground(null).renderStyle(GuiRenderHelper.instance, width - borderWidth * 2, height - borderWidth * 2);
                    GlStateManager.func_179121_F();
                }
            }
        };
        this.localizedName = Translator.translateToLocal((String)"Advanced Crafting Table");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(4, 0);
    }

    @Nonnull
    public String getUid() {
        return CategoryUiD;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        for (int i = 0; i < 4; ++i) {
            guiItemStacks.init(0 + i, false, 120, 18 + i * 18);
        }
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 6; ++x) {
                int index = 4 + x + y * 6;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
    }

    public String getModName() {
        return "igcm";
    }
}

