/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.command;

import java.util.HashMap;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;

public abstract class CommandParser<T> {
    private static HashMap<Class, CommandParser> parsers = new HashMap();

    public static <T> void registerParser(Class<T> clazz, CommandParser<T> parser) {
        parsers.put(clazz, parser);
    }

    public static boolean canParseObject(Class clazz) {
        return parsers.containsKey(clazz);
    }

    public static <T> String printObject(T input) {
        CommandParser parser = parsers.get(input.getClass());
        if (parser != null) {
            return parser.print(input);
        }
        return "";
    }

    public static <T> T parseObject(String input, Class<T> clazz) throws CommandException {
        CommandParser parser = parsers.get(clazz);
        if (parser != null) {
            return parser.parse(input);
        }
        throw new CommandException("No parser found!", new Object[]{clazz});
    }

    public abstract T parse(String var1) throws CommandException;

    public abstract String print(T var1);

    static {
        CommandParser.registerParser(Boolean.class, new CommandParser<Boolean>(){

            @Override
            public String print(Boolean input) {
                if (input.booleanValue()) {
                    return "true";
                }
                return "false";
            }

            @Override
            public Boolean parse(String input) throws CommandException {
                return CommandBase.func_180527_d((String)input);
            }
        });
        CommandParser.registerParser(Integer.class, new CommandParser<Integer>(){

            @Override
            public Integer parse(String input) throws CommandException {
                return CommandBase.func_175755_a((String)input);
            }

            @Override
            public String print(Integer input) {
                return input.toString();
            }
        });
        CommandParser.registerParser(Float.class, new CommandParser<Float>(){

            @Override
            public Float parse(String input) throws CommandException {
                return Float.valueOf((float)CommandBase.func_175765_c((String)input));
            }

            @Override
            public String print(Float input) {
                return input.toString();
            }
        });
        CommandParser.registerParser(Double.class, new CommandParser<Double>(){

            @Override
            public Double parse(String input) throws CommandException {
                return CommandBase.func_175765_c((String)input);
            }

            @Override
            public String print(Double input) {
                return input.toString();
            }
        });
        CommandParser.registerParser(String.class, new CommandParser<String>(){

            @Override
            public String parse(String input) throws CommandException {
                return input;
            }

            @Override
            public String print(String input) {
                return input;
            }
        });
    }
}

