/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.client.gui;

import com.creativemd.creativecore.client.avatar.Avatar;
import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAvatarLabelClickable;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiToolTipEvent;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import com.creativemd.igcm.client.gui.GuiInfoHandler;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiFullItemDialog
extends SubGui {
    public static ArrayList<InfoStack> latest = new ArrayList();
    public InfoStack info;
    public boolean supportStackSize;
    public GuiInfoHandler handler;

    public SubGuiFullItemDialog(boolean supportStackSize) {
        super(150, 230);
        this.supportStackSize = supportStackSize;
    }

    public void createControls() {
        this.handler = GuiInfoHandler.getHandler(this.info);
        GuiComboBox box = (GuiComboBox)this.get("type");
        if (box != null) {
            this.handler = GuiInfoHandler.getHandler(box.caption);
        }
        this.controls.clear();
        ArrayList<String> lines = new ArrayList<String>(GuiInfoHandler.getNames());
        box = new GuiComboBox("type", 0, 0, 144, lines);
        box.caption = this.handler.getName();
        box.index = lines.indexOf(this.handler.getName());
        this.controls.add(box);
        this.handler.createControls(this, this.info);
        if (this.supportStackSize) {
            this.controls.add(new GuiLabel("StackSize:", 5, 210));
            GuiTextfield field = new GuiTextfield("stacksize", "1", 110, 208, 30, 14).setNumbersOnly();
            if (this.info != null) {
                field.text = "" + this.info.stackSize;
            }
            this.controls.add(field);
        }
        GuiScrollBox scroll = new GuiScrollBox("latest", 0, 155, 144, this.supportStackSize ? 45 : 65);
        int latestPerRow = 4;
        for (int i = 0; i < latest.size(); ++i) {
            int row = i / latestPerRow;
            int cell = i - row * latestPerRow;
            GuiAvatarLabelClickable avatar = new GuiAvatarLabelClickable("" + i, cell * 32, row * 18, -1, (Avatar)new AvatarItemStack(latest.get(i).getItemStack())){

                public void onClicked(int x, int y, int button) {
                    SubGuiFullItemDialog.this.info = latest.get(Integer.parseInt(this.name));
                    SubGuiFullItemDialog.this.closeLayer(new NBTTagCompound());
                }
            };
            scroll.addControl((GuiControl)avatar);
        }
        this.controls.add(scroll);
        this.controls.add(new GuiButton("Cancel", 0, 130, 41){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiButton("Remove", 50, 130, 41){

            public void onClicked(int x, int y, int button) {
            }
        });
        this.controls.add(new GuiButton("Save", 100, 130, 41){

            public void onClicked(int x, int y, int button) {
            }
        });
    }

    @CustomEventSubscribe
    public void onClicked(GuiControlClickEvent event) {
        if (event.source.is(new String[]{"Save"})) {
            int stackSize = 0;
            try {
                stackSize = this.supportStackSize ? Integer.parseInt(((GuiTextfield)this.get((String)"stacksize")).text) : 1;
            }
            catch (Exception e) {
                stackSize = 1;
            }
            InfoStack info = this.handler.parseInfo(this, stackSize);
            if (info != null) {
                this.info = info;
                if (!latest.contains(info)) {
                    latest.add(0, info.copy());
                }
                this.closeLayer(new NBTTagCompound());
            }
        }
        if (event.source.is(new String[]{"Remove"})) {
            this.info = null;
            this.closeLayer(new NBTTagCompound());
        }
        if (event.source.is(new String[]{"Cancel"})) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("canceled", true);
            this.closeLayer(nbt);
        }
    }

    @CustomEventSubscribe
    public void onToolTip(GuiToolTipEvent event) {
        if (event.source.is(new String[]{"stacksize"})) {
            event.tooltip.add("0: no consumption");
            event.tooltip.add("1: normal");
        }
    }

    @CustomEventSubscribe
    public void onChanged(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"type"})) {
            this.createControls();
            this.refreshControls();
        } else {
            this.handler.onChanged(this, event);
        }
    }
}

