/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.igcm.client.gui;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.container.SlotControlNoSync;
import com.creativemd.creativecore.common.gui.controls.container.client.GuiSlotControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.igcm.IGCM;
import com.creativemd.igcm.IGCMGuiManager;
import com.creativemd.igcm.api.ConfigBranch;
import com.creativemd.igcm.api.ConfigSegment;
import com.creativemd.igcm.api.ConfigTab;
import com.creativemd.igcm.client.gui.SubGuiFullItemDialog;
import com.creativemd.igcm.client.gui.SubGuiItemDialog;
import com.creativemd.igcm.container.controls.InfoSlotControl;
import com.creativemd.igcm.packets.RequestInformationPacket;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SubGuiConfigSegement
extends SubGui {
    public static final int loadPerTick = 20;
    public int aimedScrollPos = -1;
    public int index;
    public int height;
    public ConfigSegment element;
    public ArrayList<ConfigSegment> childs;
    public boolean forceRecreation = true;
    public boolean isCreatingControls = false;
    public static int maxWidth = 220;
    public String search = "";
    public GuiSlotControl openedSlot;

    public SubGuiConfigSegement(ConfigSegment element) {
        super(250, 250);
        this.element = element;
    }

    public void removeSegment(ConfigSegment segment) {
        int indexOf;
        if (!this.isCreatingControls && (indexOf = this.childs.indexOf(segment)) != -1) {
            this.childs.remove(indexOf);
            GuiScrollBox box = (GuiScrollBox)this.get("scrollbox");
            box.controls.clear();
            box.maxScroll = 0;
            box.scrolled.setStart(0.0);
            if (this.get("Save") != null) {
                this.get("Save").setEnabled(false);
            }
            this.height = 5;
            this.index = 0;
            this.isCreatingControls = true;
            this.forceRecreation = false;
            this.onTick();
        }
    }

    public void createSegmentControls(boolean force) {
        this.forceRecreation = force;
        GuiScrollBox box = (GuiScrollBox)this.get("scrollbox");
        Collection segments = this.element.getChilds();
        this.aimedScrollPos = (int)box.scrolled.aimed();
        box.controls.clear();
        box.maxScroll = 0;
        box.scrolled.setStart(0.0);
        if (this.get("Save") != null) {
            this.get("Save").setEnabled(false);
        }
        this.childs = new ArrayList(segments);
        this.height = 5;
        this.index = 0;
        if (this.element instanceof ConfigBranch) {
            ((ConfigBranch)this.element).onGuiCreatesSegments(this, this.childs);
        }
        this.isCreatingControls = true;
        this.onTick();
    }

    public void onTick() {
        if (this.childs != null && (this.isCreatingControls || this.index < this.childs.size())) {
            this.isCreatingControls = true;
            GuiScrollBox box = (GuiScrollBox)this.get("scrollbox");
            int count = 0;
            int countLoaded = 0;
            String search = this.search.toLowerCase();
            for (int i = this.index; i < this.childs.size() && countLoaded < 20; ++i) {
                if (search.equals("") || this.childs.get(i).canBeFound(search)) {
                    ConfigSegment child = this.childs.get(i);
                    int x = 0;
                    int y = this.height;
                    if (this.forceRecreation || child.getGuiControls() == null) {
                        int j;
                        ArrayList<GuiControl> guiControls = child.createGuiControls(this, x, y, maxWidth);
                        ArrayList<ContainerControl> containerControls = child.createContainerControls(this.container, x, y, maxWidth);
                        child.setGuiControls(guiControls);
                        child.setContainerControls(containerControls);
                        child.onSegmentLoaded(x, y, maxWidth);
                        for (j = 0; j < guiControls.size(); ++j) {
                            box.addControl(guiControls.get(j));
                        }
                        for (j = 0; j < containerControls.size(); ++j) {
                            containerControls.get((int)j).parent = this.container;
                            GuiControl control = containerControls.get(j).getGuiControl();
                            box.addControl(control);
                            child.getGuiControls().add(control);
                        }
                        if (this.element instanceof ConfigBranch) {
                            ((ConfigBranch)this.element).onGuiLoadSegment(this, box, this.childs, child);
                        }
                    } else {
                        for (int j = 0; j < child.getGuiControls().size(); ++j) {
                            GuiControl control = child.getGuiControls().get(j);
                            control.posX = control.posX - child.lastX + x;
                            control.posY = control.posY - child.lastY + y;
                            box.addControl(control);
                        }
                        child.onSegmentLoaded(x, y, maxWidth);
                    }
                    this.height += child.getHeight() + 5;
                    ++countLoaded;
                }
                ++count;
            }
            if (this.aimedScrollPos != -1) {
                box.scrolled.setStart((double)Math.min(this.height, this.aimedScrollPos));
                if (this.height >= this.aimedScrollPos) {
                    this.aimedScrollPos = -1;
                }
            }
            this.index += count;
            if (this.index >= this.childs.size() && this.element instanceof ConfigBranch) {
                if (this.has("Save")) {
                    this.get("Save").setEnabled(true);
                }
                ((ConfigBranch)this.element).onGuiLoadedAllSegments(this, box, this.childs);
                this.isCreatingControls = false;
            }
        }
    }

    public boolean closeGuiUsingEscape() {
        if (this.element instanceof ConfigBranch && !Minecraft.func_71410_x().func_71356_B()) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)new RequestInformationPacket((ConfigBranch)SubGuiConfigSegement.this.element));
                }
            });
        }
        return true;
    }

    public void createControls() {
        GuiScrollBox box = new GuiScrollBox("scrollbox", 0, 0, 244, 220);
        this.controls.add(box);
        this.controls.add(new GuiButton("Cancel", 0, 228, 50){

            public void onClicked(int x, int y, int button) {
                SubGuiConfigSegement.this.closeGuiUsingEscape();
                if (SubGuiConfigSegement.this.element.parent != null) {
                    IGCMGuiManager.openConfigGui(this.getPlayer(), SubGuiConfigSegement.this.element.parent.getPath());
                } else {
                    SubGuiConfigSegement.this.closeGui();
                }
            }
        });
        if (this.element instanceof ConfigBranch) {
            this.controls.add((GuiControl)new GuiButton("Save", 194, 228, 50){

                public void onClicked(int x, int y, int button) {
                    SubGuiConfigSegement parent = (SubGuiConfigSegement)this.getParent();
                    for (int i = 0; i < parent.childs.size(); ++i) {
                        parent.childs.get(i).saveFromControls();
                    }
                    if (SubGuiConfigSegement.this.element instanceof ConfigBranch) {
                        ((ConfigBranch)SubGuiConfigSegement.this.element).onGuiSavesSegments((SubGuiConfigSegement)this.getParent(), parent.childs);
                        IGCM.sendUpdatePacket((ConfigBranch)SubGuiConfigSegement.this.element);
                    }
                }
            }.setEnabled(false));
        }
        this.controls.add(new GuiTextfield("search", "", 60, 228, 124, 14));
        if (this.element == ConfigTab.root) {
            this.controls.add(new GuiButton("Profiles", 194, 228, 50){

                public void onClicked(int x, int y, int button) {
                    IGCMGuiManager.openProfileGui(SubGuiConfigSegement.this.container.player);
                }
            });
        }
        this.createSegmentControls(true);
    }

    @CustomEventSubscribe
    public void onButtonClicked(GuiControlClickEvent event) {
        if (event.source instanceof GuiSlotControl) {
            if (((GuiSlotControl)event.source).slot instanceof InfoSlotControl) {
                this.openedSlot = (GuiSlotControl)event.source;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("ItemDialog", true);
                nbt.func_74757_a("fullEdit", true);
                this.openNewLayer(nbt);
            } else if (((GuiSlotControl)event.source).slot instanceof SlotControlNoSync) {
                this.openedSlot = (GuiSlotControl)event.source;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("ItemDialog", true);
                nbt.func_74757_a("fullEdit", false);
                this.openNewLayer(nbt);
            }
        }
    }

    public void onLayerClosed(SubGui gui, NBTTagCompound nbt) {
        if (gui instanceof SubGuiFullItemDialog && !nbt.func_74767_n("canceled") && this.openedSlot != null) {
            ((InfoSlotControl)this.openedSlot.slot).putInfo(((SubGuiFullItemDialog)gui).info);
        }
        if (gui instanceof SubGuiItemDialog && !nbt.func_74767_n("canceled") && this.openedSlot != null) {
            this.openedSlot.slot.slot.func_75215_d(((SubGuiItemDialog)gui).stack);
        }
        this.openedSlot = null;
    }

    public SubGui createLayerFromPacket(World world, EntityPlayer player, NBTTagCompound nbt) {
        SubGui gui = super.createLayerFromPacket(world, player, nbt);
        if (!(this.element instanceof ConfigBranch)) {
            return null;
        }
        if (gui == null && nbt.func_74767_n("ItemDialog")) {
            if (nbt.func_74767_n("fullEdit")) {
                SubGuiFullItemDialog dialog = new SubGuiFullItemDialog(((ConfigBranch)this.element).doesInputSupportStackSize());
                dialog.info = ((InfoSlotControl)this.openedSlot.slot).info;
                return dialog;
            }
            SubGuiItemDialog dialog = new SubGuiItemDialog();
            dialog.stack = this.openedSlot.slot.slot.func_75211_c();
            if (dialog.stack != null) {
                dialog.stack = dialog.stack.func_77946_l();
            }
            return dialog;
        }
        return gui;
    }

    @CustomEventSubscribe
    public void onTextfieldChanged(GuiControlChangedEvent event) {
        if (event.source instanceof GuiTextfield && event.source.is(new String[]{"search"})) {
            this.search = ((GuiTextfield)event.source).text.toLowerCase();
            this.createSegmentControls(false);
        }
    }
}

